/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer.https;

import de.destatis.core.connect.GetSurveysRequest;
import de.destatis.core.connect.Response;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.ResponseToGetSurveysRequest;
import de.destatis.core.connect.survey.Survey;
import de.destatis.core.connect.transfer.https.HttpsRequestHandler;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.http.HttpResponse;
import org.apache.http.entity.mime.content.ContentBody;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HttpsGetSurveysRequestHandler
extends HttpsRequestHandler {
    private static final String TAG_SURVEY_LIST = "surveyList";
    private static final String TAG_SURVEY = "survey";
    private static final String ATTR_ERHEBUNGSID = "erhebungsId";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String TAG_EVAS_LIST = "evasList";
    private static final String TAG_EVAS = "evas";
    private static final String ATTR_NAME = "name";
    private static final ClientLogger LOG = ClientLogger.getLogger(HttpsGetSurveysRequestHandler.class);

    public HttpsGetSurveysRequestHandler(GetSurveysRequest request, ClientConfig config) {
        super(request, config);
    }

    @Override
    public String getActionValue() {
        return "get_surveys_connect";
    }

    @Override
    public void addParts(Map<String, ContentBody> partList) {
    }

    @Override
    public Response getResponse(HttpResponse httpResponse) {
        ResponseToGetSurveysRequest response;
        ResponseStatus responseStatus = this.getResponseStatus(httpResponse);
        String responseBody = this.getResponseBody(httpResponse);
        if (responseStatus.equals(ResponseStatus.OK)) {
            try {
                List surveyList = this.parse(responseBody);
                response = new ResponseToGetSurveysRequest(responseStatus, null, surveyList);
            }
            catch (Exception e) {
                LOG.error("Fehlerhaftes XML-Dokument geliefert bekommen oder Fehler beim Parsen des Dokumentes", e);
                response = new ResponseToGetSurveysRequest(ResponseStatus.BAD_RESPONSE, e.getMessage(), null);
            }
        } else {
            response = new ResponseToGetSurveysRequest(responseStatus, responseBody, null);
        }
        return response;
    }

    private List parse(String content) throws Exception {
        XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        SurveyListParser parser = new SurveyListParser();
        reader.setContentHandler(parser);
        reader.setErrorHandler(parser);
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        InputSource input = new InputSource(new StringReader(content));
        reader.parse(input);
        Vector surveyList = parser.getSurveyList();
        if (surveyList == null) {
            surveyList = new Vector(0);
        }
        return surveyList;
    }

    private static final class SurveyListParser
    extends DefaultHandler {
        private List surveyList = null;
        private Survey currentSurvey = null;

        private SurveyListParser() {
        }

        public List getSurveyList() {
            return this.surveyList;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (HttpsGetSurveysRequestHandler.TAG_SURVEY_LIST.equals(qName)) {
                this.surveyList = new Vector(100);
            } else if (HttpsGetSurveysRequestHandler.TAG_SURVEY.equals(qName)) {
                String erhebungsId = attributes.getValue(HttpsGetSurveysRequestHandler.ATTR_ERHEBUNGSID);
                String description = attributes.getValue(HttpsGetSurveysRequestHandler.ATTR_DESCRIPTION);
                Survey survey = new Survey(erhebungsId, description, null);
                this.surveyList.add(survey);
                this.currentSurvey = survey;
            } else if (!HttpsGetSurveysRequestHandler.TAG_EVAS_LIST.equals(qName) && HttpsGetSurveysRequestHandler.TAG_EVAS.equals(qName)) {
                String evas = attributes.getValue(HttpsGetSurveysRequestHandler.ATTR_NAME);
                this.currentSurvey.addEvas(evas);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (HttpsGetSurveysRequestHandler.TAG_SURVEY.equals(qName)) {
                this.currentSurvey = null;
            }
        }

        @Override
        public void error(SAXParseException exc) throws SAXException {
            throw exc;
        }

        @Override
        public void warning(SAXParseException exc) throws SAXException {
            throw exc;
        }
    }
}

