/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.document;

import de.destatis.core.connect.document.DocumentSource;
import de.destatis.core.connect.document.util.ReadXmlEncodingParser;
import de.destatis.core.connect.document.util.ReaderHelper;
import de.destatis.core.connect.util.Contract;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FileDocumentSource
implements DocumentSource {
    private File file;
    private String charset;

    protected FileDocumentSource(File file) {
        this.file = file;
        Contract.verify(this.file != null, "file ist erforderlich");
        Contract.verify(this.file.isFile(), "Datei muss existieren");
        ReadXmlEncodingParser parser = new ReadXmlEncodingParser();
        InputStream in = this.getInputStream();
        try {
            String charset = parser.getEncoding(in);
            if (charset == null) {
                throw new IllegalArgumentException("Der Zeichensatz des XML-Dokuments konnte nicht ermittelt werden.");
            }
            this.charset = charset;
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getEncoding() {
        return this.charset;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public String getContent() {
        InputStream in = null;
        StringBuffer buffer = new StringBuffer();
        try {
            in = this.getInputStream();
            BufferedReader reader = new BufferedReader(ReaderHelper.createReader(in, this.getEncoding()));
            char[] buf = new char[1024];
            int len = 0;
            while ((len = reader.read(buf)) > 0) {
                buffer.append(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable e) {}
            }
        }
        return buffer.toString();
    }

    @Override
    public void release() {
        try {
            this.file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.file = null;
    }
}

