/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.TransferProtocol;
import de.destatis.core.connect.UnsupportedProtocolException;
import de.destatis.core.connect.util.Contract;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class ServerAddress {
    private static final String TEST_HOST_SYSTEM_PROP = "core.connect.serveraddress.test.host";
    private static final String TEST_PORT_SYSTEM_PROP = "core.connect.serveraddress.test.port";
    private static final HashMap values;
    private String name = null;
    private HashMap protocols = new HashMap();
    public static final ServerAddress CORE1;

    public static ServerAddress getInstance(String name) {
        Contract.verify(values.containsKey(name.toUpperCase()), "Ungueltiger Serveradresse angegeben!");
        return (ServerAddress)values.get(name.toUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public TransferProtocol[] getSupportedProtocols() {
        return this.protocols.keySet().toArray(new TransferProtocol[0]);
    }

    public String getHost(TransferProtocol protocol) throws UnsupportedProtocolException {
        String result = null;
        ServerProtocolAddress address = this.getProtocolAddress(protocol);
        if (address == null || address.getURI() == null) {
            throw new UnsupportedProtocolException("Das Protokoll " + protocol + " wird von dem Server " + this.toString() + " nicht unterstuetzt");
        }
        result = address.getURI().getHost();
        return result;
    }

    public URI getURI(TransferProtocol protocol) throws UnsupportedProtocolException {
        URI result = null;
        ServerProtocolAddress address = this.getProtocolAddress(protocol);
        if (address == null || address.getURI() == null) {
            throw new UnsupportedProtocolException("Das Protokoll " + protocol + " wird von dem Server " + this.toString() + " nicht unterstuetzt");
        }
        result = address.getURI();
        return result;
    }

    public URI getTransferURI(TransferProtocol protocol) throws UnsupportedProtocolException {
        URI result = null;
        ServerProtocolAddress address = this.getProtocolAddress(protocol);
        if (address == null || address.getURI() == null) {
            throw new UnsupportedProtocolException("Das Protokoll " + protocol + " wird von dem Server " + this.toString() + " nicht unterstuetzt");
        }
        result = address.getURI();
        return result;
    }

    public String toString() {
        boolean first = true;
        String result = new String();
        for (Map.Entry entry : this.protocols.entrySet()) {
            URI uri = null;
            try {
                uri = this.getTransferURI((TransferProtocol)entry.getKey());
            }
            catch (UnsupportedProtocolException exc) {
                exc.printStackTrace();
            }
            assert (uri != null);
            if (first) {
                first = false;
            } else {
                result = result + ";";
            }
            result = result + entry.getKey().toString();
            result = result + ":";
            result = result + uri.toString();
        }
        return result;
    }

    protected void addProtocol(TransferProtocol protocol, URI uri) {
        Contract.verify(this.protocols.get(protocol) == null, "Das Protokoll existiert bereits");
        this.protocols.put(protocol, new ServerProtocolAddress(uri));
    }

    protected ServerProtocolAddress getProtocolAddress(TransferProtocol protocol) {
        return (ServerProtocolAddress)this.protocols.get(protocol);
    }

    private ServerAddress(String name) {
        this.name = name.toUpperCase();
        values.put(this.name, this);
    }

    private static String getTestHost() {
        String systemPropHost = System.getProperty(TEST_HOST_SYSTEM_PROP);
        String host = systemPropHost != null && systemPropHost.length() > 0 ? systemPropHost : "localhost";
        return host;
    }

    private static int getTestPort() {
        String systemPropPort = System.getProperty(TEST_PORT_SYSTEM_PROP);
        int port = systemPropPort != null && systemPropPort.length() > 0 ? Integer.parseInt(systemPropPort) : 443;
        return port;
    }

    static {
        block2: {
            values = new HashMap();
            CORE1 = new ServerAddress("CORE1");
            try {
                URI core1Uri = new URI("https", null, "core.estatistik.de", 443, "/core/", null, null);
                CORE1.addProtocol(TransferProtocol.HTTPS, core1Uri);
                ServerAddress werum = new ServerAddress("TEST");
                URI werumUri = new URI("https", null, ServerAddress.getTestHost(), ServerAddress.getTestPort(), "/core/", null, null);
                werum.addProtocol(TransferProtocol.HTTPS, werumUri);
            }
            catch (URISyntaxException exc) {
                exc.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private class ServerProtocolAddress {
        private URI uri;

        public ServerProtocolAddress(URI uri) {
            this.uri = uri;
        }

        public URI getURI() {
            return this.uri;
        }
    }
}

