/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.Sets;
import clover.it.unimi.dsi.fastutil.floats.FloatCollection;
import clover.it.unimi.dsi.fastutil.floats.FloatCollections;
import clover.it.unimi.dsi.fastutil.floats.FloatSets;
import clover.it.unimi.dsi.fastutil.objects.AbstractReference2FloatMap;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectSets;
import clover.it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import clover.it.unimi.dsi.fastutil.objects.ReferenceSet;
import clover.it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Reference2FloatMaps {
    public static final EmptyMap EMPTY_MAP = new EmptyMap();

    private Reference2FloatMaps() {
    }

    public static Reference2FloatMap singleton(Object key, float value) {
        return new Singleton(key, value);
    }

    public static Reference2FloatMap singleton(Object key, Object value) {
        return new Singleton(key, ((Float)value).floatValue());
    }

    public static Reference2FloatMap synchronize(Reference2FloatMap m) {
        return new SynchronizedMap(m);
    }

    public static Reference2FloatMap synchronize(Reference2FloatMap m, Object sync) {
        return new SynchronizedMap(m, sync);
    }

    public static Reference2FloatMap unmodifiable(Reference2FloatMap m) {
        return new UnmodifiableMap(m);
    }

    public static class UnmodifiableMap
    extends AbstractReference2FloatMap
    implements Reference2FloatMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2FloatMap map;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected UnmodifiableMap(Reference2FloatMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
        }

        public Object remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return this.map.get(ok);
        }

        public int size() {
            return this.map.size();
        }

        public boolean containsKey(Object k) {
            return this.map.containsKey(k);
        }

        public boolean containsValue(float v) {
            return this.map.containsValue(v);
        }

        public float defaultReturnValue() {
            throw new UnsupportedOperationException();
        }

        public void defaultReturnValue(float defRetValue) {
            throw new UnsupportedOperationException();
        }

        public float put(Object k, float v) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Reference2FloatMap c) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.unmodifiable((ObjectSet)this.map.entrySet());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSets.unmodifiable((ReferenceSet)this.map.keySet());
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return FloatCollections.unmodifiable((FloatCollection)((FloatCollection)this.map.values()));
            }
            return this.values;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.map.toString();
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object ov) {
            return this.map.containsValue(ov);
        }

        public float removeFloat(Object k) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(Object k) {
            return this.map.getFloat(k);
        }
    }

    public static class SynchronizedMap
    extends AbstractReference2FloatMap
    implements Reference2FloatMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2FloatMap map;
        protected final Object sync;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected SynchronizedMap(Reference2FloatMap m, Object sync) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = sync;
        }

        protected SynchronizedMap(Reference2FloatMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.remove(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.get(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(float v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float defaultReturnValue() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.defaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void defaultReturnValue(float defRetValue) {
            Object object = this.sync;
            synchronized (object) {
                this.map.defaultReturnValue(defRetValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float put(Object k, float v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Reference2FloatMap c) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map m) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(m);
            }
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.synchronize((ObjectSet)this.map.entrySet(), this.sync);
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSets.synchronize((ReferenceSet)this.map.keySet(), this.sync);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return FloatCollections.synchronize((FloatCollection)((FloatCollection)this.map.values()), (Object)this.sync);
            }
            return this.values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object k, Object v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object ov) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(ov);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float removeFloat(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.removeFloat(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getFloat(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.getFloat(k);
            }
        }
    }

    public static class Singleton
    extends AbstractReference2FloatMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Object key;
        protected final float value;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected Singleton(Object key, float value) {
            this.key = key;
            this.value = value;
        }

        public boolean containsKey(Object k) {
            return this.key == k;
        }

        public boolean containsValue(float v) {
            return this.value == v;
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.singleton(new SingletonEntry());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSets.singleton(this.key);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = FloatSets.singleton((float)this.value);
            }
            return this.values;
        }

        public float getFloat(Object k) {
            if (this.key == k) {
                return this.value;
            }
            return this.defRetValue;
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }

        private class SingletonEntry
        implements Reference2FloatMap.Entry {
            private SingletonEntry() {
            }

            public Object getKey() {
                return Singleton.this.key;
            }

            public Object getValue() {
                return new Float(Singleton.this.value);
            }

            public float getFloatValue() {
                return Singleton.this.value;
            }

            public float setValue(float value) {
                throw new UnsupportedOperationException();
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Singleton.this.key == e.getKey() && Singleton.this.value == ((Float)e.getValue()).floatValue();
            }

            public int hashCode() {
                return System.identityHashCode(Singleton.this.key) ^ HashCommon.float2int(Singleton.this.value);
            }

            public String toString() {
                return Singleton.this.key + "->" + Singleton.this.value;
            }
        }
    }

    public static class EmptyMap
    extends AbstractReference2FloatMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptyMap() {
        }

        public float put(Object k, float v) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return null;
        }

        public boolean containsKey(Object k) {
            return false;
        }

        public boolean containsValue(float v) {
            return false;
        }

        public float defaultReturnValue() {
            return 0.0f;
        }

        public void defaultReturnValue(float defRetValue) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            return Sets.EMPTY_SET;
        }

        public Set keySet() {
            return Sets.EMPTY_SET;
        }

        public Collection values() {
            return Sets.EMPTY_SET;
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object ov) {
            return false;
        }

        public float getFloat(Object k) {
            return 0.0f;
        }

        public int size() {
            return 0;
        }

        public void clear() {
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        public Object clone() {
            return EMPTY_MAP;
        }
    }
}

