/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.tools.plugins;

import clover.com.lowagie.text.pdf.PRStream;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfReader;
import clover.com.lowagie.text.pdf.PdfStream;
import clover.com.lowagie.tools.SwingWorker;
import clover.com.lowagie.tools.arguments.FileArgument;
import clover.com.lowagie.tools.arguments.PdfFilter;
import clover.com.lowagie.tools.arguments.ToolArgument;
import clover.com.lowagie.tools.plugins.AbstractTool;
import clover.com.lowagie.tools.plugins.InspectPDF;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageXRefViewer
extends AbstractTool {
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    int picturenumber = 0;
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    CardLayout cardLayout1 = new CardLayout();
    JPanel jPanel3 = new JPanel();
    JSpinner jSpinner1 = new JSpinner();
    BorderLayout borderLayout3 = new BorderLayout();
    SpinnerModel spinnerModel1 = this.jSpinner1.getModel();
    JScrollPane jScrollPane1 = new JScrollPane();

    static {
        ImageXRefViewer.addVersion("$Id: ImageXRefViewer.java,v 1.4 2006/09/14 23:10:57 xlv Exp $");
    }

    public ImageXRefViewer() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("View Image XObjects", true, false, true);
        this.internalFrame.setSize(500, 300);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("images");
        this.jPanel2.setLayout(this.cardLayout1);
        this.jPanel3.setLayout(this.borderLayout3);
        this.jSpinner1.addChangeListener(new ViewXRefImages_jSpinner1_propertyChangeAdapter(this));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.internalFrame.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel3.add((Component)this.jSpinner1, "Center");
        this.jPanel3.add((Component)this.jLabel1, "North");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.setViewportView(this.jPanel2);
        System.out.println("=== Image XObject Viewer OPENED ===");
    }

    public void valueHasChanged(ToolArgument arg) {
    }

    public void jSpinner_propertyChange(ChangeEvent evt) {
        int blatt = Integer.parseInt(this.jSpinner1.getValue().toString());
        if (blatt < 0) {
            blatt = 0;
        }
        if (blatt >= this.picturenumber) {
            blatt = this.picturenumber - 1;
        }
        this.cardLayout1.show(this.jPanel2, String.valueOf(blatt));
        this.jPanel2.repaint();
    }

    public static void main(String[] args) {
        InspectPDF tool = new InspectPDF();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    public void execute() {
        this.picturenumber = 0;
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            SwingWorker work = new SwingWorker(){

                public Object construct() {
                    try {
                        PdfReader reader = new PdfReader(((File)ImageXRefViewer.this.getValue("srcfile")).getAbsolutePath());
                        int i = 0;
                        while (i < reader.getXrefSize()) {
                            PdfStream pdfdict;
                            PdfObject pdfsubtype;
                            PdfObject pdfobj = reader.getPdfObject(i);
                            if (pdfobj != null && pdfobj.isStream() && (pdfsubtype = (pdfdict = (PdfStream)pdfobj).get(PdfName.SUBTYPE)) != null && pdfsubtype.toString().equals(PdfName.IMAGE.toString())) {
                                System.out.println("picturenumber: " + ImageXRefViewer.this.picturenumber);
                                System.out.println("height:" + pdfdict.get(PdfName.HEIGHT));
                                System.out.println("width:" + pdfdict.get(PdfName.WIDTH));
                                System.out.println("bitspercomponent:" + pdfdict.get(PdfName.BITSPERCOMPONENT));
                                byte[] barr = PdfReader.getStreamBytesRaw((PRStream)pdfdict);
                                Image im = Toolkit.getDefaultToolkit().createImage(barr);
                                ImageIcon ii = new ImageIcon(im);
                                JLabel jLabel1 = new JLabel();
                                jLabel1.setIcon(ii);
                                ImageXRefViewer.this.jPanel2.add((Component)jLabel1, "" + ImageXRefViewer.this.picturenumber++);
                            }
                            ++i;
                        }
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ImageXRefViewer.this.internalFrame.setCursor(Cursor.getDefaultCursor());
                    return null;
                }
            };
            this.internalFrame.setCursor(Cursor.getPredefinedCursor(3));
            work.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    class ViewXRefImages_jSpinner1_propertyChangeAdapter
    implements ChangeListener {
        private ImageXRefViewer adaptee;

        ViewXRefImages_jSpinner1_propertyChangeAdapter(ImageXRefViewer adaptee) {
            this.adaptee = adaptee;
        }

        public void stateChanged(ChangeEvent e) {
            this.adaptee.jSpinner_propertyChange(e);
        }
    }
}

