/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.Document;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.pdf.BadPdfFormatException;
import clover.com.lowagie.text.pdf.ByteBuffer;
import clover.com.lowagie.text.pdf.PRIndirectReference;
import clover.com.lowagie.text.pdf.PRStream;
import clover.com.lowagie.text.pdf.PdfCopy;
import clover.com.lowagie.text.pdf.PdfIndirectReference;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class PdfSmartCopy
extends PdfCopy {
    private HashMap streamMap = new HashMap();

    public PdfSmartCopy(Document document, OutputStream os) throws DocumentException {
        super(document, os);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfIndirectReference theRef;
        PdfIndirectReference streamRef;
        PdfObject srcObj = PdfReader.getPdfObjectRelease(in);
        ByteStore streamKey = null;
        if (srcObj.type == 7 && (streamRef = (PdfIndirectReference)this.streamMap.get(streamKey = new ByteStore((PRStream)srcObj))) != null) {
            return streamRef;
        }
        PdfCopy.RefKey key = new PdfCopy.RefKey(in);
        PdfCopy.IndirectReferences iRef = (PdfCopy.IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new PdfCopy.IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        iRef.setCopied();
        if (srcObj.type == 7) {
            this.streamMap.put(streamKey, theRef);
        }
        PdfObject obj = this.copyObject(srcObj);
        this.addToBody(obj, theRef);
        return theRef;
    }

    static class ByteStore {
        private byte[] b;
        private int hash;

        ByteStore(PRStream str) throws IOException {
            byte[] streamContent = PdfReader.getStreamBytesRaw(str);
            Object[] keys = str.getKeys().toArray();
            Arrays.sort(keys);
            ByteBuffer bb = new ByteBuffer();
            int k = 0;
            while (k < keys.length) {
                bb.append(keys[k].toString());
                ++k;
            }
            bb.append(streamContent);
            this.b = bb.toByteArray();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ByteStore)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return Arrays.equals(this.b, ((ByteStore)obj).b);
        }

        public int hashCode() {
            if (this.hash == 0) {
                int len = this.b.length;
                int k = 0;
                while (k < len) {
                    this.hash = this.hash * 31 + (this.b[k] & 0xFF);
                    ++k;
                }
            }
            return this.hash;
        }
    }
}

