/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonArray;
import clover.com.google.gson.JsonArrayDeserializationVisitor;
import clover.com.google.gson.JsonDeserializationContext;
import clover.com.google.gson.JsonDeserializer;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonObjectDeserializationVisitor;
import clover.com.google.gson.ObjectConstructor;
import clover.com.google.gson.ObjectNavigator;
import clover.com.google.gson.ObjectNavigatorFactory;
import clover.com.google.gson.ParameterizedTypeHandlerMap;
import clover.com.google.gson.Preconditions;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsonDeserializationVisitor<T>
implements ObjectNavigator.Visitor {
    protected final ObjectNavigatorFactory factory;
    protected final ObjectConstructor objectConstructor;
    protected final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    protected T target;
    protected final JsonElement json;
    protected final Type targetType;
    protected final JsonDeserializationContext context;

    public JsonDeserializationVisitor(JsonElement json, Type targetType, ObjectNavigatorFactory factory, ObjectConstructor objectConstructor, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, JsonDeserializationContext context) {
        Preconditions.checkNotNull(json);
        this.targetType = targetType;
        this.factory = factory;
        this.objectConstructor = objectConstructor;
        this.deserializers = deserializers;
        this.json = json;
        this.context = context;
    }

    public T getTarget() {
        if (this.target == null) {
            this.target = this.constructTarget();
        }
        return this.target;
    }

    protected abstract T constructTarget();

    @Override
    public final boolean visitUsingCustomHandler(Object obj, Type objType) {
        JsonDeserializer<?> deserializer = this.deserializers.getHandlerFor(objType);
        if (deserializer != null) {
            this.target = deserializer.deserialize(this.json, objType, this.context);
            return true;
        }
        return false;
    }

    final Object visitChildAsObject(Type childType, JsonElement jsonChild) {
        JsonObjectDeserializationVisitor childVisitor = new JsonObjectDeserializationVisitor(jsonChild, childType, this.factory, this.objectConstructor, this.deserializers, this.context);
        return this.visitChild(childType, childVisitor);
    }

    final Object visitChildAsArray(Type childType, JsonArray jsonChild) {
        JsonArrayDeserializationVisitor childVisitor = new JsonArrayDeserializationVisitor(jsonChild.getAsJsonArray(), childType, this.factory, this.objectConstructor, this.deserializers, this.context);
        return this.visitChild(childType, childVisitor);
    }

    private Object visitChild(Type type, JsonDeserializationVisitor<?> childVisitor) {
        ObjectNavigator on = this.factory.create(null, type);
        on.accept(childVisitor);
        return childVisitor.getTarget();
    }
}

