/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonArray;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonElementVisitor;
import clover.com.google.gson.JsonEscapingVisitor;
import clover.com.google.gson.JsonFormatter;
import clover.com.google.gson.JsonObject;
import clover.com.google.gson.JsonPrimitive;
import clover.com.google.gson.JsonTreeNavigator;
import java.io.IOException;

final class JsonCompactFormatter
implements JsonFormatter {
    private final boolean escapeHtmlChars;

    JsonCompactFormatter() {
        this(true);
    }

    JsonCompactFormatter(boolean escapeHtmlChars) {
        this.escapeHtmlChars = escapeHtmlChars;
    }

    public void format(JsonElement root, Appendable writer, boolean serializeNulls) throws IOException {
        if (root == null) {
            return;
        }
        JsonEscapingVisitor visitor = new JsonEscapingVisitor((JsonElementVisitor)new FormattingVisitor(writer, serializeNulls), this.escapeHtmlChars);
        JsonTreeNavigator navigator = new JsonTreeNavigator(visitor, serializeNulls);
        navigator.navigate(root);
    }

    private static class FormattingVisitor
    implements JsonElementVisitor {
        private final Appendable writer;
        private final boolean serializeNulls;

        FormattingVisitor(Appendable writer, boolean serializeNulls) {
            this.writer = writer;
            this.serializeNulls = serializeNulls;
        }

        public void visitPrimitive(JsonPrimitive primitive) throws IOException {
            primitive.toString(this.writer);
        }

        public void visitNull() throws IOException {
            this.writer.append("null");
        }

        public void startArray(JsonArray array) throws IOException {
            this.writer.append('[');
        }

        public void visitArrayMember(JsonArray parent, JsonPrimitive member, boolean isFirst) throws IOException {
            if (!isFirst) {
                this.writer.append(',');
            }
            member.toString(this.writer);
        }

        public void visitArrayMember(JsonArray parent, JsonArray member, boolean isFirst) throws IOException {
            if (!isFirst) {
                this.writer.append(',');
            }
        }

        public void visitArrayMember(JsonArray parent, JsonObject member, boolean isFirst) throws IOException {
            if (!isFirst) {
                this.writer.append(',');
            }
        }

        public void visitNullArrayMember(JsonArray parent, boolean isFirst) throws IOException {
            if (!isFirst) {
                this.writer.append(',');
            }
        }

        public void endArray(JsonArray array) throws IOException {
            this.writer.append(']');
        }

        public void startObject(JsonObject object) throws IOException {
            this.writer.append('{');
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonPrimitive member, boolean isFirst) throws IOException {
            if (!isFirst) {
                this.writer.append(',');
            }
            this.writer.append('\"');
            this.writer.append(memberName);
            this.writer.append("\":");
            member.toString(this.writer);
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonArray member, boolean isFirst) throws IOException {
            if (!isFirst) {
                this.writer.append(',');
            }
            this.writer.append('\"');
            this.writer.append(memberName);
            this.writer.append("\":");
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonObject member, boolean isFirst) throws IOException {
            if (!isFirst) {
                this.writer.append(',');
            }
            this.writer.append('\"');
            this.writer.append(memberName);
            this.writer.append("\":");
        }

        public void visitNullObjectMember(JsonObject parent, String memberName, boolean isFirst) throws IOException {
            if (this.serializeNulls) {
                this.visitObjectMember(parent, memberName, (JsonObject)null, isFirst);
            }
        }

        public void endObject(JsonObject object) throws IOException {
            this.writer.append('}');
        }
    }
}

