/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.util;

import java.awt.Color;

public class ColorHelper {
    private ColorHelper() {
    }

    public static final Color getColor(String hexString) {
        try {
            if (hexString == null || hexString.length() < 7) {
                return Color.black;
            }
            int red = Integer.parseInt(hexString.substring(1, 3), 16);
            int green = Integer.parseInt(hexString.substring(3, 5), 16);
            int blue = Integer.parseInt(hexString.substring(5, 7), 16);
            int alpha = 0;
            if (hexString.length() > 8) {
                alpha = Integer.parseInt(hexString.substring(7, 9), 16);
            }
            if (alpha > 0) {
                return new Color(red, green, blue, alpha);
            }
            return new Color(red, green, blue);
        }
        catch (NumberFormatException nfe) {
            return Color.black;
        }
    }
}

