/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.lowagie.text.DocumentException;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.CryptUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.FileUtils;
import de.memtext.util.NumberUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.memtext.util.TimeUtils;
import de.superx.common.ChartCreator;
import de.superx.common.DBServletException;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.Maske;
import de.superx.common.ObligatoryFieldEmptyException;
import de.superx.common.SichtException;
import de.superx.common.Stylesheet;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.MaskenContainer;
import de.superx.servlet.PreparedXmlProcessor;
import de.superx.servlet.ServletBasics;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SichtChanger;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SuperXmlAnmeldung;
import de.superx.servlet.SxJasperDataSource;
import de.superx.servlet.SxPools;
import de.superx.servlet.XmlTransformer;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SuperXmlTabelle
extends AbstractSuperXServlet {
    private static final long serialVersionUID = 1L;
    TimeUtils tutil = new TimeUtils();
    public static int maxOffset = 30;
    private static final int MAX_MACRO = 20;
    private static int cacheSecs = 300;
    private final String STYLESHEET_XML = "tabelle_xml.xsl";
    private final String STYLESHEET_PDF = "tabelle_pdf.xsl";
    private final String STYLESHEET_RTF = "tabelle_rtf.xsl";
    private final String STYLESHEET_TXT = "tabelle_text.xsl";
    protected TransformerFactory tFactory;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ChartCreator.initPath(this.getServletConfig().getServletContext().getRealPath("xml"));
        this.tFactory = TransformerFactory.newInstance();
        String mxr = config.getInitParameter("maxRows");
        mxr = config.getInitParameter("maxOffset");
        maxOffset = mxr == null || mxr.equals("") ? 30 : Integer.parseInt(mxr);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SuperXmlTabelle.setEncoding(request);
        if (request.getParameter("checkFor") != null) {
            this.checkFor(request, response);
        } else {
            this.checkCacheClearing(request);
            this.checkAnmeldungImRequest(request);
            if (SichtChanger.isSichtChangeWanted(request)) {
                SichtChanger sichtChanger = new SichtChanger(request, response, true);
                sichtChanger.run(true);
            } else if (ServletHelper.getParameter(request, "getKidRows") != null) {
                KidRowsResponder kr = new KidRowsResponder(request, response);
                kr.run(true);
            } else if (ServletHelper.getParameter(request, "getChart") != null) {
                this.getChartResponse(request, response);
            } else {
                if (!this.hasProperSession(request) && !SuperXmlAnmeldung.isRemoteLoginUsed && ServletHelper.getParameter(request, "tid") != null) {
                    this.erstmalAnmelden("SuperXmlTabelle", request, response);
                }
                TableCreator tc = new TableCreator(request, response);
                tc.run(true);
            }
        }
    }

    private void getChartResponse(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String classname = ServletHelper.getParameter(request, "class");
        if (classname == null || classname.equals("")) {
            throw new IllegalArgumentException("Parameter class missing");
        }
        try {
            Object[] constr = new Object[]{request, response};
            Class<?> grafclass = Class.forName(classname);
            Class[] classparams = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
            Constructor<?> con = grafclass.getConstructor(classparams);
            SuperXServletHelper graphHelper = (SuperXServletHelper)con.newInstance(constr);
            graphHelper.run(true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ServletException("Problem bei Grafikerzeugung :\n" + e2);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("getKidRows") != null) {
            throw new ServletException("HTTP-Get not allowed for Ajax requests");
        }
        if (request.getParameter("checkFor") != null) {
            this.checkFor(request, response);
        } else {
            this.doPost(request, response);
        }
    }

    private void checkFor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String tidString = this.getTid(request);
        int i2 = 0;
        String isSent = (String)request.getSession().getAttribute(String.valueOf(tidString) + "-isSent");
        while (!EqualsUtil.areEqual(isSent, "true") && i2 < 10) {
            isSent = (String)request.getSession().getAttribute(String.valueOf(tidString) + "-isSent");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i2;
        }
        response.getWriter().write("done");
    }

    public String getServletInfo() {
        return "SuperXTabelle 4.0";
    }

    private class JasperCreator
    extends ServletBasics {
        private String exportname;
        private String jrxml_file;
        private String contenttype;
        private String reports_dir;
        private String outfile_jasper;
        private SxUser user;
        private String tmp_jrxml;

        JasperCreator(HttpServletRequest request, HttpServletResponse response, SxUser user, Maske maske, String jrxml_file, String contenttype) throws IOException, JRException {
            super(request, response, "superx");
            this.user = user;
            this.jrxml_file = jrxml_file;
            this.contenttype = contenttype;
            this.exportname = maske.getExportName();
            this.reports_dir = String.valueOf(SuperXmlTabelle.this.getServletConfig().getServletContext().getRealPath("WEB-INF/reports")) + System.getProperty("file.separator");
            this.compileReport(maske);
        }

        private void compileReport(Maske maske) throws IOException, JRException {
            File myjrxml = new File(String.valueOf(this.reports_dir) + this.jrxml_file);
            if (!myjrxml.exists()) {
                throw new IOException("jrxml-Datei " + this.reports_dir + this.jrxml_file + " nicht gefunden");
            }
            if (this.jrxml_file.indexOf("_freem") > -1) {
                this.fmparse(maske, myjrxml);
            } else {
                this.outfile_jasper = String.valueOf(this.reports_dir) + this.jrxml_file.substring(0, this.jrxml_file.lastIndexOf(".")) + ".jasper";
            }
            File myjasper = new File(this.outfile_jasper);
            if (!myjasper.exists() || myjasper.lastModified() <= myjrxml.lastModified()) {
                JasperCompileManager.compileReportToFile((String)(String.valueOf(this.reports_dir) + this.jrxml_file), (String)this.outfile_jasper);
            }
        }

        private void fmparse(Maske maske, File myjrxml) throws IOException, JRException {
            this.tmp_jrxml = "tmp_" + NumberUtils.getRandomInt(1000000) + "_" + this.jrxml_file;
            this.outfile_jasper = String.valueOf(this.reports_dir) + this.tmp_jrxml.substring(0, this.tmp_jrxml.lastIndexOf(".")) + ".jasper";
            this.deleteTmp();
            String vorlage = StringUtils.readFile(myjrxml);
            try {
                vorlage = maske.fmProcess(this.user, vorlage);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new JRException("Fehler beim Freemarker-Parsen von " + myjrxml + "\n" + e2);
            }
            StringUtils.write(new File(String.valueOf(this.reports_dir) + this.tmp_jrxml), vorlage);
            JasperCompileManager.compileReportToFile((String)(String.valueOf(this.reports_dir) + this.tmp_jrxml), (String)this.outfile_jasper);
        }

        private void deleteTmp() {
            if (this.outfile_jasper.indexOf("tmp_") > -1) {
                File f2 = new File(String.valueOf(this.reports_dir) + this.tmp_jrxml);
                if (f2.exists()) {
                    f2.delete();
                }
                if ((f2 = new File(this.outfile_jasper)).exists()) {
                    f2.delete();
                }
            }
        }

        protected void perform(String mandantenID, String dataxml) throws JRException, IOException {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            InputSource is = new InputSource(new StringReader(dataxml));
            Document document = JRXmlUtils.parse((InputSource)is);
            parameters.put("XML_DATA_DOCUMENT", document);
            parameters.put("XML_DATE_PATTERN", "dd.MM.yyyy");
            parameters.put("XML_NUMBER_PATTERN", "###0.##");
            parameters.put("XML_LOCALE", Locale.ENGLISH);
            parameters.put("REPORT_LOCALE", Locale.GERMAN);
            this.runExport(mandantenID, parameters, null);
        }

        protected void perform(String mandantenID, Maske maske) throws JRException, IOException {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("REPORT_LOCALE", Locale.GERMAN);
            SxJasperDataSource ds = new SxJasperDataSource(mandantenID, this.getDesiredLocale(), this.user, maske);
            parameters.put("DataFile", "SxJasperDataSource.java");
            this.runExport(mandantenID, parameters, ds);
        }

        private void runExport(String mandantenID, Map parameters, SxJasperDataSource ds) throws JRException, IOException {
            if (this.contenttype == null) {
                throw new IllegalArgumentException("Can't create jasper report, no contenttype found");
            }
            if (this.contenttype.equals("application/vnd.ms-excel") || this.contenttype.startsWith("application/rtf") || this.contenttype.startsWith("application/msword")) {
                parameters.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            }
            Logger.getLogger("superx_" + mandantenID).log(Level.FINE, " erzeuge JasperReport " + this.jrxml_file + " Datenquelle " + (ds == null ? "XML" : "JavaObjects") + " mit contenttype " + this.contenttype);
            JasperPrint jasperprint = null;
            jasperprint = ds == null ? JasperFillManager.fillReport((String)this.outfile_jasper, (Map)parameters) : JasperFillManager.fillReport((String)this.outfile_jasper, (Map)parameters, (JRDataSource)ds);
            ServletOutputStream sos = this.response.getOutputStream();
            String attach = "attachment; filename=" + FileUtils.removeProblemChars(this.exportname);
            this.response.setContentType(this.contenttype);
            if (this.contenttype.startsWith("application/pdf")) {
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".pdf");
                JasperExportManager.exportReportToPdfStream((JasperPrint)jasperprint, (OutputStream)sos);
            } else if (this.contenttype.startsWith("application/rtf") || this.contenttype.startsWith("application/msword")) {
                this.response.setContentType("application/rtf");
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".rtf");
                JRRtfExporter exporter = new JRRtfExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.exportReport();
            } else if (this.contenttype.equals("application/vnd.ms-excel")) {
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".xls");
                JRXlsExporter exporter = new JRXlsExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
                String[] sheetNames = new String[]{"Tabelle1", "Tabelle2", "Tabelle3", "Tabelle4", "Tabelle5", "Tabelle6", "Tabelle7", "Tabelle8", "Tabelle9", "Tabelle10", "Tabelle11", "Tabelle12", "Tabelle13"};
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.SHEET_NAMES, (Object)sheetNames);
                exporter.exportReport();
            } else if (this.contenttype.equals("application/vnd.oasis.opendocument.text")) {
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".odt");
                JROdtExporter exporter = new JROdtExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.exportReport();
            } else if (this.contenttype.equals("application/vnd.oasis.opendocument.spreadsheet")) {
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".ods");
                JROdtExporter exporter = new JROdtExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
                exporter.exportReport();
            } else if (this.contenttype.equals("text/html")) {
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".htm");
                JRHtmlExporter exporter = new JRHtmlExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.exportReport();
            } else if (this.contenttype.equals("text/xhtml")) {
                this.response.setContentType("text/html");
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".htm");
                JRXhtmlExporter exporter = new JRXhtmlExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.exportReport();
            } else if (this.contenttype.equals("text/csv")) {
                this.response.setContentType("text/plain");
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".csv");
                JRCsvExporter exporter = new JRCsvExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.exportReport();
            } else if (this.contenttype.equals("text/plain")) {
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".txt");
                JRTextExporter exporter = new JRTextExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.exportReport();
            } else if (this.contenttype.equals("text/xml")) {
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".xml");
                JRXmlExporter exporter = new JRXmlExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.exportReport();
            } else if (this.contenttype.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".xlsx");
                JRXlsxExporter exporter = new JRXlsxExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
                exporter.exportReport();
            } else if (this.contenttype.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                this.response.setHeader("Content-disposition", String.valueOf(attach) + ".docx");
                JRDocxExporter exporter = new JRDocxExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperprint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)sos);
                exporter.exportReport();
            } else {
                this.response.setContentType("text/html");
                Logger.getLogger("superx_" + mandantenID).log(Level.SEVERE, " Kann JasperReport nicht erzeugen, contentype unbekannt " + SuperXmlTabelle.this.tutil.getSinceStart());
                throw new JRException("Kein bekanntes Ausgabeformat:" + this.contenttype);
            }
            this.deleteTmp();
            Logger.getLogger("superx_" + mandantenID).log(Level.FINER, " schicken des JasperReport an Client " + SuperXmlTabelle.this.tutil.getSinceStart());
            sos.flush();
        }
    }

    private class KidRowsResponder
    extends SuperXServletHelper {
        private Maske maske;
        private SxUser user;

        public KidRowsResponder(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.user = (SxUser)request.getSession().getAttribute("user");
            this.setAjaxResponder(true);
        }

        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException {
            if (this.user == null) {
                throw new IllegalStateException("Kein user (SxUser-Objekt) in der Session gefunden!");
            }
            this.userid = this.request.getSession().getAttribute("UserID").toString();
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            this.maske = mc.getMaske(tidString);
            if (this.maske == null) {
                throw new IllegalStateException("Es wurde versucht, per AJAX Daten nachzuladen, ohne, dass die Maske geladen wurde");
            }
            String rowkids = ServletHelper.getParameter(this.request, "getKidRows");
            String treetableid = ServletHelper.getParameter(this.request, "treetableid");
            int row = Integer.parseInt(rowkids);
            StringBuffer xml = new StringBuffer("<?xml version=\"1.0\"  encoding=\"" + SqlStringUtils.getEncoding() + "\"?>\n<ergebnisse isMakro=\"false\">\n<sqlerg>");
            xml.append(this.maske.getKidRows(treetableid, row));
            xml.append("</sqlerg>\n</ergebnisse>");
            Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.FINE, "   treetable rows\n" + xml);
            XmlTransformer xmlTransformer = new XmlTransformer(SuperXmlTabelle.this.getServletConfig(), this.request, this.response, this.getMandantenID(), this.getBrowser());
            String xsl = "tabelle_html_rows.xsl";
            if (this.maske.getChartx() != null && this.maske.getChartx().endsWith(".xsl")) {
                xsl = this.maske.getChartx();
            }
            xmlTransformer.transform(this.maske.getName(), null, xml.toString(), this.getDesiredLocale(), xsl, "", "false");
        }

        @Override
        public void sendNotAuthorized() throws IOException {
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            PrintWriter p = this.response.getWriter();
            String msg = ServletUtils.getJSONErrorText(this.userid, this.getDesiredLocale());
            System.out.println(msg);
            p.print(msg);
            p.close();
        }
    }

    private class TableCreator
    extends SuperXServletHelper {
        private Hashtable formular;
        private StringBuffer msgAboutEmptyFields;
        private Maske maske;
        private Stylesheet mainStylesheet;
        private Locale desiredLocale;
        private SxUser sxuser;

        TableCreator(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.formular = new Hashtable();
        }

        private void checkUserAndMaskAuthentification() {
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            this.sxuser = (SxUser)this.request.getSession().getAttribute("user");
            if (this.sxuser == null) {
                throw new IllegalStateException("Kein user (SxUser-Objekt) in der Session gefunden!");
            }
            this.sxuser.checkAuthentificationForMask(tidString);
        }

        @Override
        protected void perform() throws ParserConfigurationException, FactoryConfigurationError, SAXException, TransformerException, SQLException, NumberFormatException, TemplateException, IOException, InvalidKeyException, ParseException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException, ServletException {
            this.checkUserAndMaskAuthentification();
            this.desiredLocale = this.getDesiredLocale();
            boolean isClassicRunNeeded = true;
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            String preparedxmlfileappendix = ServletHelper.getParameter(this.request, "preparedxmlfileappendix");
            if (preparedxmlfileappendix != null) {
                String filename;
                String contenttype = ServletHelper.getParameter(this.request, "contenttype");
                PreparedXmlProcessor px = new PreparedXmlProcessor(SuperXmlTabelle.this.getServletConfig(), this.request, this.response, this.getMandantenID(), this.getBrowser());
                if (px.isFileOk(filename = this.sxuser.getId() + "_" + tidString + "_" + preparedxmlfileappendix + ".xml", ServletHelper.getParameter(this.request, "preparedxmlnotolderthan"))) {
                    boolean success = px.process(filename, ServletHelper.getParameter(this.request, "stylesheet"), contenttype, ServletHelper.getParameter(this.request, "preparedxmlencrypted"));
                    boolean bl = isClassicRunNeeded = !success;
                }
            }
            if (isClassicRunNeeded) {
                this.classicRun();
            }
        }

        private void loadMask() throws CloneNotSupportedException, TemplateException, KeyParentEqualException, SichtException, IOException, SQLException, DBServletException, ParseException, UngueltigeEingabeException, TransformerException, NumberFormatException, NoMainEntryException, InvalidDataTypeException {
            String tidString = SuperXmlTabelle.this.getTid(this.request);
            this.userid = this.request.getSession().getAttribute("UserID").toString();
            SxUser user = (SxUser)this.request.getSession().getAttribute("user");
            this.formular.put("UserID", this.userid);
            this.formular.put("locale", this.desiredLocale.getLanguage());
            this.request.getSession().setAttribute(String.valueOf(tidString) + "-isSent", (Object)"false");
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            String cm = ServletHelper.getParameter(this.request, "cachingcontrol");
            if (cm != null && cm.toLowerCase().equals("clearmask")) {
                mc.removeMaske(tidString);
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " removing cached mask " + tidString);
            } else {
                this.maske = mc.getMaske(tidString);
            }
            SuperXmlTabelle.this.tutil.start();
            if (this.maske == null) {
                if (SxPools.get(this.getMandantenID()).hasMaske(new Integer(tidString))) {
                    this.maske = SxPools.get(this.getMandantenID()).getMaskenclone(new Integer(tidString));
                    Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " using mask clone");
                } else {
                    this.maske = new Maske(this.getMandantenID(), user, new Integer(tidString), this.desiredLocale);
                }
                this.maske.setFieldDefaults(this.sxuser, this.request);
                mc.addMaske(this.maske);
            }
        }

        private void classicRun() throws CloneNotSupportedException, TransformerConfigurationException, TemplateException, KeyParentEqualException, SichtException, IOException, DBServletException, ParseException, InvalidKeyException, TransformerException, FactoryConfigurationError, ParserConfigurationException, UngueltigeEingabeException, NoMainEntryException, NumberFormatException, InvalidDataTypeException, ServletException {
            try {
                block22: {
                    this.loadMask();
                    String contenttype = ServletHelper.getParameter(this.request, "contenttype");
                    if (contenttype != null && (contenttype.indexOf("excel") > -1 || contenttype.startsWith("application/pdf")) && this.maske.isMaxRowsReached()) {
                        this.sendBackHtml("<html><body><h2>Achtung</h2><p>Datenmenge ist zu gro\u00df - bitte schr\u00e4nken Sie Ihre Abfrage ggfs. st\u00e4rker ein</p></body></html>");
                    } else {
                        String closeHeader;
                        String openHeader;
                        if (ServletHelper.getParameter(this.request, "maxoffset") != null && !ServletHelper.getParameter(this.request, "maxoffset").equals("")) {
                            this.maske.setMaxOffset(Integer.parseInt(ServletHelper.getParameter(this.request, "maxoffset")));
                        } else if (contenttype != null && contenttype.indexOf("html") == -1) {
                            this.maske.setMaxOffset(10000000);
                        } else {
                            this.maske.setMaxOffset(maxOffset);
                        }
                        this.maske.setOffset(this.getOffset(contenttype));
                        boolean isReuseResult = false;
                        String reuse = ServletHelper.getParameter(this.request, "reuseresult");
                        if (reuse != null && reuse.equals("true")) {
                            isReuseResult = true;
                        }
                        if ((openHeader = ServletHelper.getParameter(this.request, "openHeader")) != null) {
                            this.maske.openHeader(openHeader);
                            isReuseResult = true;
                        }
                        if ((closeHeader = ServletHelper.getParameter(this.request, "closeHeader")) != null) {
                            this.maske.closeHeader(closeHeader);
                            isReuseResult = true;
                        }
                        this.maske.setReuseResult(isReuseResult);
                        this.maske.resetTableStylesheet();
                        if (ServletHelper.getParameter(this.request, "stylesheet") != null && !ServletHelper.getParameter(this.request, "stylesheet").toString().trim().equals("")) {
                            this.maske.setSelectedTableStylesheetFileAndContenttype(ServletHelper.getParameter(this.request, "stylesheet"));
                        }
                        if (contenttype != null && !contenttype.equals("")) {
                            this.maske.setDesiredContenttype(contenttype);
                        }
                        SuperXManager.clearLog();
                        this.currentXml = this.maske.runQuery(this.sxuser, this.request).toString();
                        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.FINE, "--Ergebnis\n" + this.currentXml);
                        SuperXManager.setLastXml(this.currentXml);
                        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "Ergebnisxml:\n" + this.currentXml);
                        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " ausf\u00fchren der Abfrage " + SuperXmlTabelle.this.tutil.getSinceStart());
                        SuperXmlTabelle.this.tutil.start();
                        this.setExpires(cacheSecs);
                        if (this.maske.getSelectedTableStylesheetFilename() != null && this.maske.getSelectedTableStylesheetFilename().equals("tabelle_xml.xsl")) {
                            this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
                            this.currentXml = SxPools.get(this.getMandantenID()).localize(this.currentXml, this.desiredLocale);
                            PrintWriter out = this.response.getWriter();
                            if (ServletHelper.getParameter(this.request, "encrypted") != null && ServletHelper.getParameter(this.request, "encrypted").equals("true")) {
                                this.currentXml = CryptUtils.simpleEncryptString2(this.currentXml);
                            }
                            out.write(this.currentXml);
                        } else if (this.maske.getSelectedTableStylesheetFilename() != null && this.maske.getSelectedTableStylesheetFilename().endsWith(".jrxml")) {
                            try {
                                JasperCreator jc = new JasperCreator(this.request, this.response, (SxUser)this.request.getSession().getAttribute("user"), this.maske, this.maske.getSelectedTableStylesheetFilename(), this.maske.getDesiredContenttype());
                                if (this.maske.getSelectedTableStylesheetFilename().indexOf("_xmlsource") > -1) {
                                    jc.perform(this.getMandantenID(), this.currentXml);
                                    break block22;
                                }
                                jc.perform(this.getMandantenID(), this.maske);
                            }
                            catch (JRException e2) {
                                this.writeExceptionText("log", e2, "JasperReport-Erzeugung ");
                            }
                        } else {
                            XmlTransformer xmlTransformer = new XmlTransformer(SuperXmlTabelle.this.getServletConfig(), this.request, this.response, this.getMandantenID(), this.getBrowser());
                            xmlTransformer.transform(this.maske.getName(), this.maske.getTmpFiles(), this.currentXml, this.desiredLocale, this.maske.getSelectedTableStylesheetFilename(), contenttype, ServletHelper.getParameter(this.request, "encrypt"));
                        }
                    }
                }
                this.request.getSession().setAttribute(this.maske.getId() + "-isSent", (Object)"true");
            }
            catch (ObligatoryFieldEmptyException e3) {
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.WARNING, e3.toString());
                this.response.reset();
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                PrintWriter output = this.response.getWriter();
                output.println("<html><head><LINK REL='stylesheet' type='text/css' href='../style/superx.css' /></LINK></head><body><p class='errmsg'>" + e3.getMessage() + "</p></body></html>");
            }
            catch (SQLException e4) {
                Logger.getLogger("superx_" + this.getMandantenID()).log(Level.SEVERE, e4.toString());
                this.response.reset();
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                PrintWriter output = this.response.getWriter();
                StringBuffer msg = new StringBuffer(e4.toString());
                StringUtils.replace(msg, "java.sql.SQLException:", "");
                StringUtils.replace(msg, "<", "&lt;");
                StringUtils.replace(msg, ">", "&gt;");
                output.println("<html><head><LINK REL='stylesheet' type='text/css' href='../style/superx.css' /></LINK></head><body><b>" + msg + "</b></body></html>");
            }
        }

        private int getOffset(String contenttype) {
            String offs = ServletHelper.getParameter(this.request, "offset");
            int offset = offs == null || offs.equals("") || contenttype != null && contenttype.indexOf("html") == -1 ? 0 : Integer.parseInt(offs);
            return offset;
        }
    }
}

