/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbadmin;

import de.memtext.util.DateUtils;
import de.memtext.util.WindowUtils;
import de.superx.dbadmin.DBAccess;
import de.superx.dbadmin.Maskenauswahl;
import de.superx.dbadmin.SuperXDBAdmin;
import de.superx.dbadmin.SxDate;
import de.superx.dbadmin.SxDefaults;
import de.superx.dbadmin.SxThemenEintrag2;
import de.superx.dbadmin.SxUtils;
import de.superx.dbadmin.ThemenDragTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class ThemenbaumPanel
extends JPanel
implements ActionListener,
KeyListener {
    static Vector themenbaum;
    static ThemenDragTree tree;
    static SxThemenEintrag2 einEintrag;
    static JScrollPane scrollp;
    static String standDatum;
    static Vector problemf\u00e4lle;
    private boolean isSaveNecessary;

    public ThemenbaumPanel() {
        this.setLayout(new BorderLayout());
        tree = new ThemenDragTree("copy_move");
        tree.setRootVisible(false);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setBorderSelectionColor(Color.darkGray);
        tree.setCellRenderer(renderer);
        tree.addKeyListener(this);
        scrollp = new JScrollPane(tree);
        this.add((Component)scrollp, "Center");
        JPanel down = new JPanel(new GridLayout(2, 1));
        JPanel p1 = new JPanel();
        JButton bl\u00f6schen = new JButton("l\u00f6schen");
        bl\u00f6schen.addActionListener(this);
        p1.add(bl\u00f6schen);
        JButton bneuerKnoten = new JButton("Knoten hinzuf\u00fcgen");
        bneuerKnoten.addActionListener(this);
        p1.add(bneuerKnoten);
        JButton bneueMaske = new JButton("Maske hinzuf\u00fcgen");
        bneueMaske.addActionListener(this);
        p1.add(bneueMaske);
        down.add(p1);
        JPanel p2 = new JPanel();
        JButton bspeich = new JButton("speichern");
        bspeich.addActionListener(this);
        p2.add(bspeich);
        JButton bneueinlesen = new JButton("neu einlesen");
        bneueinlesen.addActionListener(this);
        p2.add(bneueinlesen);
        JButton bbackuprestore = new JButton("Backup wiederherstellen");
        bbackuprestore.addActionListener(this);
        p2.add(bbackuprestore);
        down.add(p2);
        this.add((Component)down, "South");
        this.backupAnlegen();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        if (cmd.equals("l\u00f6schen")) {
            this.l\u00f6schen();
        }
        if (cmd.equals("Knoten hinzuf\u00fcgen")) {
            this.knotenHinzuf\u00fcgen();
        }
        if (cmd.equals("Maske hinzuf\u00fcgen")) {
            this.MaskeHinzuf\u00fcgen();
        }
        if (cmd.equals("speichern")) {
            this.speichern();
        }
        if (cmd.equals("neu einlesen")) {
            this.neuEinlesen();
        }
        if (cmd.equals("Backup wiederherstellen")) {
            this.backupRestore();
        }
    }

    private void backupAnlegen() {
        try {
            DBAccess.executeUpdate("delete from themenbaum_bak where 1=1");
            DBAccess.executeUpdate("insert into themenbaum_bak select * from themenbaum");
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, "Fehler beim Datenbank-Zugriff:\n " + e2.toString(), "SuperX DB Admin", 2);
            e2.printStackTrace();
        }
        SuperXDBAdmin.setStatus("Backup von Tabelle themenbaum angelegt!");
    }

    private void backupRestore() {
        try {
            DBAccess.executeUpdate("delete from themenbaum where 1=1");
            DBAccess.executeUpdate("insert into themenbaum select * from themenbaum_bak");
            this.neuEinlesen();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, "Fehler beim Datenbank-Zugriff:\n " + e2.toString(), "SuperX DB Admin", 2);
            e2.printStackTrace();
        }
    }

    private void neuEinlesen() {
        this.readTreeFromDb(standDatum);
        this.validate();
        this.isSaveNecessary = false;
    }

    private void MaskeHinzuf\u00fcgen() {
        String r\u00fcckmeldung;
        block7: {
            r\u00fcckmeldung = "";
            TreePath currentSelection = tree.getSelectionPath();
            if (currentSelection != null) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
                Object userobj = currentNode.getUserObject();
                SxThemenEintrag2 x = (SxThemenEintrag2)userobj;
                if (!x.isKnoten()) {
                    currentNode = (DefaultMutableTreeNode)currentNode.getParent();
                    userobj = currentNode.getUserObject();
                    x = (SxThemenEintrag2)userobj;
                }
                Maskenauswahl ma = new Maskenauswahl((Frame)this.getTopLevelAncestor());
                ma.show();
                if (ma.getGew\u00e4hlt() != -1) {
                    try {
                        String name = (String)DBAccess.executeQuerySingleValue("select name from maskeninfo where tid=" + ma.getGew\u00e4hlt());
                        tree.incMaxTid();
                        SxThemenEintrag2 neu = new SxThemenEintrag2(new Integer(tree.getMaxTid()), name, new Integer(ma.getGew\u00e4hlt()), x.getTid());
                        DefaultMutableTreeNode neuerKnoten = new DefaultMutableTreeNode(neu);
                        currentNode.add(neuerKnoten);
                        ((DefaultTreeModel)tree.getModel()).reload(currentNode);
                        r\u00fcckmeldung = new String("Maske hinzugef\u00fcgt!");
                        this.isSaveNecessary = true;
                    }
                    catch (Exception e2) {
                        if (e2.toString().indexOf("No current row") > 0) {
                            r\u00fcckmeldung = new String("Maske nicht gefunden");
                            break block7;
                        }
                        r\u00fcckmeldung = "Fehler beim Datenbankzugriff - " + e2.toString();
                    }
                }
            } else {
                r\u00fcckmeldung = new String("Es muss erst ein Knoten ausgew\u00e4hlt werden");
            }
        }
        SuperXDBAdmin.setStatus(r\u00fcckmeldung);
    }

    private void l\u00f6schen() {
        TreePath currentSelection = tree.getSelectionPath();
        if (currentSelection != null) {
            int erg = JOptionPane.showConfirmDialog(this, "Soll dieser Eintrag gel\u00f6scht werden?\n\nHinweis: Es wird nur der Eintrag im Themenbaum gel\u00f6scht.\nWenn Sie eine Maske komplett l\u00f6schen wollen,\ntun Sie dies unter Maskenverwaltung!", "SuperX DB Admin", 0);
            if (erg != 0) {
                return;
            }
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)currentNode.getParent();
            if (parent != null) {
                parent.remove(currentNode);
                ((DefaultTreeModel)tree.getModel()).reload(parent);
                this.isSaveNecessary = true;
            }
        }
        this.validate();
        this.repaint();
    }

    private void knotenHinzuf\u00fcgen() {
        String eingabe;
        SxThemenEintrag2 x;
        DefaultMutableTreeNode currentNode;
        Object userobj;
        Date gueltig_seit = new Date(1L);
        gueltig_seit = Date.valueOf("1900-01-01");
        Date gueltig_bis = new Date(1L);
        gueltig_bis = Date.valueOf("2999-01-01");
        TreePath currentSelection = tree.getSelectionPath();
        if (currentSelection != null && (userobj = (currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getUserObject()) instanceof SxThemenEintrag2 && (x = (SxThemenEintrag2)userobj).isKnoten() && (eingabe = JOptionPane.showInputDialog(this, "Name des neuen Knotens:", "SuperX", 3)) != null) {
            tree.incMaxTid();
            SxThemenEintrag2 neu = new SxThemenEintrag2(new Integer(tree.getMaxTid()), eingabe);
            neu.setParent(x.getTid());
            neu.setGueltigSeit(gueltig_seit);
            neu.setGueltigBis(gueltig_bis);
            DefaultMutableTreeNode neuerKnoten = new DefaultMutableTreeNode(neu);
            currentNode.add(neuerKnoten);
            ((DefaultTreeModel)tree.getModel()).reload(currentNode);
            this.isSaveNecessary = true;
        }
    }

    void readTreeFromDb(String lStand) {
        WindowUtils.setWaitCursor(this, true);
        if (lStand == null) {
            lStand = DateUtils.getTodayString();
        }
        standDatum = lStand;
        String sx_db = (String)SxDefaults.getPropertyValue("SxDB");
        try {
            try {
                Date date = new Date(1L);
                SxDate mydate = new SxDate();
                date = SxDate.getDate(standDatum);
                Vector rohform = new Vector();
                String query = "";
                query = sx_db.equals("Postgres") ? "select T.tid,T.name, T.maskeninfo_id, T.parent, T.erlaeuterung,T.gueltig_seit,T.gueltig_bis from themenbaum T where T.maskeninfo_id is null and T.gueltig_seit<=date_val('" + standDatum + "') and T.gueltig_bis>=date_val('" + standDatum + "') " + " union " + "select T.tid,M.name, T.maskeninfo_id, T.parent, M.erlaeuterung,T.gueltig_seit,T.gueltig_bis " + "from themenbaum T, maskeninfo M " + "where T.maskeninfo_id=M.tid and " + "T.gueltig_seit<=date_val('" + standDatum + "') and T.gueltig_bis>=date_val('" + standDatum + "') " + " order by 2" : "select T.tid,T.name, T.maskeninfo_id, T.parent, T.erlaeuterung,T.gueltig_seit,T.gueltig_bis from themenbaum T where T.maskeninfo_id is null and T.gueltig_seit<=date('" + standDatum + "') and T.gueltig_bis>=date('" + standDatum + "') " + " union " + "select T.tid,M.name, T.maskeninfo_id, T.parent, M.erlaeuterung,T.gueltig_seit,T.gueltig_bis " + "from themenbaum T, maskeninfo M " + "where T.maskeninfo_id=M.tid and " + "T.gueltig_seit<=date('" + standDatum + "') and T.gueltig_bis>=date('" + standDatum + "') " + " order by 2";
                Integer mtid = (Integer)DBAccess.executeQuerySingleValue("select max(tid) from themenbaum");
                tree.setMaxTid(mtid);
                rohform = DBAccess.executeQuery(query);
                if (rohform.size() < 1) {
                    throw new Exception();
                }
                int entryCount = rohform.size();
                Vector dummy = new Vector();
                themenbaum = new Vector();
                Enumeration en1 = rohform.elements();
                while (en1.hasMoreElements()) {
                    dummy = (Vector)en1.nextElement();
                    Integer tid = (Integer)dummy.elementAt(0);
                    String name = (String)dummy.elementAt(1);
                    name = name.trim();
                    Integer maskeninfo_id = (Integer)dummy.elementAt(2);
                    Integer parent = (Integer)dummy.elementAt(3);
                    String erlaeuterung = (String)dummy.elementAt(4);
                    Date gueltig_seit = (Date)dummy.elementAt(5);
                    Date gueltig_bis = (Date)dummy.elementAt(6);
                    einEintrag = new SxThemenEintrag2(tid, name, maskeninfo_id, parent, erlaeuterung, gueltig_seit, gueltig_bis);
                    themenbaum.addElement(einEintrag);
                }
                rohform = null;
                SxThemenEintrag2 ebene0 = new SxThemenEintrag2(null, "Abfragen/Berichte", null, null, null, null, null);
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(ebene0);
                this.insertnodes(null, root);
                DefaultTreeModel treeModel = new DefaultTreeModel(root);
                tree.setModel(treeModel);
                this.pr\u00fcfeDifferenzen(themenbaum);
                themenbaum = null;
                if (root.getChildCount() > 0) {
                    DefaultMutableTreeNode ebene1 = (DefaultMutableTreeNode)root.getChildAt(0);
                    tree.expandPath(new TreePath(ebene1.getPath()));
                }
                tree.getSelectionModel().setSelectionMode(1);
                this.pr\u00fcfeToteEintr\u00e4ge();
                SuperXDBAdmin.setStatus(" Themenbaum eingelesen (" + entryCount + " Eintr\u00e4ge)");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(null, "Fehler bei Datenbankzugriff: " + e2.toString(), "Themenbaum", 1);
                WindowUtils.setWaitCursor(this, false);
            }
        }
        finally {
            WindowUtils.setWaitCursor(this, false);
        }
    }

    private void pr\u00fcfeToteEintr\u00e4ge() throws Exception {
        Vector tot = DBAccess.executeQuery("select maskeninfo_id,name, tid from themenbaum where maskeninfo_id not in (select tid from maskeninfo)");
        if (tot.size() > 0) {
            System.out.println("Eintr\u00e4ge in Themenbaum, f\u00fcr die kein Eintrag mehr in maskeninfo ist:");
            Enumeration en = tot.elements();
            while (en.hasMoreElements()) {
                Vector eintrag = (Vector)en.nextElement();
                System.out.println(eintrag.get(0) + ": " + eintrag.get(1) + " themenbaum.tid=" + eintrag.get(2));
            }
            JOptionPane.showMessageDialog(null, "Es gibt " + tot.size() + " Eintr\u00e4ge in Themenbaum, f\u00fcr die kein Eintrag mehr in maskeninfo ist.\n(siehe Konsole) Wenn Sie speichern werden diese Eintr\u00e4ge gel\u00f6scht!", "SuperX DB Admin", 1);
        }
    }

    public boolean isSaveNecessary() {
        return this.isSaveNecessary;
    }

    private void insertnodes(Integer theParent, DefaultMutableTreeNode aktNode) {
        Vector result = new Vector();
        result = this.mySelect(theParent);
        Enumeration el = result.elements();
        while (el.hasMoreElements()) {
            einEintrag = (SxThemenEintrag2)el.nextElement();
            DefaultMutableTreeNode neuNode = new DefaultMutableTreeNode(einEintrag);
            aktNode.add(neuNode);
            Integer eintrag_tid = einEintrag.getTid();
            if (eintrag_tid != null & theParent == null) {
                this.insertnodes(einEintrag.getTid(), neuNode);
            }
            if (eintrag_tid == null & theParent == null) {
                System.out.println("Achtung! Element hat f\u00e4lschlicherweise sich selbst als parent:" + einEintrag.getName());
            }
            if (eintrag_tid == null || theParent == null) continue;
            if (!theParent.equals(eintrag_tid)) {
                this.insertnodes(einEintrag.getTid(), neuNode);
                continue;
            }
            System.out.println("Achtung! Element hat f\u00e4lschlicherweise sich selbst als parent:" + einEintrag.getName() + "tid:" + einEintrag.getTid());
        }
    }

    private Vector mySelect(Integer pruefparent) {
        Vector<SxThemenEintrag2> result = new Vector<SxThemenEintrag2>();
        Enumeration el = themenbaum.elements();
        while (el.hasMoreElements()) {
            einEintrag = (SxThemenEintrag2)el.nextElement();
            Integer eintrag_parent = einEintrag.getParent();
            if (eintrag_parent == null && pruefparent == null) {
                result.addElement(einEintrag);
            }
            if (eintrag_parent == null || pruefparent == null || eintrag_parent.intValue() != pruefparent.intValue()) continue;
            result.addElement(einEintrag);
        }
        return result;
    }

    private void addNode() {
    }

    public void bearbeiten() {
    }

    public String dateToString(Date inp) {
        DateFormat df = DateFormat.getDateInstance(2);
        df.setTimeZone(TimeZone.getDefault());
        df.setLenient(false);
        String help = df.format(inp);
        return help;
    }

    private void speichern() {
        int i2 = 0;
        String sql = null;
        String sx_db = (String)SxDefaults.getPropertyValue("SxDB");
        try {
            DefaultMutableTreeNode lroot = (DefaultMutableTreeNode)tree.getModel().getRoot();
            DefaultMutableTreeNode aNode = null;
            sql = "create temp table tmp_themenbaum (tid integer,name char(50) not null ,maskeninfo_id integer,parent integer,gueltig_seit date,gueltig_bis date,erlaeuterung char(240)); ";
            Enumeration<TreeNode> en = lroot.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                SxThemenEintrag2 x;
                aNode = (DefaultMutableTreeNode)en.nextElement();
                if (!(aNode.getUserObject() instanceof SxThemenEintrag2) || (x = (SxThemenEintrag2)aNode.getUserObject()).getTid() == null) continue;
                String ins = new String("insert into tmp_themenbaum (tid,name,maskeninfo_id,parent,gueltig_seit,gueltig_bis) values (" + x.getTid() + ",'" + x.getName() + "'," + x.getMaskeninfo_id() + "," + x.getParent() + ",date('" + SxUtils.GetValueAsString(x.getGueltigSeit()) + "'),date('" + SxUtils.GetValueAsString(x.getGueltigBis()) + "')); ");
                if (sx_db.equals("Postgres")) {
                    ins = "insert into tmp_themenbaum (tid,name,maskeninfo_id,parent,gueltig_seit,gueltig_bis) values (" + x.getTid() + ",'" + x.getName() + "'," + x.getMaskeninfo_id() + "," + x.getParent() + ",date_val('" + SxUtils.GetValueAsString(x.getGueltigSeit()) + "'),date('" + SxUtils.GetValueAsString(x.getGueltigBis()) + "')); ";
                }
                sql = String.valueOf(sql) + ins;
                ++i2;
            }
            try {
                sql = String.valueOf(sql) + "delete from themenbaum where 1=1; ";
                sql = String.valueOf(sql) + "insert into themenbaum select * from tmp_themenbaum;";
                sql = String.valueOf(sql) + "drop table tmp_themenbaum;";
                DBAccess.executeUpdateAll(sql);
            }
            catch (SQLException e2) {
                System.out.println(sql);
                System.out.println("Fehler beim Schreiben in die Datenbank:\n " + e2.toString());
            }
            this.isSaveNecessary = false;
        }
        catch (Exception e3) {
            JOptionPane.showMessageDialog(null, "Fehler beim Schreiben in die Datenbank:\n " + e3.toString(), "SuperX DB Admin", 2);
            e3.printStackTrace();
        }
        SuperXDBAdmin.setStatus(String.valueOf(i2) + " Eintr\u00e4ge in themenbaum geschrieben");
        WindowUtils.setWaitCursor(this, false);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        System.out.println(event.getKeyCode());
        if (event.getKeyCode() == 127) {
            this.l\u00f6schen();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (event.getKeyCode() == 127) {
            this.l\u00f6schen();
        }
    }

    private void pr\u00fcfeDifferenzen(Vector themenbaum) {
        SxThemenEintrag2 x;
        problemf\u00e4lle = null;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> en = root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)en.nextElement();
            x = (SxThemenEintrag2)aNode.getUserObject();
            themenbaum.remove(x);
        }
        if (themenbaum.size() > 0) {
            JOptionPane.showMessageDialog(null, "Achtung!\nEs gibt " + themenbaum.size() + " g\u00fcltige Eintr\u00e4ge, die nicht in die Baumstruktur passten!\n(Siehe Konsole)", "SuperX Admin", 2);
            DefaultMutableTreeNode fehlernode = new DefaultMutableTreeNode("Fehler");
            Enumeration el = themenbaum.elements();
            while (el.hasMoreElements()) {
                x = (SxThemenEintrag2)el.nextElement();
                fehlernode.add(new DefaultMutableTreeNode(x));
                System.out.println(x.getTid() + ":" + x.getName() + " parent:" + x.getParent());
            }
            root.add(fehlernode);
            ((DefaultTreeModel)tree.getModel()).reload();
            tree.validate();
            problemf\u00e4lle = themenbaum;
        }
    }
}

