/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbadmin;

import de.superx.dbadmin.InstEditor;
import de.superx.dbadmin.InstRenderer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreePath;

class InstImmediateEditor
extends DefaultTreeCellEditor {
    private InstRenderer renderer;

    public InstImmediateEditor(JTree tree, InstRenderer renderer, InstEditor editor) {
        super(tree, renderer, editor);
        this.renderer = renderer;
    }

    @Override
    protected boolean canEditImmediately(EventObject e2) {
        boolean rv = false;
        if (e2 instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e2;
            rv = this.inCheckBoxHitRegion(me);
        }
        return rv;
    }

    @Override
    public boolean shouldSelectCell(EventObject e2) {
        boolean rv = false;
        if (e2 instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e2;
            TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
            rv = !this.inCheckBoxHitRegion(me);
        }
        return rv;
    }

    public boolean inCheckBoxHitRegion(MouseEvent e2) {
        TreePath path = this.tree.getPathForLocation(e2.getX(), e2.getY());
        if (path == null) {
            return false;
        }
        boolean rv = false;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Rectangle bounds = this.tree.getRowBounds(this.lastRow);
        Dimension checkBoxOffset = this.renderer.getCheckBoxOffset();
        bounds.translate(10, 0);
        rv = bounds.contains(e2.getPoint());
        return rv;
    }
}

