/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbadmin;

import de.memtext.util.WindowUtils;
import de.superx.dbadmin.DBAccess;
import de.superx.dbadmin.MBComboBox;
import de.superx.dbadmin.SuperXDBAdmin;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class GroupStammPanel
extends JPanel
implements ActionListener {
    Vector gruppenliste;
    MBComboBox mbt;
    JTextField tname = new JTextField(15);

    public GroupStammPanel() {
        this.mbt = new MBComboBox();
        this.mbt.addActionListener(this);
        this.setLayout(new GridLayout(3, 1));
        JPanel p0 = new JPanel();
        p0.add(this.mbt);
        this.add(p0);
        JPanel p1 = new JPanel();
        JLabel lname = new JLabel("Name:");
        p1.add(lname);
        p1.add(this.tname);
        JButton bspeich = new JButton("Name \u00e4ndern");
        bspeich.addActionListener(this);
        p1.add(bspeich);
        this.add(p1);
        JPanel p5 = new JPanel();
        JButton bl\u00f6schen = new JButton("Gruppe l\u00f6schen");
        bl\u00f6schen.addActionListener(this);
        p5.add(bl\u00f6schen);
        JButton bneu = new JButton("Gruppe anlegen");
        bneu.addActionListener(this);
        p5.add(bneu);
        this.add(p5);
    }

    public void prepare() {
        WindowUtils.setWaitCursor(this, true);
        this.gruppenliste = DBAccess.GruppenListeEinlesen();
        this.mbt.removeAllItems();
        this.mbt.addAll(this.gruppenliste);
        if (SuperXDBAdmin.getLastGroup() != -999) {
            this.mbt.setSelection(SuperXDBAdmin.getLastGroup());
        }
        WindowUtils.setWaitCursor(this, false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src;
        if (event.getActionCommand().equals("Name \u00e4ndern")) {
            this.gruppenDatenSpeichern();
        }
        if (event.getActionCommand().equals("Gruppe l\u00f6schen")) {
            this.gruppeL\u00f6schen(this.mbt.getSelectedID());
        }
        if (event.getActionCommand().equals("Gruppe anlegen")) {
            this.gruppeAnlegen();
        }
        if ((src = event.getSource()) instanceof MBComboBox) {
            MBComboBox localbox = (MBComboBox)event.getSource();
            SuperXDBAdmin.setLastGroup(localbox.getSelectedID());
            this.gruppeGew\u00e4hlt(SuperXDBAdmin.getLastGroup());
        }
    }

    private void gruppenDatenSpeichern() {
        try {
            try {
                WindowUtils.setWaitCursor(this, true);
                String upd = "update groupinfo set name=" + DBAccess.getStringOrNull(this.tname.getText()) + " where tid=" + this.mbt.getSelectedID();
                DBAccess.executeUpdate(upd);
                SuperXDBAdmin.setStatus("Gruppendaten gespeichert!");
                this.gruppenliste = DBAccess.GruppenListeEinlesen();
                this.mbt.neuAufbauen(this.gruppenliste);
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(null, "Fehler beim Schreiben in die Datenbank:\n " + e2.toString(), "SuperX DB Admin", 2);
                e2.printStackTrace();
                WindowUtils.setWaitCursor(this, false);
            }
        }
        finally {
            WindowUtils.setWaitCursor(this, false);
        }
    }

    private void gruppeGew\u00e4hlt(int gruppeid) {
        Enumeration el = this.gruppenliste.elements();
        while (el.hasMoreElements()) {
            Vector zeile = (Vector)el.nextElement();
            Integer test = (Integer)zeile.get(0);
            if (test != gruppeid) continue;
            this.tname.setText((String)zeile.get(1));
            this.tname.setCaretPosition(0);
        }
        this.repaint();
        SuperXDBAdmin.setLastGroup(gruppeid);
    }

    private void gruppeL\u00f6schen(int gruppeid) {
        int rc;
        String nochEingetrageneUser = new String("");
        try {
            Vector erg = DBAccess.executeQuery("select unique benutzer,name from userinfo U,user_group_bez B where U.tid=B.userinfo_id and b.groupinfo_id=" + gruppeid);
            Enumeration el = erg.elements();
            while (el.hasMoreElements()) {
                Vector help = (Vector)el.nextElement();
                if (nochEingetrageneUser.equals("")) {
                    nochEingetrageneUser = new String("Folgende Nutzer geh\u00f6ren zu dieser Gruppe:");
                }
                nochEingetrageneUser = String.valueOf(nochEingetrageneUser) + "\n" + help.get(0).toString() + " (" + help.get(1).toString() + ")";
            }
            if (!nochEingetrageneUser.equals("")) {
                nochEingetrageneUser = String.valueOf(nochEingetrageneUser) + "\n";
            }
        }
        catch (Exception e2) {
            SuperXDBAdmin.setStatus("Ein Datenbankfehler ist aufgetreten" + e2);
            e2.printStackTrace();
        }
        if ((rc = JOptionPane.showConfirmDialog(null, String.valueOf(nochEingetrageneUser) + "Gruppe wirklich l\u00f6schen?", "SuperX", 0)) == 0) {
            try {
                DBAccess.executeUpdate("delete from user_group_bez where groupinfo_id=" + gruppeid);
                DBAccess.executeUpdate("delete from groupinfo where tid =" + gruppeid);
                SuperXDBAdmin.setStatus("Gruppe gel\u00f6scht");
                this.mbt.neuAufbauen(DBAccess.GruppenListeEinlesen());
                SuperXDBAdmin.setLastGroup(-999);
            }
            catch (Exception e3) {
                SuperXDBAdmin.setStatus("Ein Fehler ist aufgetreten - Gruppe nicht gel\u00f6scht" + e3);
                e3.printStackTrace();
            }
        }
    }

    private void gruppeAnlegen() {
        try {
            Integer tid = (Integer)DBAccess.executeQuerySingleValue("select max(tid) as tid from groupinfo");
            int newtid = tid + 1;
            String name = JOptionPane.showInputDialog(this, "Name eingeben", "SuperX", 3);
            if (name != null) {
                String ins = "insert into groupinfo values (" + newtid + ",'" + name + "')";
                DBAccess.executeUpdate(ins);
                this.gruppenliste = DBAccess.GruppenListeEinlesen();
                this.mbt.neuAufbauen(this.gruppenliste);
                this.mbt.setSelection(name);
                this.gruppeGew\u00e4hlt(newtid);
                SuperXDBAdmin.setLastGroup(newtid);
                SuperXDBAdmin.setStatus("Gruppe angelegt!");
            }
        }
        catch (Exception e2) {
            SuperXDBAdmin.setStatus("Interner Fehler: " + e2.toString());
        }
    }
}

