/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.rights.AllowableHierarchyUtil;
import de.memtext.rights.Rights;
import de.memtext.rights.RightsKeyEntry;
import de.memtext.util.EqualsUtil;
import de.superx.common.AbstractSicht;
import de.superx.common.SelectableItemNode;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.TreeNode;

public class RightsApplicator {
    static void apply(AbstractSicht sicht, Rights rights) {
        if (sicht.getArt().equals("Organigramm-Sicht")) {
            AllowableHierarchyUtil.markNotAllowedNodes(sicht.getRoot(), " (Auswahl)");
        } else {
            if (sicht.getArt().indexOf("Kostenstellen") > -1) {
                if (sicht.getUser().isAdmin() || rights.hasAllRights()) {
                    RightsApplicator.setAllAllowed(sicht);
                } else {
                    RightsApplicator.setSpecificRights(sicht, rights);
                }
                AllowableHierarchyUtil.removeUnallowedNodes(sicht.getRoot());
            } else {
                RightsApplicator.setAllAllowed(sicht);
            }
            if (sicht.getAttribut3() != null && sicht.getAttribut3() == 1) {
                AllowableHierarchyUtil.reorg(sicht.getRoot());
            } else {
                AllowableHierarchyUtil.markNotAllowedNodes(sicht.getRoot(), " (Auswahl)");
            }
        }
    }

    private static void setSpecificRights(AbstractSicht sicht, Rights rights) {
        Iterator it = rights.iterator();
        block0: while (it.hasNext()) {
            RightsKeyEntry re = (RightsKeyEntry)it.next();
            Enumeration<TreeNode> en = sicht.getRoot().breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                if (!EqualsUtil.areEqual(node.getId(), re.getKey())) continue;
                node.setAllowed(true);
                node.setDescendantsAllowed(re.isSubordinatesAllowed());
                continue block0;
            }
        }
    }

    private static void hideSubordinates(SelectableItemNode node) {
        Enumeration<TreeNode> en = node.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode n = (SelectableItemNode)en.nextElement();
            if (n == node) continue;
            n.setHidden(true);
            n.setDescendantsAllowed(false);
        }
    }

    private static void setAllAllowed(AbstractSicht sicht) {
        Enumeration<TreeNode> en = sicht.getRoot().breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            node.setAllowed(true);
        }
    }
}

