/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.widgets;

import de.memtext.baseobjects.NamedIdObjectI;
import de.memtext.widgets.HorizontalBox;
import de.memtext.widgets.MBFrame;
import de.memtext.widgets.VerticalBox;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabeledComboBox
extends HorizontalBox {
    private JLabel lbl = new JLabel();
    private JComboBox combobox;

    public LabeledComboBox(String lblText) {
        this.combobox = new JComboBox();
        this.initGui(lblText);
    }

    public LabeledComboBox(String lblText, Vector model) {
        this.combobox = new JComboBox(model);
        this.initGui(lblText);
    }

    public LabeledComboBox(String lblText, Collection elements) {
        this(lblText, new Vector(elements));
    }

    public LabeledComboBox(String lblText, JComboBox combobox) {
        if (combobox == null) {
            throw new IllegalArgumentException("Combox must not be null");
        }
        this.combobox = combobox;
        this.initGui(lblText);
    }

    public int getSelectedIntValue() {
        Integer val = (Integer)this.getSelectedItem();
        return val;
    }

    public double getSelectedDoubleValue() {
        Double val = (Double)this.getSelectedItem();
        return val;
    }

    private void initGui(String lblText) {
        this.setName("lblComboBox-" + lblText);
        this.lbl.setText(lblText);
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(this.lbl);
        p.add(this.combobox);
        this.combobox.setName("cb-" + lblText);
        this.add(p);
    }

    public void setSelectedIndex(int index) {
        this.combobox.setSelectedIndex(index);
    }

    public void addItems(Collection col) {
        for (Object element : col) {
            this.combobox.addItem(element);
        }
    }

    public void removeAllItems() {
        this.combobox.removeAllItems();
    }

    @Override
    public void setEnabled(boolean b2) {
        this.lbl.setEnabled(b2);
        this.combobox.setEnabled(b2);
    }

    public void addActionListener(ActionListener al) {
        this.combobox.addActionListener(al);
    }

    public static void main(String[] a2) {
        MBFrame f2 = new MBFrame("");
        VerticalBox vb = new VerticalBox();
        LabeledComboBox b2 = new LabeledComboBox("bla", new Vector());
        LabeledComboBox b22 = new LabeledComboBox("bla2", new Vector());
        vb.add(b2);
        vb.add(b22);
        f2.setCenter(vb);
        f2.pack();
        f2.show();
    }

    public Object getSelectedItem() {
        return this.combobox.getSelectedItem();
    }

    public Object getSelectedItemId() {
        if (!(this.combobox.getSelectedItem() instanceof NamedIdObjectI)) {
            throw new RuntimeException("this function is only available if elements of combobox implement NamedIdObjectI");
        }
        NamedIdObjectI obj = (NamedIdObjectI)this.combobox.getSelectedItem();
        return obj.getId();
    }

    public void setSelectedItem(Object object) {
        this.combobox.setSelectedItem(object);
    }

    public void removeActionListener(ActionListener listener) {
        this.combobox.removeActionListener(listener);
    }

    public void addItemListener(ItemListener listener) {
        this.combobox.addItemListener(listener);
    }

    public void setSelectedItemByName(String name) {
        throw new UnsupportedOperationException("nicht  fertig");
    }

    public int getItemCount() {
        return this.combobox.getItemCount();
    }
}

