/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import java.util.Vector;

public class UIDSet {
    public long start;
    public long end;

    public UIDSet() {
    }

    public UIDSet(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long size() {
        return this.end - this.start + 1L;
    }

    public static UIDSet[] createUIDSets(long[] msgs) {
        Vector<UIDSet> v = new Vector<UIDSet>();
        for (int i2 = 0; i2 < msgs.length; ++i2) {
            int j2;
            UIDSet ms = new UIDSet();
            ms.start = msgs[i2];
            for (j2 = i2 + 1; j2 < msgs.length && msgs[j2] == msgs[j2 - 1] + 1L; ++j2) {
            }
            ms.end = msgs[j2 - 1];
            v.addElement(ms);
            i2 = j2 - 1;
        }
        Object[] msgsets = new UIDSet[v.size()];
        v.copyInto(msgsets);
        return msgsets;
    }

    public static String toString(UIDSet[] msgsets) {
        if (msgsets == null || msgsets.length == 0) {
            return null;
        }
        int i2 = 0;
        StringBuffer s = new StringBuffer();
        int size = msgsets.length;
        while (true) {
            long start;
            long end;
            if ((end = msgsets[i2].end) > (start = msgsets[i2].start)) {
                s.append(start).append(':').append(end);
            } else {
                s.append(start);
            }
            if (++i2 >= size) break;
            s.append(',');
        }
        return s.toString();
    }

    public static long size(UIDSet[] msgsets) {
        long count = 0L;
        if (msgsets == null) {
            return 0L;
        }
        for (int i2 = 0; i2 < msgsets.length; ++i2) {
            count += msgsets[i2].size();
        }
        return count;
    }
}

