/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.DateUtils;
import de.memtext.util.StringUtils;
import de.superx.bin.SxDBUtils;
import de.superx.servlet.CSVResultReport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CSVUploader {
    private static final List<String> SKIP_COLUMNS = Arrays.asList("id", "tid");
    private String userid = "";
    private String delim = "^";
    private String modeOnError = "exclude-row";
    private StringBuffer htmlPreview = new StringBuffer("<table border='1'>");
    private String encoding = System.getProperty("file.encoding");
    private String tabelle = "";
    private boolean withHeader;
    private int[] types = new int[255];
    private String[] names = new String[255];
    private Connection con;
    private Statement stm;
    private PreparedStatement pstDataUpload;
    private DatabaseMetaData databaseMetaData;
    private File sourceFile;
    private boolean isXml = false;
    private CSVResultReport resultReport = new CSVResultReport();
    private String insertMode;
    private Logger logger;
    private int[] insert_types = new int[255];
    private HashMap foreignKeys = new HashMap();
    private List fieldsNotNull = new LinkedList();
    private int realColCount;
    private String[] headers = new String[255];
    private String usage = "-------------------------------------\nGebrauch: java de.superx.bin.UploadRecords \n-logger:<Pfad zu logging.properties> \n-dbproperties:<Pfad zu db.properties> \n-table:<Tabellenname> \n-unl:<Dateipfad Quelldatei>(optional, default ist Tabellenname.unl) \n-delim:<delimiter>(optional, default ist ^) \n-header:<true|false>(optional, mit Feld\u00fcberschriften, default ist false)\n-mode:<stop|exclude-field|exclude-row|transaction>(optional, default is exclude-row) #Bei Fehlerhaften Daten kann das Hochladen gestoppt werden, oder der Datensatz wird \u00fcbersprungen, oder das einzelne Feld wird \u00fcbersprungen\n-inserts:<false|simple|batch>(optional, default is false) #Bei -inserts:simple und batch werden Die Rohdaten in Insert-sql-Statements \u00fcbersetzt (nur f\u00fcr Debugging-Zwecke, sehr langsam. Der Modus exclude-field ist dar\u00fcberhinaus nicht anwendbar)\n-encoding:<utf8,ISO-8859-1, default ist System.file.encoding>\n---------------------------------------------------";
    private PreparedStatement pst;

    public CSVUploader(String userid, String mandantenId, String tabelle, String quelldatei, String delim, String encoding, boolean withHeader, String insertMode, boolean isXml, String modeOnError, boolean isZipped) throws IOException, SQLException {
        this.userid = userid;
        this.logger = Logger.getLogger("superx_" + mandantenId);
        this.logger.setLevel(Level.ALL);
        this.prepareDataUploadStatement();
        if (!insertMode.equals("false")) {
            throw new IllegalArgumentException("als insertmode wird derzeit nur false unterst\u00fctzt");
        }
        if (isXml) {
            throw new IllegalArgumentException("xml  wird derzeit nicht unterst\u00fctzt");
        }
        if (!modeOnError.equals("exclude-row")) {
            throw new IllegalArgumentException("nur Modus exclude-row ist getestet");
        }
        this.tabelle = tabelle;
        this.delim = delim;
        if (delim.equals("tab")) {
            this.delim = "\t";
        }
        if (delim.equals("")) {
            this.delim = "^";
        }
        this.encoding = encoding;
        this.withHeader = withHeader;
        this.insertMode = insertMode;
        this.isXml = isXml;
        this.modeOnError = modeOnError;
        if (!(modeOnError.equals("stop") || modeOnError.equals("exclude-field") || modeOnError.equals("transaction"))) {
            this.modeOnError = "exclude-row";
        }
        if (!insertMode.equals("false") && modeOnError.equals("exclude-field")) {
            throw new IllegalArgumentException("Achtung: Im Modus 'exclude-field' sind die Optionen -inserts:simple/batch nicht anwendbar. W\u00e4hlen Sie -mode:exclude-row");
        }
        if (isZipped) {
            this.unzip(quelldatei);
        }
        this.sourceFile = new File(quelldatei);
        if (!this.sourceFile.exists()) {
            throw new IOException("Datei nicht gefunden: " + quelldatei);
        }
    }

    private void prepareDataUploadStatement() throws SQLException {
    }

    public CSVResultReport getResultReport() {
        return this.resultReport;
    }

    public void upload(boolean isTestMode, boolean createSerial, Connection con) throws FileNotFoundException, IOException, SQLException {
        this.con = con;
        this.stm = con.createStatement();
        this.databaseMetaData = con.getMetaData();
        long timeStart = new java.util.Date().getTime();
        this.readForeignKeys();
        this.readNotNull();
        if (isTestMode) {
            if (this.isPostgres()) {
                try {
                    this.stm.executeUpdate("drop table if exists tmp_" + this.tabelle);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Cannot drop " + this.tabelle, e);
                }
                this.stm.executeUpdate("select * into temp tmp_" + this.tabelle + " from " + this.tabelle + " where 1=0");
            } else {
                String statment = "select * from " + this.tabelle + " where 1=0 into temp tmp_" + this.tabelle;
                this.stm.executeUpdate(statment);
            }
            this.tabelle = "tmp_" + this.tabelle;
        }
        this.logger.fine("Starting the upload.");
        this.logger.fine("Tabellenkatalog f\u00fcr " + this.tabelle);
        if (!this.databaseMetaData.supportsTransactions() && this.modeOnError.equals("transaction")) {
            throw new IllegalArgumentException("Achtung: Sie haben den Modus 'transaction' gew\u00e4hlt, die Datenbank unters\u00fctzt aber keine Transaktionen. W\u00e4hlen Sie einen anderen Modus.");
        }
        int colCount = this.readFieldTypes();
        if (this.isXml) {
            this.processXml(colCount);
        } else {
            this.processCSV(colCount);
        }
        long timeFertig = new java.util.Date().getTime();
        this.logger.fine(this.resultReport.getRowCount() - 1 + " Rows inserted in " + (timeFertig - timeStart) / 1000L + " Sec.");
        if (this.resultReport.getRowCount() < 2) {
            this.resultReport.incError("Keine Datensaetze gefunden");
        }
        if (this.resultReport.getErrorCount() > 0) {
            System.err.println(this.resultReport.getErrorCount() + " Rows could not be inserted.");
            if (this.modeOnError.equals("transaction") && this.databaseMetaData.supportsTransactions()) {
                this.stm.executeUpdate("rollback;");
                System.err.println("Transaction rolled back. Nothing changed.");
            }
        }
        if (this.modeOnError.equals("transaction") && this.databaseMetaData.supportsTransactions()) {
            this.stm.executeUpdate("commit work;");
        }
        this.stm.close();
        this.htmlPreview.append("</table>");
    }

    private void readNotNull() throws SQLException {
        ResultSet rs = this.stm.executeQuery("select name from sx_fields where table_name = '" + this.tabelle + "' and field_not_null=1");
        while (rs.next()) {
            String fieldname = rs.getString(1);
            this.fieldsNotNull.add(fieldname);
        }
        rs.close();
    }

    private void readForeignKeys() throws SQLException {
        ResultSet rs = this.stm.executeQuery("select name,foreignkey_tab,foreignkey_col from sx_fields where table_name = '" + this.tabelle + "' and foreignkey_tab is not null and check_integrity=1");
        Statement stm2 = this.con.createStatement();
        while (rs.next()) {
            String fieldname = rs.getString(1);
            String ftabname = rs.getString(2);
            String ftabcol = rs.getString(3);
            if (ftabcol == null) {
                throw new SQLException(this.tabelle + " foreign key feld ist null f\u00fcr Spalte " + fieldname);
            }
            ResultSet rs2 = stm2.executeQuery("select " + ftabcol + " from " + ftabname);
            LinkedList<String> l = new LinkedList<String>();
            while (rs2.next()) {
                l.add(rs2.getObject(1).toString().trim());
            }
            rs2.close();
            this.foreignKeys.put(fieldname, l);
        }
        rs.close();
        stm2.close();
    }

    private boolean isPostgres() throws SQLException {
        return this.databaseMetaData.getDriverName().toLowerCase().indexOf("postgres") > -1;
    }

    private void processCSV(int colCount) throws UnsupportedEncodingException, FileNotFoundException, IOException, SQLException {
        String insert_stmt = "";
        int k = 0;
        String text = "";
        BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), this.encoding));
        String insert_head = this.createInsertHeader(colCount, inputReader);
        this.logger.info("Insert header: " + insert_head);
        if (this.insertMode.equals("false")) {
            this.logger.info(insert_head);
            this.pst = this.con.prepareStatement(insert_head);
        } else if (this.databaseMetaData.supportsBatchUpdates()) {
            this.stm.clearBatch();
        }
        if (this.modeOnError.equals("transaction") && this.databaseMetaData.supportsTransactions()) {
            this.stm.executeUpdate("begin work;");
        }
        while ((text = inputReader.readLine()) != null) {
            boolean isBreakWanted = false;
            if (text.indexOf(this.delim) == -1) {
                throw new IOException("Trennzeichen " + this.delim + " nicht in Daten gefunden");
            }
            if (text.endsWith("\\")) {
                text = text.substring(0, text.length() - 1);
                String tt = inputReader.readLine();
                if (tt != null) {
                    text = text + "\n" + tt;
                    while (tt.endsWith("\\")) {
                        text = text.substring(0, text.length() - 1);
                        tt = inputReader.readLine();
                        if (tt == null) continue;
                        text = text + "\n" + tt;
                    }
                }
            }
            insert_stmt = insert_head;
            k = 0;
            int i = 0;
            isBreakWanted = this.insertMode.equals("false") ? this.csvPreparedStatement(colCount, i, insert_stmt, text) : this.csvInsert(i, insert_stmt, k, text);
            if (isBreakWanted) break;
            this.resultReport.incRowCount();
        }
        inputReader.close();
    }

    private boolean csvInsert(int i, String insert_stmt, int k, String text) throws SQLException {
        boolean isBreakWanted = false;
        this.logger.fine("Creating insert Statement");
        insert_stmt = this.createInsertStatement(insert_stmt, text, k, i);
        if (this.insertMode.equals("simple") || !this.databaseMetaData.supportsBatchUpdates()) {
            try {
                this.stm.execute(insert_stmt);
            }
            catch (SQLException e) {
                this.logger.severe("Fehler beim Ausf\u00fchren des " + this.resultReport.getRowCount() + ". Insert:\n " + insert_stmt + "\nFehler: " + e.toString());
                String msg = text + "  #SQL-Error in Load-File Line " + this.resultReport.getRowCount() + ": " + insert_stmt + " Fehler: " + e.toString();
                this.resultReport.incError(msg);
                if (this.modeOnError.equals("stop")) {
                    isBreakWanted = true;
                }
            }
        } else {
            this.stm.addBatch(insert_stmt);
        }
        this.logger.fine(insert_stmt);
        try {
            if (this.insertMode.equals("batch") && this.databaseMetaData.supportsBatchUpdates()) {
                k = this.stm.executeBatch().length;
            }
        }
        catch (SQLException e) {
            this.logger.severe("SQL_Fehler" + e.toString());
            k = 0;
            this.resultReport.incError(e.toString());
        }
        return isBreakWanted;
    }

    private boolean csvPreparedStatement(int colCount, int i, String insert_stmt, String text) throws SQLException {
        boolean isBreakWanted;
        block5: {
            isBreakWanted = false;
            String prepare = this.fillPreparedStatement(colCount, insert_stmt, text, colCount, i);
            if (prepare.startsWith("Error")) {
                String msg = text + "  #Error in Load-File Line " + this.resultReport.getRowCount() + ": " + prepare;
                this.resultReport.incError(msg);
                if (this.modeOnError.equals("stop")) {
                    isBreakWanted = true;
                }
            } else {
                try {
                    this.pst.executeUpdate();
                }
                catch (SQLException e) {
                    this.logger.severe("Fehler beim Ausf\u00fchren des " + this.resultReport.getRowCount() + ". Insert:\n " + prepare + "\nFehler: " + e.toString());
                    String msg = text + "  #SQL-Error in Load-File Line " + this.resultReport.getRowCount() + ": " + e;
                    this.resultReport.incError(msg);
                    if (!this.modeOnError.equals("stop")) break block5;
                    isBreakWanted = true;
                }
            }
        }
        return isBreakWanted;
    }

    private void processXml(int colCount) throws FileNotFoundException, IOException, SQLException {
        throw new IllegalArgumentException("kein foreign key kontrolle umgesetzt");
    }

    private int readFieldTypes() throws SQLException {
        if (!this.databaseMetaData.storesLowerCaseIdentifiers()) {
            this.tabelle = this.tabelle.toUpperCase();
        }
        ResultSet rs = this.databaseMetaData.getColumns(null, null, this.tabelle.substring(4), null);
        int i = 0;
        LinkedList<String> foundnames = new LinkedList<String>();
        while (rs.next()) {
            this.names[i] = rs.getObject("COLUMN_NAME").toString();
            if (SKIP_COLUMNS.contains(this.names[i].toLowerCase())) continue;
            if (foundnames.contains(this.names[i])) break;
            foundnames.add(this.names[i]);
            this.types[i] = rs.getInt("DATA_TYPE");
            this.logger.fine("Tabellenfeld " + i + ": " + this.names[i] + " Typ " + this.types[i] + "(" + SxDBUtils.getSqlTypeName(this.types[i]) + ")");
            ++i;
        }
        return i;
    }

    private String createInsertHeader(int colCount, BufferedReader in) throws IOException {
        int i = 0;
        int k = 0;
        int p = 0;
        String insert_head = "insert into " + this.tabelle;
        this.htmlPreview.append("<tr>");
        if (this.withHeader) {
            String text = in.readLine();
            if (text != null) {
                if (text.indexOf(this.delim) == -1) {
                    throw new IOException("Trennzeichen " + this.delim + " nicht in Daten gefunden");
                }
                if (!text.endsWith(this.delim)) {
                    text = text + this.delim;
                }
                insert_head = insert_head + "(";
                this.logger.info("Reading headers in file");
                do {
                    if ((p = text.indexOf(this.delim, i)) <= -1) continue;
                    this.headers[k] = text.substring(i, p);
                    if (this.headers[k].trim().equals("")) {
                        throw new IOException("Leerer Spaltenname nicht erlaubt, bei Trennzeichen ^ z.B. key^^wert");
                    }
                    boolean headerExists = false;
                    for (int b = 0; b < colCount; ++b) {
                        if (!this.headers[k].equalsIgnoreCase(this.names[b])) continue;
                        headerExists = true;
                    }
                    if (!headerExists) {
                        throw new IOException("Error: header " + this.headers[k] + " does not exist");
                    }
                    this.logger.info("header " + this.headers[k] + " exists");
                    if (this.withHeader) {
                        insert_head = insert_head + this.headers[k] + ", ";
                        this.htmlPreview.append("<th>" + this.headers[k] + "</th>");
                    }
                    ++k;
                    i = p + 1;
                } while (p > -1);
            }
        } else {
            for (i = 0; i < colCount; ++i) {
                this.headers[i] = this.names[i];
                this.htmlPreview.append("<th>" + this.headers[i] + "</th>");
                ++k;
            }
        }
        this.realColCount = k - 1;
        for (i = 0; i < colCount; ++i) {
            for (k = 0; k < colCount; ++k) {
                if (!this.names[i].equals(this.headers[k])) continue;
                this.insert_types[k] = this.types[i];
            }
        }
        if (this.withHeader) {
            insert_head = insert_head.substring(0, insert_head.length() - 2);
            insert_head = insert_head + ") values(";
        } else {
            insert_head = insert_head + " values(";
        }
        if (this.insertMode.equals("false")) {
            for (i = 0; i <= this.realColCount; ++i) {
                insert_head = insert_head + "?, ";
            }
            insert_head = insert_head.substring(0, insert_head.length() - 2);
            insert_head = insert_head + ");";
        }
        if (this.withHeader) {
            this.resultReport.setColnames(insert_head.substring(insert_head.indexOf("(") + 1, insert_head.indexOf(")")));
        } else {
            this.resultReport.setColnames("");
        }
        this.htmlPreview.append("</tr>\n");
        return insert_head;
    }

    public String getHtmlPreview() {
        return this.htmlPreview.toString();
    }

    private String fillPreparedStatement(int colCount, String insert_stmt, String text, int columnCount, int i) throws SQLException {
        int p;
        int k = 0;
        String errmsg = "";
        this.pst.clearParameters();
        if (this.resultReport.getRowCount() <= 10) {
            this.htmlPreview.append("<tr>");
        }
        do {
            String htmlvalue;
            if (!text.endsWith(this.delim)) {
                text = text + this.delim;
            }
            if ((p = text.indexOf(this.delim, i)) > 0 && text.substring(p - 1, p).equals("\\")) {
                p = text.indexOf(this.delim, p + 1);
            }
            if (p <= -1 && (p != -1 || k != this.realColCount - 1)) continue;
            String feld_wert = p == -1 ? text.substring(i) : text.substring(i, p);
            if (feld_wert != null && feld_wert.indexOf("\\\\n") > 0) {
                feld_wert = StringUtils.replace(feld_wert, "\\\\n", "\\n");
            }
            if (feld_wert != null && feld_wert.indexOf("\\" + this.delim) > 0) {
                feld_wert = StringUtils.replace(feld_wert, "\\", "");
            }
            if ((htmlvalue = feld_wert) == null || htmlvalue.trim().equals("")) {
                htmlvalue = "&nbsp;";
            }
            if (this.resultReport.getRowCount() <= 10) {
                this.htmlPreview.append("<td>" + htmlvalue + "</td>");
            }
            errmsg = errmsg + this.feld_wert_to_pst(colCount, k, feld_wert);
            ++k;
            i = p + 1;
        } while (p > -1);
        if (this.resultReport.getRowCount() <= 10) {
            this.htmlPreview.append("</tr>\n");
        }
        return errmsg;
    }

    private String feld_wert_to_pst(int colCount, int k, String feld_wert) throws SQLException {
        String errmsg = "";
        if (k >= colCount) {
            errmsg = errmsg + this.conversionException(k, "Anzahl Spalten in Datei ist " + (k + 1) + ", aber es sollten nur " + colCount + " Spalten sein.");
        } else {
            errmsg = errmsg + this.checkNotNull(k, this.headers[k], feld_wert);
            if (feld_wert.equals("")) {
                try {
                    this.pst.setNull(k + 1, this.insert_types[k]);
                }
                catch (SQLException e1) {
                    errmsg = errmsg + this.conversionException(k, e1.toString());
                }
            } else {
                errmsg = errmsg + this.checkForeignKey(k, this.headers[k], feld_wert);
                switch (this.insert_types[k]) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        try {
                            int myInt = Integer.parseInt(feld_wert);
                            this.pst.setInt(k + 1, myInt);
                        }
                        catch (NumberFormatException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        catch (SQLException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        break;
                    }
                    case 6: {
                        try {
                            float myFloat = Float.parseFloat(feld_wert);
                            this.pst.setFloat(k + 1, myFloat);
                        }
                        catch (NumberFormatException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        catch (SQLException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 7: 
                    case 8: {
                        try {
                            double myDouble = Double.parseDouble(feld_wert);
                            this.pst.setDouble(k + 1, myDouble);
                        }
                        catch (NumberFormatException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        catch (SQLException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        break;
                    }
                    default: {
                        try {
                            this.pst.setString(k + 1, feld_wert);
                        }
                        catch (SQLException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        break;
                    }
                    case -1: {
                        ByteArrayInputStream by = new ByteArrayInputStream(feld_wert.getBytes());
                        this.pst.setAsciiStream(k + 1, (InputStream)by, feld_wert.length());
                        break;
                    }
                    case 91: {
                        try {
                            Date datum = DateUtils.parse(feld_wert);
                            feld_wert = DateUtils.formatUS(datum);
                            this.pst.setDate(k + 1, Date.valueOf(feld_wert));
                        }
                        catch (SQLException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        catch (ParseException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        catch (IllegalArgumentException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        break;
                    }
                    case 92: {
                        try {
                            this.pst.setTime(k + 1, Time.valueOf(feld_wert));
                        }
                        catch (SQLException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        catch (IllegalArgumentException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        break;
                    }
                    case 93: {
                        try {
                            java.util.Date datum = DateUtils.dateTimeParse(feld_wert);
                            feld_wert = DateUtils.dateTimeFormatUS(datum);
                            this.pst.setTimestamp(k + 1, Timestamp.valueOf(feld_wert + ".0"));
                        }
                        catch (SQLException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        catch (ParseException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        catch (IllegalArgumentException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                        break;
                    }
                    case -7: {
                        try {
                            boolean wf = Boolean.getBoolean(feld_wert);
                            this.pst.setBoolean(k + 1, wf);
                            break;
                        }
                        catch (SQLException e1) {
                            errmsg = errmsg + this.conversionException(k, e1.toString());
                            this.setFieldToNull(k);
                        }
                    }
                }
            }
        }
        return errmsg;
    }

    private String checkNotNull(int spaltennr, String name, String feld_wert) {
        String result = "";
        if (this.fieldsNotNull.contains(name) && (feld_wert == null || feld_wert.equals(""))) {
            result = "Error " + name + " (Spalte " + (spaltennr + 1) + ") darf nicht null sein ";
        }
        return result;
    }

    private String checkForeignKey(int spaltennr, String fieldname, String feld_wert) {
        String errmsg = "";
        List l = (List)this.foreignKeys.get(fieldname);
        if (l != null && !l.contains(feld_wert)) {
            errmsg = "Error " + fieldname + " (Spalte " + (spaltennr + 1) + ") enth\u00e4lt Wert (" + feld_wert + "), der nicht in foreign keys vorkommt ";
        }
        return errmsg;
    }

    private String createInsertStatement(String insert_stmt, String text, int k, int i) throws SQLException {
        int p;
        do {
            if ((p = text.indexOf(this.delim, i)) <= -1) continue;
            String delim1 = "";
            String delim2 = "";
            String feld_wert = text.substring(i, p);
            feld_wert = this.feld_wert_to_insert(k, feld_wert, delim1, delim2);
            insert_stmt = insert_stmt + feld_wert + ",";
            ++k;
            i = p + 1;
        } while (p > -1);
        insert_stmt = insert_stmt.substring(0, insert_stmt.length() - 1) + ");";
        return insert_stmt;
    }

    private String feld_wert_to_insert(int k, String feld_wert, String delim1, String delim2) throws SQLException {
        throw new IllegalArgumentException(" hier kein Foreign Key Kontrolle umgesetzt");
    }

    private void setFieldToNull(int k) {
        if (this.modeOnError.equals("exclude-field")) {
            try {
                this.pst.setNull(k + 1, this.insert_types[k]);
            }
            catch (SQLException e3) {
                this.logger.warning("Invalid Field " + (k + 1) + " could not be set to null");
            }
        }
    }

    private String conversionException(int k, String error) {
        String err_msg = "";
        err_msg = "Error in Column " + (k + 1) + ": " + error.toString() + "; ";
        this.logger.info(err_msg);
        return err_msg;
    }

    public static void main(String[] args) {
    }

    private void unzip(String zipfile) throws FileNotFoundException, IOException {
        File newFile = null;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipfile));
        ZipEntry ze = zis.getNextEntry();
        int count = 0;
        byte[] buffer = new byte[1024];
        while (ze != null) {
            int len;
            ++count;
            newFile = File.createTempFile("data", ".csv");
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        File zipF = new File(zipfile);
        zipF.delete();
        if (newFile == null) {
            throw new IOException("Keine Datei gefunden");
        }
        if (count > 1) {
            throw new IOException("Zip-File darf nur eine Datei enthalten");
        }
        newFile.renameTo(zipF);
    }
}

