/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.widgets;

import de.memtext.widgets.CardLayoutPanel;
import de.memtext.widgets.TitlePanel;
import de.memtext.widgets.VerticalBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MultiPanelViewer
extends JPanel
implements ItemListener {
    private JComboBox cbPanelSelection;
    private JLabel lblSelection1 = new JLabel();
    private boolean isHideSingleSelectionOption = true;
    private TitlePanel titlePanel = new TitlePanel();
    private CardLayoutPanel centerp = new CardLayoutPanel();
    JPanel pSelection = new JPanel();

    public MultiPanelViewer() {
        this("");
    }

    public MultiPanelViewer(String title) {
        super(new BorderLayout());
        this.installNorth();
        this.add((Component)new JScrollPane(this.centerp), "Center");
        this.setTitleText(title);
    }

    public Component getSelectedComponent() {
        return this.centerp.getSelectedComponent();
    }

    public void addPanel(JPanel p, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Panel name must not be null");
        }
        p.setName(name);
        this.addPanel(p);
    }

    public void addPanel(JPanel p) {
        if (p.getName() == null) {
            throw new IllegalArgumentException("Panel name must not be null");
        }
        this.centerp.add((Component)p, p.getName());
        this.cbPanelSelection.addItem(p.getName());
        if (this.isHideSingleSelectionOption) {
            this.cbPanelSelection.setVisible(this.cbPanelSelection.getItemCount() > 1);
        }
    }

    public void removePanel(JPanel p) {
        this.centerp.remove(p);
        this.cbPanelSelection.removeItem(p.getName());
        if (this.isHideSingleSelectionOption) {
            this.cbPanelSelection.setVisible(this.cbPanelSelection.getItemCount() > 1);
        }
    }

    public void setTitleText(String txt) {
        this.titlePanel.setTitleText(txt);
    }

    public void setSelectionText(String txt) {
        this.lblSelection1.setText(txt);
    }

    public void addToSelectionP(JComponent comp) {
        this.pSelection.add(comp);
    }

    public void addToSelectionP(JComponent comp, int pos) {
        this.pSelection.add((Component)comp, pos);
    }

    private void installNorth() {
        VerticalBox north = new VerticalBox();
        north.add(this.titlePanel);
        north.add(this.pSelection);
        this.cbPanelSelection = new JComboBox();
        this.cbPanelSelection.addItemListener(this);
        this.pSelection.add(this.lblSelection1);
        this.pSelection.add(this.cbPanelSelection);
        this.add((Component)north, "North");
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() != 1) {
            return;
        }
        if (ie.getSource() == this.cbPanelSelection) {
            this.centerp.show(ie.getItem().toString());
        }
    }
}

