/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.db.ConnectionCreator;
import de.memtext.db.DbUtils;
import de.memtext.util.StringUtils;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;

public class ManTool {
    private final String REPORT = "KENN_PBV_ASTAT4";
    private final String GROUPING = "KENN_VTS_POSLEIT";
    private final String IDSTART = "KENN_ASTAT_VTS_KANZ";
    private final String NAMESTART = "Verwaltungs-,technisches und sonstiges Personal Kanzler/in";
    private final String WHERESTART = "ef35='5'";
    private final String TIMEUNIT = "J";
    private final String FLD_JAHR = "jahr";
    private final String FROMCLAUSE = "kenn_pbv_astat";
    private final String AGGRFUNCTION = "count(*)";
    private int manCatalogueTid = -1;
    private int manCatalogueRptTid = -1;
    private int manCatalogueRptSort = -1;
    private int incrementRptSort = 10;
    private String dbprops;

    ManTool(String dbprops) {
        this.dbprops = dbprops;
    }

    private void run() {
        this.initTids();
        ArrayList<Variante> varianten = new ArrayList<Variante>();
        varianten.add(new Variante("", "", "", null, null));
        varianten.add(new Variante("_W", " (weiblich)", "and ef23=2", null, null));
        for (Variante v : varianten) {
            System.out.println(v.toSql());
            ++this.manCatalogueTid;
            ++this.manCatalogueRptTid;
            this.manCatalogueRptSort += this.incrementRptSort;
        }
    }

    private void initTids() {
        try {
            Connection con = ConnectionCreator.getConnectionCryptPassword(this.dbprops, "driverName", "connectionURL", "connectionName", "connectionPassword");
            Statement stm = con.createStatement();
            this.manCatalogueTid = DbUtils.getInt(stm, "select max(tid) from man_catalogue") + 1;
            this.manCatalogueRptTid = DbUtils.getInt(stm, "select max(tid) from man_catalogue_rpt") + 1;
            this.manCatalogueRptSort = DbUtils.getInt(stm, "select max(sortnr) from man_catalogue_rpt where report_id='KENN_PBV_ASTAT4'") + 10;
        }
        catch (Exception e) {
            System.out.println("ERROR: Verbindung konnte nicht aufgebaut werden.\n" + e);
            System.exit(1);
        }
    }

    public static void main(String[] a) {
        if (a.length == 1) {
            ManTool m = new ManTool(a[0]);
            m.run();
        } else {
            System.out.println("Aufruf Pfad zu DB-Properties \u00fcbergeben");
        }
    }

    class Variante {
        private String idSuffix;
        private String nameSuffix;
        private String whereSuffix;
        private String replaceSource;
        private String replaceTarget;

        Variante(String idSuffix, String nameSuffix, String whereSuffix, String replaceSource, String replaceTarget) {
            this.idSuffix = idSuffix;
            this.nameSuffix = nameSuffix;
            this.whereSuffix = whereSuffix;
            this.replaceSource = replaceSource;
            this.replaceTarget = replaceTarget;
        }

        String toSql() {
            String id = "KENN_ASTAT_VTS_KANZ" + this.idSuffix;
            String name = "Verwaltungs-,technisches und sonstiges Personal Kanzler/in" + this.nameSuffix;
            String whereclause = "ef35='5' " + this.whereSuffix;
            if (this.replaceSource != null && this.replaceTarget != null) {
                whereclause = StringUtils.replace(whereclause, this.replaceSource, this.replaceTarget);
            }
            whereclause = StringUtils.replace(whereclause, "'", "''");
            String sql = "INSERT INTO man_catalogue \n( \n  tid, \n  id, \n  shortname, \n  name, \n  description, \n  timeunit, \n  decimalplaces, \n  sqlchunk, \n  linksub, \n  linktimeline, \n  restrictedgroupids, \n  ismanual, \n  requiredfields, \n  calcratio, \n  gueltig_von, \n  gueltig_bis, \n  cleanup, \n  preparation, \n  techdetails, \n  moreinfo, \n  attrib1, \n  fld_semester, \n  fld_jahr, \n  fld_studiengang, \n  fld_institut, \n  fld_geschlecht, \n  fromclause, \n  whereclause, \n  aggrfunction, \n  cacheing, \n  linktable, \n  linkmask \n) \nVALUES \n( \n" + ManTool.this.manCatalogueTid + " , \n  '" + id + "', \n  '" + name + "', \n  '" + name + "', \n  '" + name + "', \n  '" + "J" + "', \n  0, \n  NULL, \n  NULL, \n  NULL, \n  '                                                                                                                                                                                                                                                               ', \n  0, \n  '', \n  0, \n  '1900-01-01', \n  '3000-12-31', \n  NULL, \n  NULL, \n  NULL, \n  NULL, \n  0, \n  '', \n  '" + "jahr" + "', \n  '', \n  '', \n  '', \n  '" + "kenn_pbv_astat" + "', \n  '" + whereclause + "', \n  '" + "count(*)" + "', \n  1, \n  '', \n  '' \n); \n";
            String sql2 = "INSERT INTO man_catalogue_rpt \n( \n  tid, \n  report_id, \n  catalogue_id, \n  description, \n  sortnr, \n  sortnr2, \n  grouping1, \n  grouping2, \n  valid_from, \n  valid_till, \n  active \n) \nVALUES \n( \n" + ManTool.this.manCatalogueRptTid + "  , \n  '" + "KENN_PBV_ASTAT4" + "', \n  '" + id + "', \n  NULL, \n" + ManTool.this.manCatalogueRptSort + " , \n  1, \n  '" + "KENN_VTS_POSLEIT" + "', \n  '                                        ', \n  '1900-01-01', \n  '3000-12-31', \n  1 \n); \n";
            return sql + "\n" + sql2;
        }
    }
}

