/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.db.HsqlStandaloneMgr;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class SampleApp
extends JFrame {
    private Connection con = null;
    private String path = "";
    private String dbname = "testing";

    public SampleApp() throws ClassNotFoundException, SQLException, IOException {
        super("SampleApp");
        this.initDb();
        JLabel lbl = new JLabel("got a connection to " + this.con.getMetaData().getURL());
        this.getContentPane().add(lbl);
        this.setSize(600, 400);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                try {
                    String url = SampleApp.this.con.getMetaData().getURL();
                    Statement stmt = SampleApp.this.con.createStatement();
                    stmt.execute("shutdown");
                    stmt.close();
                    SampleApp.this.con.close();
                    HsqlStandaloneMgr.deleteTmpFiles(url, SampleApp.this.path, SampleApp.this.dbname);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                System.exit(0);
            }
        });
    }

    private void initDb() throws ClassNotFoundException, SQLException, IOException {
        if (!HsqlStandaloneMgr.isDatabaseOpen(this.path, this.dbname)) {
            this.con = HsqlStandaloneMgr.getConnection(this.path, this.dbname, "sa", "");
            Statement stmt = this.con.createStatement();
            stmt.execute("drop table test if exists;create table test( col1 integer);insert into test values(1);checkpoint;");
            stmt.close();
        } else {
            boolean isReadOnlyModeWanted = true;
            int result = HsqlStandaloneMgr.askUser(this, this.path, this.dbname, isReadOnlyModeWanted);
            if (result == 0) {
                this.con = HsqlStandaloneMgr.getTmpConnection(this, this.path, this.dbname, "sa", "", isReadOnlyModeWanted);
            } else {
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) {
        try {
            SampleApp app = new SampleApp();
            app.show();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

