/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util.export;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.olap4j.CellSet;
import org.saiku.olap.dto.resultset.AbstractBaseCell;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.dto.resultset.DataCell;
import org.saiku.olap.dto.resultset.MemberCell;
import org.saiku.olap.util.OlapResultSetUtil;
import org.saiku.olap.util.formatter.CellSetFormatter;
import org.saiku.olap.util.formatter.ICellSetFormatter;
import org.saiku.service.util.KeyValue;
import org.saiku.service.util.exception.SaikuServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvExporter {
    public static byte[] exportCsv(CellSet cellSet) {
        return CsvExporter.exportCsv(cellSet, ",", "\"");
    }

    public static byte[] exportCsv(CellSet cellSet, String delimiter, String enclosing) {
        return CsvExporter.exportCsv(cellSet, delimiter, enclosing, new CellSetFormatter());
    }

    public static byte[] exportCsv(CellSet cellSet, String delimiter, String enclosing, ICellSetFormatter formatter) {
        CellDataSet table = OlapResultSetUtil.cellSet2Matrix(cellSet, formatter);
        return CsvExporter.getCsv(table, delimiter, enclosing);
    }

    public static byte[] exportCsv(ResultSet rs) {
        return CsvExporter.getCsv(rs, ",", "\"", true, null);
    }

    public static byte[] exportCsv(ResultSet rs, String delimiter, String enclosing) {
        return CsvExporter.getCsv(rs, delimiter, enclosing, true, null);
    }

    public static byte[] exportCsv(ResultSet rs, String delimiter, String enclosing, boolean printHeader, List<KeyValue<String, String>> additionalColumns) {
        return CsvExporter.getCsv(rs, delimiter, enclosing, printHeader, additionalColumns);
    }

    private static byte[] getCsv(ResultSet rs, String delimiter, String enclosing, boolean printHeader, List<KeyValue<String, String>> additionalColumns) {
        Integer width = 0;
        Integer height = 0;
        StringBuilder sb = new StringBuilder();
        String addCols = null;
        try {
            while (rs.next()) {
                if (height == 0) {
                    width = rs.getMetaData().getColumnCount();
                    String header = null;
                    if (additionalColumns != null) {
                        for (KeyValue<String, String> kv : additionalColumns) {
                            if (header == null) {
                                header = "";
                                addCols = "";
                            } else {
                                header = header + delimiter;
                            }
                            header = header + enclosing + kv.getKey() + enclosing;
                            addCols = addCols + enclosing + kv.getValue() + enclosing + delimiter;
                        }
                    }
                    for (int s = 0; s < width; ++s) {
                        header = header != null ? header + delimiter : "";
                        header = header + enclosing + rs.getMetaData().getColumnName(s + 1) + enclosing;
                    }
                    if (header != null && printHeader) {
                        header = header + "\r\n";
                        sb.append(header);
                    }
                }
                if (addCols != null) {
                    sb.append(addCols);
                }
                for (int i = 0; i < width; ++i) {
                    String content = rs.getString(i + 1);
                    if (content == null) {
                        content = "";
                    }
                    if (i > 0) {
                        sb.append(delimiter);
                    }
                    sb.append(enclosing + content + enclosing);
                }
                sb.append("\r\n");
                Integer i = height;
                Integer n = height = Integer.valueOf(height + 1);
            }
            return sb.toString().getBytes("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private static byte[] getCsv(CellDataSet table, String delimiter, String enclosing) {
        if (table != null) {
            int x;
            AbstractBaseCell[][] rowData = table.getCellSetBody();
            AbstractBaseCell[][] rowHeader = table.getCellSetHeaders();
            boolean offset = rowHeader.length > 0;
            String[][] result = new String[(offset ? 1 : 0) + rowData.length][];
            if (offset) {
                ArrayList<String> cols = new ArrayList<String>();
                for (x = 0; x < rowHeader[0].length; ++x) {
                    String col = null;
                    for (int y = rowHeader.length - 1; y >= 0; --y) {
                        String value = rowHeader[y][x].getFormattedValue();
                        if (value == null || "null".equals(value)) {
                            value = "";
                        }
                        if (col == null && StringUtils.isNotBlank((String)value)) {
                            col = value;
                            continue;
                        }
                        if (col == null || !StringUtils.isNotBlank((String)value)) continue;
                        col = value + "/" + col;
                    }
                    cols.add(enclosing + col + enclosing);
                }
                result[0] = cols.toArray(new String[cols.size()]);
            }
            String[] lastKnownHeader = null;
            for (x = 0; x < rowData.length; ++x) {
                int xTarget = (offset ? 1 : 0) + x;
                if (lastKnownHeader == null) {
                    lastKnownHeader = new String[rowData[x].length];
                }
                ArrayList<String> cols = new ArrayList<String>();
                for (int y = 0; y < rowData[x].length; ++y) {
                    String value = rowData[x][y].getFormattedValue();
                    if (rowData[x][y] instanceof DataCell && ((DataCell)rowData[x][y]).getRawNumber() != null) {
                        value = ((DataCell)rowData[x][y]).getRawNumber().toString();
                    }
                    if (rowData[x][y] instanceof MemberCell && StringUtils.isNotBlank((String)value) && !"null".equals(value)) {
                        lastKnownHeader[y] = value;
                    } else if (rowData[x][y] instanceof MemberCell && (StringUtils.isBlank((String)value) || "null".equals(value))) {
                        String string = value = StringUtils.isNotBlank((String)lastKnownHeader[y]) ? lastKnownHeader[y] : null;
                    }
                    if (value == null || "null".equals(value)) {
                        value = "";
                    }
                    value = enclosing + value + enclosing;
                    cols.add(value);
                }
                result[xTarget] = cols.toArray(new String[cols.size()]);
            }
            return CsvExporter.export(result, delimiter);
        }
        return new byte[0];
    }

    private static byte[] export(String[][] resultSet, String delimiter) {
        try {
            String output = "";
            StringBuffer buf = new StringBuffer();
            if (resultSet.length > 0) {
                for (int i = 0; i < resultSet.length; ++i) {
                    String[] vs = resultSet[i];
                    for (int j = 0; j < vs.length; ++j) {
                        String value = vs[j];
                        if (j > 0) {
                            buf.append(delimiter + value);
                            continue;
                        }
                        buf.append(value);
                    }
                    buf.append("\r\n");
                }
                output = buf.toString();
                return output.getBytes("UTF8");
            }
        }
        catch (Throwable e) {
            throw new SaikuServiceException("Error creating csv export for query");
        }
        return new byte[0];
    }
}

