/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.OlapException;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.saiku.olap.dto.SaikuAxis;
import org.saiku.olap.dto.SaikuDimension;
import org.saiku.olap.dto.SaikuDimensionSelection;
import org.saiku.olap.dto.SaikuHierarchy;
import org.saiku.olap.dto.SaikuLevel;
import org.saiku.olap.dto.SaikuMeasure;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.dto.SaikuQuery;
import org.saiku.olap.dto.SaikuSelection;
import org.saiku.olap.query.IQuery;
import org.saiku.service.util.exception.SaikuServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtil {
    public static SaikuDimension convert(Dimension dim) {
        SaikuDimension sDim = new SaikuDimension(dim.getName(), dim.getUniqueName(), dim.getCaption(), dim.getDescription(), dim.isVisible(), ObjectUtil.convertHierarchies((List<Hierarchy>)dim.getHierarchies()));
        return sDim;
    }

    public static SaikuDimension convert(QueryDimension dim) {
        return ObjectUtil.convert(dim.getDimension());
    }

    public static List<SaikuDimension> convertQueryDimensions(List<QueryDimension> dims) {
        ArrayList<SaikuDimension> dimList = new ArrayList<SaikuDimension>();
        for (QueryDimension d : dims) {
            dimList.add(ObjectUtil.convert(d));
        }
        return dimList;
    }

    public static List<SaikuDimension> convertDimensions(List<Dimension> dims) {
        ArrayList<SaikuDimension> dimList = new ArrayList<SaikuDimension>();
        for (Dimension d : dims) {
            dimList.add(ObjectUtil.convert(d));
        }
        return dimList;
    }

    public static List<SaikuHierarchy> convertHierarchies(List<Hierarchy> hierarchies) {
        ArrayList<SaikuHierarchy> hierarchyList = new ArrayList<SaikuHierarchy>();
        for (Hierarchy h : hierarchies) {
            hierarchyList.add(ObjectUtil.convert(h));
        }
        return hierarchyList;
    }

    public static SaikuHierarchy convert(Hierarchy hierarchy) {
        try {
            return new SaikuHierarchy(hierarchy.getName(), hierarchy.getUniqueName(), hierarchy.getCaption(), hierarchy.getDescription(), hierarchy.getDimension().getUniqueName(), hierarchy.isVisible(), ObjectUtil.convertLevels((List<Level>)hierarchy.getLevels()), ObjectUtil.convertMembers((Collection<Member>)hierarchy.getRootMembers()));
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Cannot get root members", e);
        }
    }

    public static List<SaikuLevel> convertLevels(List<Level> levels) {
        ArrayList<SaikuLevel> levelList = new ArrayList<SaikuLevel>();
        for (Level l : levels) {
            levelList.add(ObjectUtil.convert(l));
        }
        return levelList;
    }

    public static SaikuLevel convert(Level level) {
        try {
            return new SaikuLevel(level.getName(), level.getUniqueName(), level.getCaption(), level.getDescription(), level.getDimension().getUniqueName(), level.getHierarchy().getUniqueName(), level.isVisible());
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot convert level: " + level, e);
        }
    }

    public static List<SaikuMember> convertMembers(Collection<Member> members) {
        ArrayList<SaikuMember> memberList = new ArrayList<SaikuMember>();
        for (Member l : members) {
            memberList.add(ObjectUtil.convert(l));
        }
        return memberList;
    }

    public static List<SaikuSelection> convertSelections(List<Selection> selections) {
        ArrayList<SaikuSelection> selectionList = new ArrayList<SaikuSelection>();
        for (Selection sel : selections) {
            selectionList.add(ObjectUtil.convert(sel));
        }
        return selectionList;
    }

    private static SaikuSelection convert(Selection sel) {
        String levelUniqueName;
        String hierarchyUniqueName;
        SaikuSelection.Type type;
        if (Level.class.isAssignableFrom(sel.getRootElement().getClass())) {
            type = SaikuSelection.Type.LEVEL;
            hierarchyUniqueName = ((Level)sel.getRootElement()).getHierarchy().getUniqueName();
            levelUniqueName = sel.getUniqueName();
        } else {
            type = SaikuSelection.Type.MEMBER;
            hierarchyUniqueName = ((Member)sel.getRootElement()).getHierarchy().getUniqueName();
            levelUniqueName = ((Member)sel.getRootElement()).getLevel().getUniqueName();
        }
        return new SaikuSelection(sel.getRootElement().getName(), sel.getUniqueName(), sel.getRootElement().getCaption(), sel.getRootElement().getDescription(), sel.getDimension().getName(), hierarchyUniqueName, levelUniqueName, type);
    }

    public static SaikuMember convert(Member m) {
        return new SaikuMember(m.getName(), m.getUniqueName(), m.getCaption(), m.getDescription(), m.getDimension().getUniqueName(), m.getHierarchy().getUniqueName(), m.getLevel().getUniqueName());
    }

    public static SaikuMember convertMeasure(Measure m) {
        return new SaikuMeasure(m.getName(), m.getUniqueName(), m.getCaption(), m.getDescription(), m.getDimension().getUniqueName(), m.getHierarchy().getUniqueName(), m.getLevel().getUniqueName(), m.isCalculated() | m.isCalculatedInQuery());
    }

    public static SaikuDimensionSelection convertDimensionSelection(QueryDimension dim) {
        List<SaikuSelection> selections = ObjectUtil.convertSelections(dim.getInclusions());
        return new SaikuDimensionSelection(dim.getName(), dim.getDimension().getUniqueName(), dim.getDimension().getCaption(), dim.getDimension().getDescription(), selections);
    }

    public static List<SaikuDimensionSelection> convertDimensionSelections(List<QueryDimension> dimensions) {
        ArrayList<SaikuDimensionSelection> dims = new ArrayList<SaikuDimensionSelection>();
        for (QueryDimension dim : dimensions) {
            dims.add(ObjectUtil.convertDimensionSelection(dim));
        }
        return dims;
    }

    public static SaikuAxis convertQueryAxis(QueryAxis axis) {
        List<SaikuDimensionSelection> dims = ObjectUtil.convertDimensionSelections(axis.getDimensions());
        Axis location = axis.getLocation();
        String so = axis.getSortOrder() == null ? null : axis.getSortOrder().name();
        SaikuAxis sax = new SaikuAxis(location.name(), location.axisOrdinal(), axis.getName(), dims, so, axis.getSortIdentifierNodeName());
        try {
            if (axis.getLimitFunction() != null) {
                sax.setLimitFunction(axis.getLimitFunction().toString());
                sax.setLimitFunctionN(axis.getLimitFunctionN().toPlainString());
                sax.setLimitFunctionSortLiteral(axis.getLimitFunctionSortLiteral());
            }
            if (StringUtils.isNotBlank((String)axis.getFilterCondition())) {
                sax.setFilterCondition(axis.getFilterCondition());
            }
        }
        catch (Error e) {
            // empty catch block
        }
        return sax;
    }

    public static SaikuQuery convert(IQuery q) {
        ArrayList<SaikuAxis> axes = new ArrayList<SaikuAxis>();
        if (q.getType().equals((Object)IQuery.QueryType.QM)) {
            for (Axis axis : q.getAxes().keySet()) {
                if (axis == null) continue;
                axes.add(ObjectUtil.convertQueryAxis(q.getAxis(axis)));
            }
        }
        return new SaikuQuery(q.getName(), q.getSaikuCube(), axes, q.getMdx(), q.getType().toString(), q.getProperties());
    }
}

