/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming.examples;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.poi.examples.util.TempFileUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.crypt.temp.EncryptedTempData;
import org.apache.poi.poifs.crypt.temp.SXSSFWorkbookWithCustomZipEntrySource;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class SavePasswordProtectedXlsx {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected 2 params: filename and password");
        }
        TempFileUtils.checkTempFiles();
        String filename = args[0];
        String password = args[1];
        SXSSFWorkbookWithCustomZipEntrySource wb = new SXSSFWorkbookWithCustomZipEntrySource();
        try {
            for (int i = 0; i < 10; ++i) {
                SXSSFSheet sheet = wb.createSheet("Sheet" + i);
                for (int r = 0; r < 1000; ++r) {
                    SXSSFRow row = sheet.createRow(r);
                    for (int c = 0; c < 100; ++c) {
                        SXSSFCell cell = row.createCell(c);
                        cell.setCellValue("abcd");
                    }
                }
            }
            EncryptedTempData tempData = new EncryptedTempData();
            try {
                wb.write(tempData.getOutputStream());
                SavePasswordProtectedXlsx.save(tempData.getInputStream(), filename, password);
                System.out.println("Saved " + filename);
            }
            finally {
                tempData.dispose();
            }
        }
        finally {
            wb.close();
            wb.dispose();
        }
        TempFileUtils.checkTempFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(InputStream inputStream, String filename, String pwd) throws InvalidFormatException, IOException, GeneralSecurityException {
        POIFSFileSystem fs = null;
        FileOutputStream fos = null;
        OPCPackage opc = null;
        try {
            fs = new POIFSFileSystem();
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
            Encryptor enc = Encryptor.getInstance((EncryptionInfo)info);
            enc.confirmPassword(pwd);
            opc = OPCPackage.open((InputStream)inputStream);
            fos = new FileOutputStream(filename);
            opc.save(enc.getDataStream(fs));
            fs.writeFilesystem((OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            IOUtils.closeQuietly(opc);
            IOUtils.closeQuietly((Closeable)fs);
            IOUtils.closeQuietly((Closeable)inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fos);
        IOUtils.closeQuietly((Closeable)opc);
        IOUtils.closeQuietly((Closeable)fs);
        IOUtils.closeQuietly((Closeable)inputStream);
    }
}

