/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples.html;

import java.util.Formatter;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.examples.html.HtmlHelper;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public class HSSFHtmlHelper
implements HtmlHelper {
    private final HSSFWorkbook wb;
    private final HSSFPalette colors;
    private static final HSSFColor HSSF_AUTO = HSSFColor.HSSFColorPredefined.AUTOMATIC.getColor();

    public HSSFHtmlHelper(HSSFWorkbook wb) {
        this.wb = wb;
        this.colors = wb.getCustomPalette();
    }

    @Override
    public void colorStyles(CellStyle style, Formatter out) {
        HSSFCellStyle cs = (HSSFCellStyle)style;
        out.format("  /* fill pattern = %d */%n", cs.getFillPatternEnum().getCode());
        this.styleColor(out, "background-color", cs.getFillForegroundColor());
        this.styleColor(out, "color", cs.getFont((Workbook)this.wb).getColor());
        this.styleColor(out, "border-left-color", cs.getLeftBorderColor());
        this.styleColor(out, "border-right-color", cs.getRightBorderColor());
        this.styleColor(out, "border-top-color", cs.getTopBorderColor());
        this.styleColor(out, "border-bottom-color", cs.getBottomBorderColor());
    }

    private void styleColor(Formatter out, String attr, short index) {
        HSSFColor color = this.colors.getColor(index);
        if (index == HSSF_AUTO.getIndex() || color == null) {
            out.format("  /* %s: index = %d */%n", attr, index);
        } else {
            short[] rgb = color.getTriplet();
            out.format("  %s: #%02x%02x%02x; /* index = %d */%n", attr, rgb[0], rgb[1], rgb[2], index);
        }
    }
}

