/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.view;

import java.awt.Color;
import java.awt.Font;
import java.util.Map;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.util.HSSFColor;

public class SVTableUtils {
    private static final Map<Integer, HSSFColor> colors = HSSFColor.getIndexHash();
    public static final Color black = SVTableUtils.getAWTColor(HSSFColor.HSSFColorPredefined.BLACK);
    public static final Color white = SVTableUtils.getAWTColor(HSSFColor.HSSFColorPredefined.WHITE);
    public static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public static Font makeFont(HSSFFont font) {
        int fontheight;
        boolean isbold = font.getBold();
        boolean isitalics = font.getItalic();
        int fontstyle = 0;
        if (isbold) {
            fontstyle = 1;
        }
        if (isitalics) {
            fontstyle |= 2;
        }
        if ((fontheight = font.getFontHeightInPoints()) == 9) {
            fontheight = 10;
        }
        return new Font(font.getFontName(), fontstyle, fontheight);
    }

    static final Color getAWTColor(int index, Color deflt) {
        HSSFColor clr = colors.get(index);
        if (clr == null) {
            return deflt;
        }
        short[] rgb = clr.getTriplet();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    static final Color getAWTColor(HSSFColor.HSSFColorPredefined clr) {
        short[] rgb = clr.getTriplet();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }
}

