/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.resource.MondrianResource;

class ToggleDrillStateFunDef
extends FunDefBase {
    static final String[] ReservedWords = new String[]{"RECURSIVE"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("ToggleDrillState", "ToggleDrillState(<Set1>, <Set2>[, RECURSIVE])", "Toggles the drill state of members. This function is a combination of DrillupMember and DrilldownMember.", new String[]{"fxxx", "fxxxy"}, ToggleDrillStateFunDef.class, ReservedWords);

    public ToggleDrillStateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        if (call.getArgCount() > 2) {
            throw MondrianResource.instance().ToggleDrillStateRecursiveNotSupported.ex();
        }
        final ListCalc listCalc0 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc1 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc0, listCalc1}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                TupleList list0 = listCalc0.evaluateList(evaluator);
                TupleList list1 = listCalc1.evaluateList(evaluator);
                return ToggleDrillStateFunDef.this.toggleDrillStateTuples(evaluator, list0, list1);
            }
        };
    }

    TupleList toggleDrillStateTuples(Evaluator evaluator, TupleList v0, TupleList list1) {
        assert (list1.getArity() == 1);
        if (list1.isEmpty()) {
            return v0;
        }
        if (v0.isEmpty()) {
            return v0;
        }
        Member[] members = new Member[v0.getArity()];
        HashSet<Member> set = new HashSet<Member>(list1.slice(0));
        TupleList result = v0.cloneList(v0.size() * 3 / 2 + 1);
        int i = 0;
        int n = v0.size();
        while (i < n) {
            boolean strict;
            List next;
            Member nextMember;
            List o = (List)v0.get(i++);
            result.add(o);
            Member m = null;
            int k = -1;
            for (int j = 0; j < o.size(); ++j) {
                Member member = (Member)o.get(j);
                if (!set.contains(member)) continue;
                k = j;
                m = member;
                break;
            }
            if (k == -1) continue;
            boolean isDrilledDown = false;
            if (i < n && FunUtil.isAncestorOf(m, nextMember = (Member)(next = (List)v0.get(i)).get(k), strict = true)) {
                isDrilledDown = true;
            }
            if (isDrilledDown) {
                while (FunUtil.isAncestorOf(m, nextMember = (Member)(next = (List)v0.get(i)).get(k), strict = true) && ++i < n) {
                }
                continue;
            }
            List<Member> children = evaluator.getSchemaReader().getMemberChildren(m);
            for (Member child : children) {
                o.toArray(members);
                members[k] = child;
                result.addTuple(members);
            }
        }
        return result;
    }
}

