/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stepsmetrics;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.stepsmetrics.StepsMetricsData;
import org.pentaho.di.trans.steps.stepsmetrics.StepsMetricsMeta;

public class StepsMetrics
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = StepsMetrics.class;
    private StepsMetricsMeta meta;
    private StepsMetricsData data;
    public HashSet<StepInterface> stepInterfaces;

    public StepsMetrics(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (StepsMetricsMeta)smi;
        this.data = (StepsMetricsData)sdi;
        if (this.first) {
            this.first = false;
            String[] stepnames = null;
            int stepnrs = 0;
            if (this.meta.getStepName() == null || this.meta.getStepName().length <= 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"StepsMetrics.Error.NotSteps", (String[])new String[0]));
            }
            stepnames = this.meta.getStepName();
            stepnrs = stepnames.length;
            this.data.realstepnamefield = this.environmentSubstitute(this.meta.getStepNameFieldName());
            this.data.realstepidfield = this.environmentSubstitute(this.meta.getStepIdFieldName());
            this.data.realsteplinesinputfield = this.environmentSubstitute(this.meta.getStepLinesInputFieldName());
            this.data.realsteplinesoutputfield = this.environmentSubstitute(this.meta.getStepLinesOutputFieldName());
            this.data.realsteplinesreadfield = this.environmentSubstitute(this.meta.getStepLinesReadFieldName());
            this.data.realsteplineswrittentfield = this.environmentSubstitute(this.meta.getStepLinesWrittenFieldName());
            this.data.realsteplinesupdatedfield = this.environmentSubstitute(this.meta.getStepLinesUpdatedFieldName());
            this.data.realsteplineserrorsfield = this.environmentSubstitute(this.meta.getStepLinesErrorsFieldName());
            this.data.realstepsecondsfield = this.environmentSubstitute(this.meta.getStepSecondsFieldName());
            String[] targetSteps = this.getTransMeta().getNextStepNames(this.getStepMeta());
            this.data.stepInterfaces = new ConcurrentHashMap();
            for (int i = 0; i < stepnrs; ++i) {
                if (stepnames[i].equals(this.getStepname())) {
                    throw new KettleException("You can not get metrics for the current step [" + stepnames[i] + "]!");
                }
                if (targetSteps != null) {
                    for (int j = 0; j < targetSteps.length; ++j) {
                        if (!stepnames[i].equals(targetSteps[j])) continue;
                        throw new KettleException("You can not get metrics for the target step [" + targetSteps[i] + "]!");
                    }
                }
                int CopyNr = Const.toInt((String)this.meta.getStepCopyNr()[i], (int)0);
                StepInterface si = this.getTrans().getStepInterface(stepnames[i], CopyNr);
                if (si != null) {
                    this.data.stepInterfaces.put(i, this.getDispatcher().findBaseSteps(stepnames[i]).get(CopyNr));
                    continue;
                }
                if (!this.meta.getStepRequired()[i].equals("Y")) continue;
                throw new KettleException("We cannot get step [" + stepnames[i] + "] CopyNr=" + CopyNr + "!");
            }
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
        }
        this.data.continueLoop = true;
        while (this.data.continueLoop && !this.isStopped()) {
            this.data.continueLoop = false;
            for (Map.Entry<Integer, StepInterface> e : this.data.stepInterfaces.entrySet()) {
                StepInterface step = e.getValue();
                if (step.getStatus() != BaseStepData.StepExecutionStatus.STATUS_FINISHED) {
                    this.data.continueLoop = true;
                    continue;
                }
                this.data.stepInterfaces.remove(e.getKey());
                if (this.log.isDetailed()) {
                    this.logDetailed("Finished running step [" + step.getStepname() + "(" + step.getCopy() + ")].");
                }
                Object[] rowData = this.buildEmptyRow();
                this.incrementLinesRead();
                int index = 0;
                if (!Const.isEmpty((String)this.data.realstepnamefield)) {
                    rowData[index++] = step.getStepname();
                }
                if (!Const.isEmpty((String)this.data.realstepidfield)) {
                    rowData[index++] = step.getStepID();
                }
                if (!Const.isEmpty((String)this.data.realsteplinesinputfield)) {
                    rowData[index++] = step.getLinesInput();
                }
                if (!Const.isEmpty((String)this.data.realsteplinesoutputfield)) {
                    rowData[index++] = step.getLinesOutput();
                }
                if (!Const.isEmpty((String)this.data.realsteplinesreadfield)) {
                    rowData[index++] = step.getLinesRead();
                }
                if (!Const.isEmpty((String)this.data.realsteplinesupdatedfield)) {
                    rowData[index++] = step.getLinesUpdated();
                }
                if (!Const.isEmpty((String)this.data.realsteplineswrittentfield)) {
                    rowData[index++] = step.getLinesWritten();
                }
                if (!Const.isEmpty((String)this.data.realsteplineserrorsfield)) {
                    rowData[index++] = step.getLinesRejected();
                }
                if (!Const.isEmpty((String)this.data.realstepsecondsfield)) {
                    rowData[index++] = step.getRuntime();
                }
                this.putRow(this.data.outputRowMeta, rowData);
            }
            if (!this.data.continueLoop) continue;
            try {
                Thread.sleep(200L);
            }
            catch (Exception d) {}
        }
        this.setOutputDone();
        return false;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (StepsMetricsMeta)smi;
        this.data = (StepsMetricsData)sdi;
        return super.init(smi, sdi);
    }
}

