/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.parallelgzipcsv;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.parallelgzipcsv.ParGzipCsvInputMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class ParGzipCsvInputMetaInjection
implements StepMetaInjectionInterface {
    private ParGzipCsvInputMeta meta;

    public ParGzipCsvInputMetaInjection(ParGzipCsvInputMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] aggEntries;
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.FILENAME, Entry.FILENAME_FIELD, Entry.INCLUDING_FILENAMES, Entry.ROW_NUMBER_FIELD, Entry.HEADER_PRESENT, Entry.DELIMITER, Entry.ENCLOSURE, Entry.BUFFER_SIZE, Entry.LAZY_CONVERSION, Entry.ADD_FILES_TO_RESULT, Entry.RUN_IN_PARALLEL, Entry.ENCODING}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.FIELDS.name(), 0, Entry.FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.FIELD.name(), 0, Entry.FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : aggEntries = new Entry[]{Entry.FIELD_NAME, Entry.FIELD_POSITION, Entry.FIELD_LENGTH, Entry.FIELD_TYPE, Entry.FIELD_IGNORE, Entry.FIELD_FORMAT, Entry.FIELD_TRIM_TYPE, Entry.FIELD_PRECISION, Entry.FIELD_DECIMAL, Entry.FIELD_GROUP, Entry.FIELD_CURRENCY, Entry.FIELD_REPEAT, Entry.FIELD_NULL_STRING, Entry.FIELD_IF_NULL}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<TextFileInputField> fields = new ArrayList<TextFileInputField>();
        block31: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case FIELDS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.FIELD) continue;
                        TextFileInputField field = new TextFileInputField();
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case FIELD_NAME: {
                                    field.setName(value);
                                    break;
                                }
                                case FIELD_POSITION: {
                                    field.setPosition(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case FIELD_LENGTH: {
                                    field.setLength(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case FIELD_TYPE: {
                                    field.setType(ValueMeta.getType((String)value));
                                    break;
                                }
                                case FIELD_IGNORE: {
                                    field.setIgnored("Y".equalsIgnoreCase(value));
                                    break;
                                }
                                case FIELD_FORMAT: {
                                    field.setFormat(value);
                                    break;
                                }
                                case FIELD_TRIM_TYPE: {
                                    field.setTrimType(ValueMeta.getTrimTypeByCode((String)value));
                                    break;
                                }
                                case FIELD_PRECISION: {
                                    field.setPrecision(Const.toInt((String)value, (int)-1));
                                    break;
                                }
                                case FIELD_DECIMAL: {
                                    field.setDecimalSymbol(value);
                                    break;
                                }
                                case FIELD_GROUP: {
                                    field.setGroupSymbol(value);
                                    break;
                                }
                                case FIELD_CURRENCY: {
                                    field.setCurrencySymbol(value);
                                    break;
                                }
                                case FIELD_REPEAT: {
                                    field.setRepeated("Y".equalsIgnoreCase(value));
                                    break;
                                }
                                case FIELD_NULL_STRING: {
                                    field.setNullString(value);
                                    break;
                                }
                                case FIELD_IF_NULL: {
                                    field.setIfNullValue(value);
                                    break;
                                }
                            }
                        }
                        fields.add(field);
                    }
                    continue block31;
                }
                case FILENAME: {
                    this.meta.setFilename(lookValue);
                    break;
                }
                case FILENAME_FIELD: {
                    this.meta.setFilenameField(lookValue);
                    break;
                }
                case ROW_NUMBER_FIELD: {
                    this.meta.setRowNumField(lookValue);
                    break;
                }
                case INCLUDING_FILENAMES: {
                    this.meta.setIncludingFilename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case DELIMITER: {
                    this.meta.setDelimiter(lookValue);
                    break;
                }
                case ENCLOSURE: {
                    this.meta.setEnclosure(lookValue);
                    break;
                }
                case HEADER_PRESENT: {
                    this.meta.setHeaderPresent("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case BUFFER_SIZE: {
                    this.meta.setBufferSize(lookValue);
                    break;
                }
                case LAZY_CONVERSION: {
                    this.meta.setLazyConversionActive("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ADD_FILES_TO_RESULT: {
                    this.meta.setAddResultFile("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case RUN_IN_PARALLEL: {
                    this.meta.setRunningInParallel("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ENCODING: {
                    this.meta.setEncoding(lookValue);
                    break;
                }
            }
        }
        if (fields.size() > 0) {
            this.meta.setInputFields(fields.toArray(new TextFileInputField[fields.size()]));
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public ParGzipCsvInputMeta getMeta() {
        return this.meta;
    }

    private static enum Entry {
        FILENAME(2, "The file name to read"),
        FILENAME_FIELD(2, "The filename field (if the step reads file names)"),
        INCLUDING_FILENAMES(2, "Include file name in output? (Y/N)"),
        ROW_NUMBER_FIELD(2, "The row number field"),
        HEADER_PRESENT(2, "Is there a header row? (Y/N)"),
        DELIMITER(2, "The field delimiter"),
        ENCLOSURE(2, "The field enclosure"),
        BUFFER_SIZE(2, "I/O buffer size"),
        LAZY_CONVERSION(2, "Use lazy conversion? (Y/N)"),
        ADD_FILES_TO_RESULT(2, "Add files to result? (Y/N)"),
        RUN_IN_PARALLEL(2, "Run in parallel? (Y/N)"),
        ENCODING(2, "The file encoding"),
        FIELDS(0, "The fields"),
        FIELD(0, "One field"),
        FIELD_NAME(2, "Name"),
        FIELD_POSITION(2, "Position"),
        FIELD_LENGTH(2, "Length"),
        FIELD_TYPE(2, "Data type (String, Number, ...)"),
        FIELD_IGNORE(2, "Ignore? (Y/N)"),
        FIELD_FORMAT(2, "Format"),
        FIELD_TRIM_TYPE(2, "Trim type (none, left, right, both)"),
        FIELD_PRECISION(2, "Precision"),
        FIELD_DECIMAL(2, "Decimal symbol"),
        FIELD_GROUP(2, "Grouping symbol"),
        FIELD_CURRENCY(2, "Currency symbol"),
        FIELD_REPEAT(2, "Repeat values? (Y/N)"),
        FIELD_NULL_STRING(2, "The null string"),
        FIELD_IF_NULL(2, "The default value if null");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

