/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.main;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.StreamTarget;

public class JForLogConfig {
    private static boolean m_configured;
    private static final Logger m_logger;
    private static final String PROP_PREFIX = "log.priority.";
    private static final DefPrio[] m_defPrio;
    static /* synthetic */ Class class$org$jfor$jfor$main$JForLogConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure() {
        Class clazz = class$org$jfor$jfor$main$JForLogConfig == null ? (class$org$jfor$jfor$main$JForLogConfig = JForLogConfig.class$("org.jfor.jfor.main.JForLogConfig")) : class$org$jfor$jfor$main$JForLogConfig;
        synchronized (clazz) {
            if (m_configured) {
                return;
            }
            if (!JForLogConfig.runningUnderCocoon()) {
                JForLogConfig.defaultToConsole();
                if (!JForLogConfig.configureFromSystemProperties()) {
                    JForLogConfig.configureFromDefaults();
                }
            }
            m_configured = true;
        }
    }

    private static boolean configureFromSystemProperties() {
        boolean bl = false;
        Iterator<Map.Entry<Object, Object>> iterator = System.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            if (!string.startsWith(PROP_PREFIX)) continue;
            bl = true;
            String string2 = ((String)entry.getValue()).toUpperCase();
            String string3 = string.substring(PROP_PREFIX.length());
            Priority priority = Priority.getPriorityForName((String)string2);
            Hierarchy.getDefaultHierarchy().getLoggerFor(string3).setPriority(priority);
            if (!m_logger.isInfoEnabled()) continue;
            m_logger.info("Using configured log priorities: category '" + string3 + "' set to '" + priority + "'");
        }
        return bl;
    }

    private static void configureFromDefaults() {
        int n = 0;
        while (n < m_defPrio.length) {
            Hierarchy.getDefaultHierarchy().getLoggerFor(m_defPrio[n].name).setPriority(m_defPrio[n].p);
            if (m_logger.isInfoEnabled()) {
                m_logger.info("Using default log priorities: category '" + m_defPrio[n].name + "' set to '" + m_defPrio[n].p + "'");
            }
            ++n;
        }
        if (m_logger.isInfoEnabled()) {
            m_logger.info("System properties can be used to set log priorities, using '-Dlog.priority.jfor=DEBUG', for example would activate the DEBUG level for all categories under 'jfor'");
        }
    }

    private static Priority getPriorityForCategory(String string, Priority priority) {
        String string2 = PROP_PREFIX + string;
        Priority priority2 = priority;
        String string3 = System.getProperty(string2);
        if (string3 != null) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug("System property '" + string2 + "' overrides log priority for corresponding category with value '" + string3 + "'");
            }
            priority2 = Priority.getPriorityForName((String)string3);
        }
        return priority2;
    }

    private static boolean runningUnderCocoon() {
        boolean bl = false;
        try {
            Class.forName("org.apache.cocoon.serialization.RTFSerializer");
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (m_logger.isDebugEnabled() && bl) {
            m_logger.debug("Attempt to load class 'org.apache.cocoon.serialization.RTFSerializer'" + (bl ? "successful" : "failed") + ", runningUnderCocoon()=" + bl);
        }
        return bl;
    }

    private static void defaultToConsole() {
        PatternFormatter patternFormatter = new PatternFormatter("[%{category}] {%{priority}} %{message}\n");
        StreamTarget streamTarget = new StreamTarget((OutputStream)System.err, (Formatter)patternFormatter);
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor("jfor");
        logger.setLogTargets(new LogTarget[]{streamTarget});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_logger = Hierarchy.getDefaultHierarchy().getLoggerFor("jfor.logger.config");
        m_defPrio = new DefPrio[]{new DefPrio("jfor", Priority.INFO), new DefPrio("jfor.converter.sax.events", Priority.WARN), new DefPrio("jfor.converter.builder.actions", Priority.WARN)};
    }

    private static class DefPrio {
        private final String name;
        private final Priority p;

        DefPrio(String string, Priority priority) {
            this.name = string;
            this.p = priority;
        }
    }
}

