/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class JavaFileGenerator {
    private final String templateName;
    private final Map options;
    private String currentLine;

    public JavaFileGenerator(String string, Map map) {
        this.templateName = string;
        this.options = map;
    }

    public void generate(PrintWriter printWriter) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(this.templateName);
        if (inputStream == null) {
            throw new IOException("Invalid template name: " + this.templateName);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.process(bufferedReader, printWriter, false);
    }

    private String peekLine(BufferedReader bufferedReader) throws IOException {
        if (this.currentLine == null) {
            this.currentLine = bufferedReader.readLine();
        }
        return this.currentLine;
    }

    private String getLine(BufferedReader bufferedReader) throws IOException {
        String string = this.currentLine;
        this.currentLine = null;
        if (string == null) {
            bufferedReader.readLine();
        }
        return string;
    }

    private boolean evaluate(String string) {
        Object v = this.options.get(string = string.trim());
        if (v == null) {
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            String string2 = ((String)v).trim();
            return string2.length() > 0 && !string2.equalsIgnoreCase("false") && !string2.equalsIgnoreCase("no");
        }
        return false;
    }

    private String substitute(String string) throws IOException {
        int n;
        int n2 = string.indexOf("${");
        if (n2 == -1) {
            return string;
        }
        int n3 = 1;
        for (n = n2 + 2; n < string.length() && n3 > 0; ++n) {
            if (string.charAt(n) == '{') {
                ++n3;
                continue;
            }
            if (string.charAt(n) != '}') continue;
            --n3;
        }
        if (n3 != 0) {
            throw new IOException("Mismatched \"{}\" in template string: " + string);
        }
        String string2 = string.substring(n2 + 2, n - 1);
        String string3 = null;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == ':' && i < string2.length() - 1 && string2.charAt(i + 1) == '-') {
                string3 = this.substituteWithDefault(string2.substring(0, i), string2.substring(i + 2));
                break;
            }
            if (c == '?') {
                string3 = this.substituteWithConditional(string2.substring(0, i), string2.substring(i + 1));
                break;
            }
            if (c == '_' || Character.isJavaIdentifierPart(c)) continue;
            throw new IOException("Invalid variable in " + string);
        }
        if (string3 == null) {
            string3 = this.substituteWithDefault(string2, "");
        }
        return string.substring(0, n2) + string3 + string.substring(n);
    }

    private String substituteWithConditional(String string, String string2) throws IOException {
        int n = string2.indexOf(58);
        if (n == -1) {
            throw new IOException("No ':' separator in " + string2);
        }
        if (this.evaluate(string)) {
            return this.substitute(string2.substring(0, n));
        }
        return this.substitute(string2.substring(n + 1));
    }

    private String substituteWithDefault(String string, String string2) throws IOException {
        Object v = this.options.get(string.trim());
        if (v == null || v.toString().length() == 0) {
            return this.substitute(string2);
        }
        return v.toString();
    }

    private void write(PrintWriter printWriter, String string) throws IOException {
        while (string.indexOf("${") != -1) {
            string = this.substitute(string);
        }
        printWriter.println(string);
    }

    private void process(BufferedReader bufferedReader, PrintWriter printWriter, boolean bl) throws IOException {
        while (this.peekLine(bufferedReader) != null) {
            String string;
            if (this.peekLine(bufferedReader).trim().startsWith("#if")) {
                string = this.getLine(bufferedReader).trim();
                boolean bl2 = this.evaluate(string.substring(3).trim());
                this.process(bufferedReader, printWriter, bl || !bl2);
                if (this.peekLine(bufferedReader) != null && this.peekLine(bufferedReader).trim().startsWith("#else")) {
                    this.getLine(bufferedReader);
                    this.process(bufferedReader, printWriter, bl || bl2);
                }
                if ((string = this.getLine(bufferedReader)) == null) {
                    throw new IOException("Missing \"#fi\"");
                }
                if (string.trim().startsWith("#fi")) continue;
                throw new IOException("Expected \"#fi\", got: " + string);
            }
            if (this.peekLine(bufferedReader).trim().startsWith("#")) break;
            string = this.getLine(bufferedReader);
            if (bl) continue;
            this.write(printWriter, string);
        }
        printWriter.flush();
    }

    public static void main(String[] stringArray) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("falseArg", Boolean.FALSE);
        hashMap.put("trueArg", Boolean.TRUE);
        hashMap.put("stringValue", "someString");
        new JavaFileGenerator(stringArray[0], hashMap).generate(new PrintWriter(stringArray[1]));
    }
}

