/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class XlsxFontInfo {
    protected String fontName;
    protected float fontSize;
    protected boolean isBold;
    protected boolean isItalic;
    protected boolean isUnderline;
    protected boolean isStrikeThrough;
    protected String color;

    public XlsxFontInfo(JRPrintElement element, String fontName, boolean isFontSizeFixEnabled) {
        JRFont font;
        if (element != null) {
            this.color = JRColorUtil.getColorHexa(element.getForecolor());
        }
        JRFont jRFont = font = element instanceof JRFont ? (JRFont)((Object)element) : null;
        if (font != null) {
            this.fontName = fontName;
            this.fontSize = font.getFontsize() + (float)(isFontSizeFixEnabled ? -1 : 0);
            this.isBold = font.isBold();
            this.isItalic = font.isItalic();
            this.isUnderline = font.isUnderline();
            this.isStrikeThrough = font.isStrikeThrough();
        }
    }

    public int hashCode() {
        int hash = 47 + ObjectUtils.hashCode(this.fontName);
        hash = 29 * hash + Float.hashCode(this.fontSize);
        hash = 29 * hash + Boolean.hashCode(this.isBold);
        hash = 29 * hash + Boolean.hashCode(this.isItalic);
        hash = 29 * hash + Boolean.hashCode(this.isUnderline);
        hash = 29 * hash + Boolean.hashCode(this.isStrikeThrough);
        hash = 29 * hash + ObjectUtils.hashCode(this.color);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XlsxFontInfo)) {
            return false;
        }
        XlsxFontInfo info = (XlsxFontInfo)obj;
        return ObjectUtils.equals(this.fontName, info.fontName) && ObjectUtils.equals(this.fontSize, info.fontSize) && this.isBold == info.isBold && this.isItalic == info.isItalic && this.isUnderline == info.isUnderline && this.isStrikeThrough == info.isStrikeThrough && ObjectUtils.equals(this.color, info.color);
    }
}

