/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Binary;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.JavaObject;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rowio.RowOutputBase;

public class RowOutputLegacy
extends RowOutputBase {
    int storageSize;
    DataOutputStream dout = new DataOutputStream(this);

    public void writeIntData(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeIntData(int n, int n2) throws IOException {
        int n3 = this.count;
        this.count = n2;
        this.writeInt(n);
        if (this.count < n3) {
            this.count = n3;
        }
    }

    public void writePos(int n) throws IOException {
        this.writeInt(n);
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    public void writeSize(int n) throws IOException {
        this.storageSize = n;
        this.writeInt(n);
    }

    public void writeType(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeString(String string) throws IOException {
        this.dout.writeUTF(string);
    }

    protected void writeFieldType(int n) throws IOException {
        this.writeInt(n);
    }

    protected void writeNull(int n) throws IOException {
        this.writeType(0);
    }

    protected void writeChar(String string, int n) throws IOException {
        this.dout.writeUTF(string);
    }

    protected void writeSmallint(Number number) throws IOException, HsqlException {
        this.writeString(number.toString());
    }

    protected void writeInteger(Number number) throws IOException, HsqlException {
        this.writeInt(number.intValue());
    }

    protected void writeBigint(Number number) throws IOException, HsqlException {
        this.writeString(number.toString());
    }

    protected void writeReal(Double d, int n) throws IOException, HsqlException {
        if (n == 7) {
            this.writeString(d.toString());
        } else {
            this.writeLong(Double.doubleToLongBits(d));
        }
    }

    protected void writeDecimal(BigDecimal bigDecimal) throws IOException, HsqlException {
        this.writeString(bigDecimal.toString());
    }

    protected void writeBit(Boolean bl) throws IOException, HsqlException {
        this.writeString(bl.toString());
    }

    protected void writeDate(Date date) throws IOException, HsqlException {
        this.writeString(date.toString());
    }

    protected void writeTime(Time time) throws IOException, HsqlException {
        this.writeString(time.toString());
    }

    protected void writeTimestamp(Timestamp timestamp) throws IOException, HsqlException {
        this.writeString(timestamp.toString());
    }

    protected void writeOther(JavaObject javaObject) throws IOException, HsqlException {
        byte[] byArray = javaObject.getBytes();
        this.writeByteArray(byArray);
    }

    protected void writeBinary(Binary binary, int n) throws IOException, HsqlException {
        this.writeByteArray(binary.getBytes());
    }

    protected void writeByteArray(byte[] byArray) throws IOException {
        this.writeString("**");
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public int getSize(CachedRow cachedRow) throws HsqlException {
        Object[] objectArray = cachedRow.getData();
        int[] nArray = cachedRow.getTable().getColumnTypes();
        return RowOutputLegacy.getSize(objectArray, objectArray.length, nArray);
    }

    private static int getSize(Object[] objectArray, int n, int[] nArray) throws HsqlException {
        int n2 = 0;
        block6: for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            n2 += 4;
            if (object == null) continue;
            switch (nArray[i]) {
                case 4: {
                    n2 += 4;
                    continue block6;
                }
                case 6: 
                case 8: {
                    n2 += 8;
                    continue block6;
                }
                case -4: 
                case -3: 
                case -2: {
                    n2 += 2;
                    n2 += 4;
                    n2 += ((Binary)object).getBytesLength();
                    continue block6;
                }
                case 1111: {
                    n2 += 2;
                    n2 += 4;
                    n2 += ((JavaObject)object).getBytesLength();
                    continue block6;
                }
                default: {
                    n2 += 2;
                    n2 += StringConverter.getUTFSize(object.toString());
                }
            }
        }
        return n2;
    }
}

