/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.net.LDAPClient;
import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.PropUtil;
import de.his.tools.StringUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class LdapAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(LdapAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        boolean ok = true;
        LDAPClient ldapClient = null;
        Iterator itr = confElement.getChildren().iterator();
        Properties replaceProp = (Properties)authProp.clone();
        while (itr.hasNext()) {
            replaceProp.putAll((Map<?, ?>)userProp);
            replaceProp = PropUtil.encodeURL(replaceProp);
            Element element = (Element)itr.next();
            String action = element.getName();
            if (action.equals("break") || action.equals("continue") || action.equals("test")) continue;
            if (action.equals("connect")) {
                String message;
                boolean passwordEmpty;
                String passwordConf = element.getChildText("password");
                if (passwordConf != null && (passwordEmpty = authProp.getProperty("password", "").trim().equals("")) && passwordConf.indexOf("[") > -1) {
                    logger.debug((Object)"Passwort ist leer");
                    return userProp;
                }
                if (ldapClient != null) {
                    ldapClient.close();
                }
                if ((message = (ldapClient = this.doConnect(element, replaceProp)).getLastError()) == null && element.getChildText("username") != null) {
                    userProp.putAll((Map<?, ?>)ldapClient.getAttributes(StringUtil.argsubst(element.getChildText("username"), replaceProp), element.getChildText("attributes")));
                    message = ldapClient.getLastError();
                }
                if (message != null) {
                    message = LDAPClient.extractLDAPErrorMessage(message);
                    String prefix = confElement.getAttributeValue("name");
                    if (prefix == null || prefix.trim().equals("")) {
                        prefix = confElement.getName();
                    }
                    PropUtil.putIgnoreNull(userProp, prefix + "_errormessage", message);
                    ok = false;
                }
            } else if (action.equals("lookup")) {
                Properties temp = this.doLookup(ldapClient, element, replaceProp);
                if (temp != null) {
                    userProp.putAll((Map<?, ?>)temp);
                } else {
                    ok = false;
                }
            } else if (action.equals("find")) {
                String dn = this.doFind(ldapClient, element, replaceProp);
                if (dn != null) {
                    userProp.setProperty("dn", dn);
                } else {
                    ok = false;
                }
            } else {
                logger.warn((Object)("Unbekanntes Kindelement \"" + element.getName() + "\" wird ignoriert."));
                ok = false;
            }
            if (ok) continue;
            break;
        }
        if (ldapClient != null) {
            ldapClient.close();
        }
        if (ok) {
            userProp.put("authenticated", "y");
        }
        logger.debug((Object)("userProp=" + userProp));
        return userProp;
    }

    public LDAPClient doConnect(Element element, Properties replaceProp) {
        logger.debug((Object)"Connecting to ldap-server");
        Properties connectionProp = PropUtil.argsubst(PropUtil.xmlToProperties(element), replaceProp);
        connectionProp.put("IGNORE_ERRORS", "y");
        return new LDAPClient(connectionProp);
    }

    private Properties doLookup(LDAPClient ldapClient, Element element, Properties replaceProp) {
        Properties res = null;
        String lookup = element.getText();
        logger.debug((Object)("Lookup: " + lookup));
        if (ldapClient == null) {
            logger.info((Object)("lookup (" + lookup + ") konnte nicht durchgefuehrt, da keine Verbindung zu einem LDAP-Server besteht."));
            return null;
        }
        res = ldapClient.getAttributes(StringUtil.argsubst(lookup, replaceProp));
        if (ldapClient.getLastError() != null) {
            logger.info((Object)("Fehler beim lookup (" + lookup + "): " + ldapClient.getLastError()));
            return null;
        }
        return res;
    }

    private String doFind(LDAPClient ldapClient, Element element, Properties replaceProp) {
        logger.debug((Object)"find");
        if (ldapClient == null) {
            logger.info((Object)"find konnte nicht durchgefuehrt, da keine Verbindung zu einem LDAP-Server besteht.");
            return null;
        }
        return ldapClient.find(StringUtil.argsubst(element.getChildText("base"), replaceProp), element.getChildText("filter"), replaceProp, element.getChildText("attributes"), element.getChildText("scope"));
    }
}

