/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth;

import de.his.security.auth.AuthenticationManager;
import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.DefaultAuthenticationManagerConfig;
import de.his.tools.PropUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class BasicAuthenticationFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(BasicAuthenticationFilter.class);
    private AuthenticationManagerConfig config = null;

    public void destroy() {
        this.config = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean authorized = false;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        logger.debug((Object)"--------- HTTP-HEADER -----------");
        Enumeration names = httpRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            logger.debug((Object)(name + " = " + httpRequest.getHeader(name)));
        }
        logger.debug((Object)"--------- HTTP-HEADER -----------");
        HttpSession session = httpRequest.getSession(false);
        if (session == null || session.getAttribute("user") == null) {
            if (session == null) {
                logger.debug((Object)"session is null");
            } else {
                Object userAttribute = session.getAttribute("user");
                if (userAttribute == null || userAttribute.equals("")) {
                    logger.debug((Object)"session attribute <user> not set");
                }
            }
            String auth = httpRequest.getHeader("Authorization");
            logger.debug((Object)("auth: " + auth));
            if (auth != null && auth.trim().length() > 0) {
                session = httpRequest.getSession(true);
                auth = auth.trim();
                String toDecode = auth.substring(auth.lastIndexOf(" ") + 1);
                logger.debug((Object)("toDecode: " + toDecode));
                String[] userUndPass = new String(Base64.decodeBase64((byte[])toDecode.getBytes())).split(":");
                logger.debug((Object)("userUndPass.length: " + userUndPass.length));
                for (int i = 0; i < userUndPass.length; ++i) {
                    logger.debug((Object)("userUndPass[" + i + "]: " + userUndPass[i]));
                }
                authorized = this.isAuthorized(userUndPass, httpRequest, session);
                logger.debug((Object)("authorized: " + authorized));
            }
        } else {
            logger.debug((Object)("SessionId: " + session.getId()));
            authorized = true;
        }
        if (authorized) {
            chain.doFilter(request, response);
        } else {
            logger.debug((Object)"Authentication failure");
            if (session != null) {
                session.invalidate();
            }
            this.sendUnauthorized(httpResponse);
        }
    }

    private boolean isAuthorized(String[] loginInfo, HttpServletRequest request, HttpSession session) {
        String[] propNames = new String[]{"username", "password"};
        Properties authProp = new Properties();
        AuthenticationManager authenticationManager = AuthenticationManager.getManager();
        if (!authenticationManager.isInited()) {
            authenticationManager.init(this.config);
        }
        for (int i = 0; i < loginInfo.length; ++i) {
            authProp.setProperty(propNames[i], loginInfo[i]);
        }
        Properties userProp = authenticationManager.getLoginData(authProp, request);
        PropUtil.printProperties("userProp", userProp);
        if (loginInfo.length > 0) {
            session.setAttribute("user", (Object)loginInfo[0]);
        }
        return userProp.getProperty("userID") != null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String confDir = filterConfig.getInitParameter("confDir");
        this.config = new DefaultAuthenticationManagerConfig(filterConfig.getServletContext().getRealPath("/") + confDir);
    }

    public void setConfig(AuthenticationManagerConfig config) {
        this.config = config;
    }

    private void sendUnauthorized(HttpServletResponse response) {
        if (!response.isCommitted()) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"Secure Area\"");
            try {
                response.sendError(401, "Unauthorized");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

