/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.FieldValue;
import org.dbforms.taglib.DbBaseHandlerFactory;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.taglib.DbFilterConditionTag;
import org.dbforms.taglib.DbNavReloadButtonTag;
import org.dbforms.util.MessageResources;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.Util;

public class DbFilterTag
extends DbBaseHandlerTag
implements TryCatchFinally {
    protected static final String FLT_COND = "_cond_";
    protected static final String FLT_PREFIX = "filter_";
    protected static final String FLT_SEL = "_sel";
    protected static final String FLT_SET = "_set";
    protected static final String FLT_VALUE = "_value_";
    protected static final String FLT_VALUETYPE = "_valuetype_";
    protected static final String FLT_SEARCHALGO = "_searchalgo_";
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$taglib$DbFilterTag == null ? (class$org$dbforms$taglib$DbFilterTag = DbFilterTag.class$("org.dbforms.taglib.DbFilterTag")) : class$org$dbforms$taglib$DbFilterTag).getName());
    private ArrayList conds;
    private String disabledCaption;
    private String filterName;
    private String setCaption;
    private String size;
    private String unsetCaption;
    static /* synthetic */ Class class$org$dbforms$taglib$DbFilterTag;
    static /* synthetic */ Class class$org$dbforms$taglib$DbNavReloadButtonTag;

    public static String getSqlFilter(HttpServletRequest request, int tableId) {
        int conditionId = DbFilterTag.getCurrentCondition(request, tableId);
        if (conditionId > -1) {
            return DbFilterConditionTag.getSqlFilter(request, tableId, conditionId);
        }
        return null;
    }

    public static FieldValue[] getSqlFilterParams(HttpServletRequest request, int tableId) {
        int conditionId = DbFilterTag.getCurrentCondition(request, tableId);
        if (conditionId > -1) {
            return DbFilterConditionTag.getSqlFilterParams(request, tableId, conditionId);
        }
        return null;
    }

    public void setDisabledCaption(String string) {
        this.disabledCaption = string;
    }

    public void setSetCaption(String string) {
        this.setCaption = string;
    }

    public void setSize(String string) {
        this.size = string;
    }

    public void setUnsetCaption(String string) {
        this.unsetCaption = string;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        int currentCondId = DbFilterTag.getCurrentCondition((HttpServletRequest)this.pageContext.getRequest(), this.getTableId());
        DbFilterConditionTag currentCond = null;
        if (currentCondId > -1) {
            currentCond = new DbFilterConditionTag();
            currentCond.setState(this.pageContext, this, (DbFilterConditionTag.State)this.conds.get(currentCondId));
        }
        StringBuffer buf = this.render(currentCond);
        try {
            if (this.bodyContent != null) {
                this.bodyContent.clearBody();
            }
            JspWriter out = this.pageContext.getOut();
            out.write(buf.toString());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 0;
    }

    public void doFinally() {
        this.conds = null;
        this.disabledCaption = null;
        this.filterName = null;
        this.setCaption = null;
        this.size = null;
        this.unsetCaption = null;
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        this.init();
        return 1;
    }

    protected static String getFilterName(int tableId) {
        return FLT_PREFIX + tableId;
    }

    protected String getFilterName() {
        return this.filterName;
    }

    protected int getTableId() {
        return this.getParentForm().getTable().getId();
    }

    protected int addCondition(DbFilterConditionTag condition) {
        this.conds.add(condition.getState());
        return this.conds.size() - 1;
    }

    private static int getCurrentCondition(HttpServletRequest request, int tableId) {
        int curCondId = -1;
        String param = ParseUtil.getParameter(request, DbFilterTag.getFilterName(tableId) + FLT_SEL);
        if (!Util.isNull(param)) {
            try {
                curCondId = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                logCat.error((Object)"getCurrentCondition", (Throwable)e);
            }
        }
        logCat.debug((Object)("setting current filter: " + curCondId));
        return curCondId;
    }

    private void init() {
        this.conds = new ArrayList();
        this.filterName = DbFilterTag.getFilterName(this.getTableId());
        if (this.size == null) {
            this.size = "1";
        }
        if (this.disabledCaption == null) {
            this.disabledCaption = "";
        }
        if (this.setCaption == null) {
            this.setCaption = "set";
        }
        if (this.unsetCaption == null) {
            this.unsetCaption = "unset";
        }
    }

    private StringBuffer render(DbFilterConditionTag currentCond) throws JspException {
        StringBuffer buf = new StringBuffer();
        buf.append("\n<select name=\"" + this.filterName + FLT_SEL + "\" class=\"" + this.getStyleClass() + "\" size=\"" + this.size + "\" onchange=\"document.dbform.submit()\" >\n");
        int cnt = 0;
        buf.append("\t<option value=\"-1\" >" + this.disabledCaption + "</option>\n");
        DbFilterConditionTag cond = new DbFilterConditionTag();
        Locale locale = MessageResources.getLocale((HttpServletRequest)this.pageContext.getRequest());
        Iterator i = this.conds.iterator();
        while (i.hasNext()) {
            cond.setState(this.pageContext, this, (DbFilterConditionTag.State)i.next());
            String selected = currentCond != null && currentCond.equals((Object)cond) ? "selected" : "";
            String label = cond.getLabel();
            if (label != null && this.getParentForm().hasCaptionResourceSet()) {
                try {
                    String message = MessageResources.getMessage(label, locale);
                    if (message != null) {
                        label = message;
                    }
                }
                catch (Exception e) {
                    logCat.debug((Object)("setCaption(" + label + ") Exception : " + e.getMessage()));
                }
            }
            buf.append("\t<option value=\"" + cnt + "\" " + selected + ">" + label + "</option>\n");
            ++cnt;
        }
        buf.append("</select>\n");
        if (currentCond != null) {
            DbBaseHandlerFactory btn;
            buf.append(currentCond.render());
            if (!Util.isNull(this.setCaption)) {
                btn = new DbBaseHandlerFactory(this.pageContext, this, class$org$dbforms$taglib$DbNavReloadButtonTag == null ? (class$org$dbforms$taglib$DbNavReloadButtonTag = DbFilterTag.class$("org.dbforms.taglib.DbNavReloadButtonTag")) : class$org$dbforms$taglib$DbNavReloadButtonTag);
                ((DbNavReloadButtonTag)btn.getTag()).setCaption(this.setCaption);
                ((DbNavReloadButtonTag)btn.getTag()).setForceReload("true");
                buf.append(btn.render());
            }
            if (!Util.isNull(this.unsetCaption)) {
                btn = new DbBaseHandlerFactory(this.pageContext, this, class$org$dbforms$taglib$DbNavReloadButtonTag == null ? (class$org$dbforms$taglib$DbNavReloadButtonTag = DbFilterTag.class$("org.dbforms.taglib.DbNavReloadButtonTag")) : class$org$dbforms$taglib$DbNavReloadButtonTag);
                ((DbNavReloadButtonTag)btn.getTag()).setCaption(this.unsetCaption);
                ((DbNavReloadButtonTag)btn.getTag()).setOnClick("document.dbform." + this.filterName + FLT_SEL + ".selectedIndex = -1;");
                ((DbNavReloadButtonTag)btn.getTag()).setForceReload("true");
                buf.append(btn.render());
            }
        }
        return buf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

