/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatMlRawVersion
implements Comparable {
    private static final String DATML_RAW_VERSION_REGEX = "\\d{1,2}\\.\\d{1,2}";
    private static final Pattern DATML_RAW_VERSION_PATTERN = Pattern.compile("\\d{1,2}\\.\\d{1,2}");
    private String datMlRawVersion;
    private int versionNumber;

    public DatMlRawVersion(String datMlRawVersion) {
        if (!DatMlRawVersion.isValidPrettyDatMlRawVersion(datMlRawVersion)) {
            throw new IllegalArgumentException("Ung\u00fcltige DatML/RAW-Version: " + datMlRawVersion + ".");
        }
        this.datMlRawVersion = datMlRawVersion;
        String resIdFormat = DatMlRawVersion.getDatMlRawVersionFromPrettyDatMlRawVersion(this.datMlRawVersion);
        this.versionNumber = Integer.parseInt(resIdFormat);
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && DatMlRawVersion.class.equals(obj.getClass())) {
            DatMlRawVersion other = (DatMlRawVersion)obj;
            equal = this.versionNumber == other.versionNumber;
        }
        return equal;
    }

    public String getDatMlRawVersion() {
        return this.datMlRawVersion;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public String toString() {
        return this.datMlRawVersion;
    }

    public int compareTo(Object o) {
        DatMlRawVersion other = (DatMlRawVersion)o;
        int otherVersionNumber = other.versionNumber;
        int result = this.versionNumber == otherVersionNumber ? 0 : (this.versionNumber > otherVersionNumber ? 1 : -1);
        return result;
    }

    public int hashCode() {
        return this.versionNumber;
    }

    public static boolean isValidPrettyDatMlRawVersion(String check) {
        Matcher m;
        boolean ok = false;
        if (check != null && (m = DATML_RAW_VERSION_PATTERN.matcher(check)).matches()) {
            ok = true;
        }
        return ok;
    }

    public static String getPrettyDatMlRawVersionFromDatMlRawVerson(String datMlRawVersion) {
        String mainVersion = datMlRawVersion.substring(0, 2);
        String subVersion = datMlRawVersion.substring(2, 4);
        StringBuffer prettyVersion = new StringBuffer(5);
        prettyVersion.append(Integer.parseInt(mainVersion));
        prettyVersion.append(".");
        prettyVersion.append(Integer.parseInt(subVersion));
        return prettyVersion.toString();
    }

    public static String getDatMlRawVersionFromPrettyDatMlRawVersion(String prettyDatMlRawVersion) {
        if (!DatMlRawVersion.isValidPrettyDatMlRawVersion(prettyDatMlRawVersion)) {
            throw new IllegalArgumentException("Ung\u00fcltige DatML/RAW-Version: '" + prettyDatMlRawVersion + "'.");
        }
        int firstDotIdx = prettyDatMlRawVersion.indexOf(46);
        String mainVersion = prettyDatMlRawVersion.substring(0, firstDotIdx);
        String subVersion = prettyDatMlRawVersion.substring(firstDotIdx + 1);
        StringBuffer result = new StringBuffer();
        if (mainVersion.length() < 2) {
            result.append("0");
        }
        result.append(mainVersion);
        if (subVersion.length() < 2) {
            result.append("0");
        }
        result.append(subVersion);
        return result.toString();
    }
}

