/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource;

import de.destatis.core.resource.SurveyDbResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public abstract class Resource
implements SurveyDbResource {
    private String resourceId;
    private byte[] resourceData;

    public Resource(String resourceId, byte[] resourceData) {
        this.resourceId = resourceId;
        this.resourceData = resourceData;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    public Reader getReader() {
        InputStreamReader reader = null;
        String encoding = this.getEncoding();
        if (encoding == null) {
            reader = new InputStreamReader(this.getInputStream());
        } else {
            try {
                reader = new InputStreamReader(this.getInputStream(), encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return reader;
    }

    protected abstract String getEncoding();

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.resourceData);
    }
}

