/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class HelpFeatureConfigValue {
    private static List ALL_VALUES = new Vector();
    private static Map VALUES_BY_ID = Collections.synchronizedMap(new HashMap());
    private static final Short SEPARATE_ROW_ID = new Short(1);
    private static final Short EACH_RECORD_ID = new Short(2);
    private static final Short DEFAULT_VALUES_ID = new Short(3);
    private static final String SEPARATE_ROW_TEXT = "Angaben stehen einmalig in einer separaten, vorangestellten Zeile";
    private static final String EACH_RECORD_TEXT = "Angaben stehen in den daf\u00fcr vorgesehenen Positionen der einzelnen S\u00e4tze";
    private static final String DEFAULT_VALUES_TEXT = "Angaben werden \u00fcber Vorbelegung erzeugt";
    public static HelpFeatureConfigValue SEPARATE_ROW = new HelpFeatureConfigValue(SEPARATE_ROW_ID, "Angaben stehen einmalig in einer separaten, vorangestellten Zeile");
    public static HelpFeatureConfigValue EACH_RECORD = new HelpFeatureConfigValue(EACH_RECORD_ID, "Angaben stehen in den daf\u00fcr vorgesehenen Positionen der einzelnen S\u00e4tze");
    public static HelpFeatureConfigValue DEFAULT_VALUES = new HelpFeatureConfigValue(DEFAULT_VALUES_ID, "Angaben werden \u00fcber Vorbelegung erzeugt");
    private static HelpFeatureConfigValue DEFAULT_VALUE = SEPARATE_ROW;
    private Short id;
    private String description;

    private HelpFeatureConfigValue(Short id, String description) {
        this.id = id;
        this.description = description;
        ALL_VALUES.add(this);
        VALUES_BY_ID.put(id, this);
    }

    public short getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && HelpFeatureConfigValue.class.equals(obj.getClass()) && this.getId() == ((HelpFeatureConfigValue)obj).getId()) {
            equal = true;
        }
        return equal;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.description;
    }

    public boolean isSeparateRow() {
        return SEPARATE_ROW == this;
    }

    public boolean isEachRecord() {
        return EACH_RECORD == this;
    }

    public boolean isDefaultValue() {
        return DEFAULT_VALUES == this;
    }

    public static HelpFeatureConfigValue getDefaultValue() {
        return DEFAULT_VALUE;
    }

    public static HelpFeatureConfigValue[] getAllValues() {
        return ALL_VALUES.toArray(new HelpFeatureConfigValue[ALL_VALUES.size()]);
    }

    public static HelpFeatureConfigValue getValueById(short id) {
        HelpFeatureConfigValue value = (HelpFeatureConfigValue)VALUES_BY_ID.get(new Short(id));
        if (value == null) {
            throw new IllegalArgumentException("Ung\u00fcltiger Wert '" + id + "' f\u00fcr Hilfsmerkmalkonfiguration.");
        }
        return value;
    }
}

