/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.model;

import de.destatis.core.map.Binding;
import de.destatis.core.map.BindingGroup;
import javax.swing.Icon;

public abstract class BindingImpl
implements Binding {
    private String id;
    private BindingGroup parent;
    private Icon icon;
    private int pathLength = -1;

    protected BindingImpl(String id) {
        this.id = id;
        this.parent = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPrettyName() {
        return this.getId();
    }

    @Override
    public BindingGroup getParent() {
        return this.parent;
    }

    @Override
    public void setParent(BindingGroup parent) {
        this.parent = parent;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public Binding[] getPath() {
        int pathLength = this.getPathLength();
        Binding[] result = new Binding[pathLength];
        int index = pathLength - 1;
        result[index] = this;
        BindingGroup parent = this.getParent();
        if (parent != null) {
            do {
                result[--index] = parent;
            } while ((parent = parent.getParent()) != null);
        }
        return result;
    }

    @Override
    public int getPathLength() {
        if (this.pathLength <= 0) {
            int length = 1;
            for (BindingGroup parent = this.getParent(); parent != null; parent = parent.getParent()) {
                ++length;
            }
            this.pathLength = length;
        }
        return this.pathLength;
    }
}

