/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.document;

import de.destatis.core.connect.document.DocumentSource;
import de.destatis.core.connect.document.ValidationException;
import de.destatis.core.connect.document.XMLDocument;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class DatMLRawDocument
extends XMLDocument {
    private static final String ROOT_ELEMENT = "DatML-RAW-D";
    private static final String VERSION_1_0 = "1.0";
    private static final String XMLNS_URI = "http://www.destatis.de/schema/datml-raw/";

    public DatMLRawDocument() {
    }

    public DatMLRawDocument(DatMLRawDocument source) {
        super(source);
    }

    public void setDocument(DocumentSource source) throws ValidationException {
        this.setContent(source);
    }

    @Override
    public void setDocument(String source) throws ValidationException {
        this.setContent(source);
    }

    @Override
    public void setDocument(Source source) throws TransformerException, ValidationException {
        this.setContent(source);
    }

    @Override
    public void setDocument(Source source, Source stylesheet) throws TransformerException, ValidationException {
        this.setContent(source, stylesheet);
    }

    @Override
    public String getDocument() {
        return this.getContent();
    }

    @Override
    public void getDocument(Result result) throws TransformerException {
        this.getContent(result);
    }

    @Override
    public void getDocument(Source stylesheet, Result result) throws TransformerException {
        this.getContent(stylesheet, result);
    }

    @Override
    protected String getRootElement() {
        return ROOT_ELEMENT;
    }

    @Override
    protected void validateRootElement(Attributes attributes) throws ValidationException {
        String message = null;
        String version = attributes.getValue("version");
        if (version == null) {
            message = "Keine Versionsangabe enthalten";
        } else {
            String xmlns = attributes.getValue("xmlns");
            if (xmlns == null) {
                if (!VERSION_1_0.equals(version)) {
                    message = "Kein Namensraum angegeben";
                }
            } else if (!xmlns.startsWith(XMLNS_URI)) {
                message = "Falscher Namensraum enthalten: " + xmlns;
            }
        }
        if (message != null) {
            throw new ValidationException(message);
        }
    }
}

