/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.document;

import de.destatis.core.connect.document.DocumentSource;
import de.destatis.core.connect.document.util.ReadXmlEncodingParser;
import de.destatis.core.connect.util.Contract;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ByteDocumentSource
implements DocumentSource {
    private byte[] content;
    private String charset;

    protected ByteDocumentSource(byte[] content) {
        Contract.verify(content != null, "content ist erforderlich");
        ReadXmlEncodingParser parser = new ReadXmlEncodingParser();
        try {
            String charset = parser.getEncoding(new ByteArrayInputStream(content));
            if (charset == null) {
                throw new IllegalArgumentException("Der Zeichensatz des XML-Dokuments konnte nicht ermittelt werden.");
            }
            this.charset = charset;
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalArgumentException("Ung\u00fcltiges XML-Dokument: " + e.getMessage() + ".");
        }
        this.content = content;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public String getEncoding() {
        return this.charset;
    }

    @Override
    public long getLength() {
        return this.content.length;
    }

    @Override
    public String getContent() {
        try {
            return new String(this.content, this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void release() {
        this.content = null;
    }
}

