/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.CheckDeliveryRequest;
import de.destatis.core.connect.ClientAuthenticator;
import de.destatis.core.connect.ClientStatusEvent;
import de.destatis.core.connect.ClientStatusListener;
import de.destatis.core.connect.DataDelivery;
import de.destatis.core.connect.GetCommonResourceRequest;
import de.destatis.core.connect.GetSurveyResourceRequest;
import de.destatis.core.connect.GetSurveysRequest;
import de.destatis.core.connect.IncompleteRequestException;
import de.destatis.core.connect.PingRequest;
import de.destatis.core.connect.ProtocolRequest;
import de.destatis.core.connect.Request;
import de.destatis.core.connect.Response;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.ResponseToCheckDeliveryRequest;
import de.destatis.core.connect.ResponseToDataDelivery;
import de.destatis.core.connect.ResponseToGetCommonResourceRequest;
import de.destatis.core.connect.ResponseToGetResourceRequest;
import de.destatis.core.connect.ResponseToGetSurveysRequest;
import de.destatis.core.connect.ResponseToPingRequest;
import de.destatis.core.connect.ResponseToProtocolRequest;
import de.destatis.core.connect.ServerAddress;
import de.destatis.core.connect.TransferProtocol;
import de.destatis.core.connect.TransferProtocolException;
import de.destatis.core.connect.UnsupportedProtocolException;
import de.destatis.core.connect.UserPasswordAuthenticator;
import de.destatis.core.connect.document.DatMLRawDocument;
import de.destatis.core.connect.document.DocumentSourceFactory;
import de.destatis.core.connect.transfer.ProtocolHandlerBase;
import de.destatis.core.connect.transfer.ProtocolHandlerFactory;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import de.destatis.core.connect.util.Contract;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public final class Client {
    public static final String PROPERTY_LOG_LEVEL = "client.log.level";
    public static final String PROPERTY_LOG_FILE = "client.log.file";
    public static final String PROPERTY_CERTIFICATE_DIR = "client.certificate.dir";
    public static final String PROPERTY_USERNAME = "client.username";
    public static final String PROPERTY_PASSWORD = "client.password";
    public static final String PROPERTY_PROTOCOL = "client.protocol";
    public static final String PROPERTY_COMPRESSION = "client.compression";
    public static final String PROPERTY_ADDRESS_PRESELECTION = "client.address.preselection";
    public static final String PROPERTY_ADDRESS_USE_URI = "client.address.useURI";
    public static final String PROPERTY_PROXY_HOST = "client.proxy.host";
    public static final String PROPERTY_PROXY_PORT = "client.proxy.port";
    public static final String PROPERTY_PROXY_USER = "client.proxy.user";
    public static final String PROPERTY_PROXY_PASSWORD = "client.proxy.password";
    public static final String PROPERTY_PROXY_DOMAIN = "client.proxy.domain";
    public static final String PROPERTY_PROXY_AUTH_METHOD = "client.proxy.authmethod";
    private static ClientLogger LOG = null;
    private static final String CONNECT_VERSION;
    private static final String CONNECT_VENDOR = "DESTATIS";
    private static final String CONNECT_VENDOR_ID = "ZV";
    private ClientConfig config = null;
    private ClientAuthenticator authenticator = null;
    private ProtocolHandlerBase protocolHandler = null;

    public Client(String userName, char[] password) {
        this(new UserPasswordAuthenticator(userName, password));
    }

    public Client(String userName, char[] password, Properties conf) {
        this(new UserPasswordAuthenticator(userName, password), conf);
    }

    public Client(ClientAuthenticator authenticator) {
        this.init(authenticator, new ClientConfig());
    }

    public Client(ClientAuthenticator authenticator, Properties conf) {
        this.init(authenticator, new ClientConfig(conf));
    }

    public Client(Properties conf) {
        this(new UserPasswordAuthenticator(conf), conf);
    }

    public String getVersion() {
        return CONNECT_VERSION;
    }

    public String getVendor() {
        return CONNECT_VENDOR;
    }

    public String getVendorID() {
        return CONNECT_VENDOR_ID;
    }

    public ClientAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public Properties getConfiguration() {
        return this.config.getProperties();
    }

    public ServerAddress getCoreServerAddress() {
        return this.config.getAddressPreselection();
    }

    public ResponseToDataDelivery send(DataDelivery req) throws IncompleteRequestException, UnsupportedProtocolException, TransferProtocolException {
        return this.send(req, this.config.getAddressPreselection());
    }

    public ResponseToDataDelivery send(DataDelivery req, ServerAddress to) throws IncompleteRequestException, UnsupportedProtocolException, TransferProtocolException {
        LOG.debug("enter send(DataDelivery, ServerAddress)");
        LOG.info("Sende Datenlieferung an Server " + to);
        this.validateRequest(req, to);
        ResponseToDataDelivery response = this.protocolHandler.send(this.authenticator, req, to);
        return response;
    }

    public ResponseToProtocolRequest send(ProtocolRequest req) throws IncompleteRequestException, UnsupportedProtocolException, TransferProtocolException {
        return this.send(req, this.config.getAddressPreselection());
    }

    public ResponseToProtocolRequest send(ProtocolRequest req, ServerAddress to) throws IncompleteRequestException, UnsupportedProtocolException, TransferProtocolException {
        LOG.debug("enter send(ProtocolRequest, ServerAddress)");
        LOG.info("Sende Protokollanfrage an Server " + to);
        this.validateRequest(req, to);
        ResponseToProtocolRequest response = this.protocolHandler.send(this.authenticator, req, to);
        return response;
    }

    public ResponseToGetSurveysRequest send(GetSurveysRequest req) throws IncompleteRequestException, UnsupportedProtocolException, TransferProtocolException {
        ServerAddress to = this.config.getAddressPreselection();
        LOG.debug("enter send(GetSurveysRequest, ServerAddress)");
        LOG.info("Sende Liste der freigegebenen Erhebungen Anfrage an Server " + to);
        this.validateRequest(req, to);
        ResponseToGetSurveysRequest response = this.protocolHandler.send(this.authenticator, req, to);
        return response;
    }

    public ResponseToGetResourceRequest send(GetSurveyResourceRequest req) throws IncompleteRequestException, UnsupportedProtocolException, TransferProtocolException {
        ServerAddress to = this.config.getAddressPreselection();
        LOG.debug("enter send(GetSurveyResourceRequest, ServerAddress)");
        LOG.info("Sende Ressource-Anfrage an Server " + to);
        this.validateRequest(req, to);
        ResponseToGetResourceRequest response = this.protocolHandler.send(this.authenticator, req, to);
        return response;
    }

    public ResponseToCheckDeliveryRequest send(CheckDeliveryRequest req) throws IncompleteRequestException, UnsupportedProtocolException, TransferProtocolException {
        ServerAddress to = this.config.getAddressPreselection();
        LOG.debug("enter send(CheckDeliveryRequest, ServerAddress)");
        LOG.info("Sende zu pr\u00fcfende Datenlieferung an Server " + to);
        this.validateRequest(req, to);
        ResponseToCheckDeliveryRequest response = this.protocolHandler.send(this.authenticator, req, to);
        return response;
    }

    public ResponseToGetCommonResourceRequest send(GetCommonResourceRequest req) throws IncompleteRequestException, UnsupportedProtocolException, TransferProtocolException {
        ServerAddress to = this.config.getAddressPreselection();
        LOG.debug("enter send(GetCommonResourceRequest, ServerAddress)");
        LOG.info("Sende Ressource-Anfrage an Server " + to);
        this.validateRequest(req, to);
        ResponseToGetCommonResourceRequest response = this.protocolHandler.send(this.authenticator, req, to);
        return response;
    }

    public ResponseToPingRequest send(PingRequest req) throws IncompleteRequestException, UnsupportedProtocolException, TransferProtocolException {
        ServerAddress to = this.config.getAddressPreselection();
        LOG.debug("enter send(PingRequest, ServerAddress)");
        LOG.info("Sende Ping-Anfrage an Server " + to);
        this.validateRequest(req, to);
        ResponseToPingRequest response = this.protocolHandler.send(req, to);
        return response;
    }

    public void addStatusListener(ClientStatusListener listener) {
        this.protocolHandler.addStatusListener(listener);
    }

    public void removeStatusListener(ClientStatusListener listener) {
        this.protocolHandler.removeStatusListener(listener);
    }

    public ClientStatusListener[] getStatusListeners() {
        return this.protocolHandler.getStatusListeners();
    }

    public static void main(String[] args) {
        block46: {
            try {
                Response response;
                DatMLRawDocument document;
                if (args == null || args.length != 6 && args.length != 8 && args.length != 2 && args.length != 4) {
                    throw new IllegalArgumentException("Falsche Anzahl der Parameter.");
                }
                boolean send = false;
                boolean fetch = false;
                boolean check = false;
                boolean ping = false;
                String action = null;
                String rawfile = null;
                String stamp = null;
                String conffile = null;
                String username = null;
                String password = null;
                for (int i = 0; i < args.length - 1; i += 2) {
                    if ("-action".equals(args[i])) {
                        action = args[i + 1];
                        continue;
                    }
                    if ("-rawfile".equals(args[i])) {
                        rawfile = args[i + 1];
                        continue;
                    }
                    if ("-stamp".equals(args[i])) {
                        stamp = args[i + 1];
                        continue;
                    }
                    if ("-conffile".equals(args[i])) {
                        conffile = args[i + 1];
                        continue;
                    }
                    if ("-username".equals(args[i])) {
                        username = args[i + 1];
                        continue;
                    }
                    if ("-password".equals(args[i])) {
                        password = args[i + 1];
                        continue;
                    }
                    throw new IllegalArgumentException("Falscher Parameter: " + args[i]);
                }
                if (action == null) {
                    throw new IllegalArgumentException("Die Aktion (send|fetch|check|ping) wurde nicht angegeben.");
                }
                if (action.equalsIgnoreCase("send")) {
                    if (rawfile == null) {
                        throw new IllegalArgumentException("Der Name der zu versendenden DatML/RAW-Datei wurde nicht angegeben.");
                    }
                    send = true;
                } else if (action.equalsIgnoreCase("fetch")) {
                    if (stamp == null) {
                        throw new IllegalArgumentException("Der Eingangsstempel wurde nicht angegeben.");
                    }
                    fetch = true;
                } else if (action.equalsIgnoreCase("check")) {
                    if (rawfile == null) {
                        throw new IllegalArgumentException("Der Name der zu pr\u00fcfenden DatML/RAW-Datei wurde nicht angegeben.");
                    }
                    check = true;
                } else if (action.equalsIgnoreCase("ping")) {
                    ping = true;
                } else {
                    throw new IllegalArgumentException("Keine gueltige Aktion (send|fetch|check|ping) angegeben.");
                }
                Properties properties = null;
                if (conffile != null) {
                    properties = new Properties();
                    FileInputStream in = new FileInputStream(conffile);
                    properties.load(in);
                    in.close();
                    if (username == null) {
                        username = properties.getProperty(PROPERTY_USERNAME);
                    }
                    if (password == null) {
                        password = properties.getProperty(PROPERTY_PASSWORD);
                    }
                }
                if (username == null && !ping) {
                    throw new IllegalArgumentException("Die Benutzerkennung wurde nicht angegeben.");
                }
                if (password == null && !ping) {
                    throw new IllegalArgumentException("Das Passwort wurde nicht angegeben.");
                }
                if (username == null && ping) {
                    username = "ping_kennung";
                }
                if (password == null && ping) {
                    password = "ping_password";
                }
                Client client = properties != null ? new Client(username, password.toCharArray(), properties) : new Client(username, password.toCharArray());
                if (send) {
                    document = new DatMLRawDocument();
                    File file = new File(rawfile);
                    document.setDocument(DocumentSourceFactory.createDocumentSource(file));
                    ResponseToDataDelivery response2 = client.send(new DataDelivery(document, file.getName()));
                    if (response2.getStatus() == ResponseStatus.OK) {
                        System.out.println(response2.getEntryStamp());
                        if (response2.getProtocol() != null) {
                            System.out.println(response2.getProtocol().getDocument());
                        }
                    } else if (ResponseStatus.NO_VALID_XML == response2.getStatus()) {
                        System.out.println(response2.getStatus());
                        System.out.println(response2.getErrorText());
                        System.out.println(response2.getProtocol().getDocument());
                    } else {
                        System.out.println(response2.getStatus());
                        System.out.println(response2.getErrorText());
                    }
                    break block46;
                }
                if (fetch) {
                    response = client.send(new ProtocolRequest(stamp));
                    if (response.getStatus() == ResponseStatus.OK) {
                        System.out.println(((ResponseToProtocolRequest)response).getProtocol().getDocument());
                    } else if (response.getStatus() != ResponseStatus.RES_NOT_AVAILABLE) {
                        System.out.println(response.getStatus());
                        System.out.println(response.getErrorText());
                    }
                    break block46;
                }
                if (check) {
                    document = new DatMLRawDocument();
                    File file = new File(rawfile);
                    document.setDocument(DocumentSourceFactory.createDocumentSource(file));
                    ResponseToCheckDeliveryRequest response3 = client.send(new CheckDeliveryRequest(document, file.getName()));
                    if (response3.getStatus() == ResponseStatus.OK) {
                        System.out.println(response3.getProtocol().getDocument());
                    } else {
                        System.out.println(response3.getStatus());
                        System.out.println(response3.getErrorText());
                    }
                    break block46;
                }
                if (ping) {
                    response = client.send(new PingRequest());
                    if (ResponseStatus.OK == response.getStatus()) {
                        System.out.println(response.getStatus());
                    } else {
                        System.out.println(response.getStatus());
                        System.out.println(response.getErrorText());
                    }
                    break block46;
                }
                throw new IllegalStateException("Keine Aktion.");
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                System.err.println("Usage:");
                System.err.println("Client -action send -rawfile <rawfilename> -conffile <conffilename>");
                System.err.println("Client -action send -rawfile <rawfilename> -username <userid> -password <passwd>");
                System.err.println();
                System.err.println("Client -action fetch -stamp <entrystamp> -conffile <conffilename>");
                System.err.println("Client -action fetch -stamp <entrystamp> -username <userid> -password <passwd>");
                System.err.println();
                System.err.println("Client -action check -rawfile <rawfilename> -conffile <conffilename>");
                System.err.println("Client -action check -rawfile <rawfilename> -username <userid> -password <passwd>");
                System.err.println();
                System.err.println("Client -action ping [-conffile <conffilename>]");
            }
            catch (Throwable t) {
                System.err.println(t.getMessage());
            }
        }
    }

    private void validateRequest(Request req, ServerAddress to) throws IncompleteRequestException, UnsupportedProtocolException {
        LOG.debug("enter validateRequest()");
        this.protocolHandler.notifyListeners(new ClientStatusEvent(this, 1, "Pruefe Request auf Vollstaendigkeit"));
        try {
            req.check();
        }
        catch (IncompleteRequestException exc) {
            LOG.error("Request ist ungueltig!");
            LOG.error("Verarbeitung wird abgebrochen.");
            LOG.error("Fehlermeldung: " + exc.getMessage());
            throw exc;
        }
        LOG.trace("Request ist korrekt und vollstaendig");
        TransferProtocol protocol = this.config.getProtocol();
        TransferProtocol[] supportedProtocols = to.getSupportedProtocols();
        boolean found = false;
        for (int idx = 0; idx < supportedProtocols.length; ++idx) {
            if (!protocol.equals(supportedProtocols[idx])) continue;
            LOG.trace("Das Protokoll " + protocol + " wird von dem Server unterstuetzt");
            found = true;
        }
        if (!found) {
            String message = "Das Protokoll '" + protocol + "' wird von dem Server '" + to + "' nicht unterstuetzt";
            LOG.info(message);
            LOG.info("Die Verarbeitung wird abgebrochen");
            throw new UnsupportedProtocolException(message);
        }
        LOG.trace("Request erfolgreich ueberprueft");
    }

    private void init(ClientAuthenticator authenticator, ClientConfig config) {
        Contract.verify(authenticator != null, "Kein Authentifikator angegeben");
        Contract.verify(config != null, "Keine Konfiguration angegeben");
        this.authenticator = authenticator;
        this.config = config;
        Client.initializeLogger();
        LOG.info("");
        LOG.info("Erzeuge neue Instanz des CORE.connect-Clients");
        LOG.info("");
        this.config.logConfiguration();
        this.protocolHandler = ProtocolHandlerFactory.getInstance().createProtocolHandler(this.config);
        assert (this.protocolHandler != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeLogger() {
        if (LOG != null) return;
        Class<Client> clazz = Client.class;
        synchronized (Client.class) {
            if (LOG != null) return;
            LOG = ClientLogger.getLogger(Client.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        String version = null;
        Package pkg = Package.getPackage("de.destatis.core.connect");
        if (pkg != null) {
            version = pkg.getSpecificationVersion();
        }
        if (version == null) {
            version = "?";
        }
        CONNECT_VERSION = version;
    }
}

