/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.expr.util;

import info.bliki.wiki.template.expr.SyntaxError;
import info.bliki.wiki.template.expr.eval.DoubleEvaluator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class Console {
    private File fFile;

    public static void main(String[] args) {
        Console console;
        Console.printUsage();
        try {
            console = new Console();
        }
        catch (SyntaxError e1) {
            e1.printStackTrace();
            return;
        }
        String expr = null;
        console.setArgs(args);
        File file = console.getFile();
        if (file != null) {
            try {
                String line;
                BufferedReader f = new BufferedReader(new FileReader(file));
                StringBuffer buff = new StringBuffer(1024);
                while ((line = f.readLine()) != null) {
                    buff.append(line);
                    buff.append("\n");
                }
                f.close();
                System.out.println(console.interpreter(buff.toString()));
            }
            catch (IOException ioe) {
                String msg = "Cannot read from the specified file. Make sure the path exists and you have read permission.";
                System.out.println("Cannot read from the specified file. Make sure the path exists and you have read permission.");
                return;
            }
        }
        block7: while (true) {
            try {
                while (true) {
                    if ((expr = console.readString(System.out, ">>> ")) == null) {
                        continue;
                    }
                    if (expr.length() >= 4 && expr.toLowerCase().substring(0, 4).equals("exit")) break block7;
                    System.out.println(console.interpreter(expr));
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    private static void printUsage() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append(Console.class.getCanonicalName() + " [options]" + lineSeparator);
        msg.append(lineSeparator);
        msg.append("Options: " + lineSeparator);
        msg.append("  -h or -help                  print this message" + lineSeparator);
        msg.append("  -f or -file <filename>       use given file as input" + lineSeparator);
        msg.append("To stop the program type: " + lineSeparator);
        msg.append("exit<RETURN-KEY>" + lineSeparator);
        msg.append("****+****+****+****+****+****+****+****+****+****+****+****+");
        System.out.println(msg.toString());
    }

    private void setArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-help") || arg.equals("-h")) {
                Console.printUsage();
                return;
            }
            if (arg.equals("-file") || arg.equals("-f")) {
                try {
                    this.fFile = new File(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    String msg = "You must specify a file when using the -file argument";
                    System.out.println("You must specify a file when using the -file argument");
                    return;
                }
            }
            if (!arg.startsWith("-")) continue;
            String msg = "Unknown arg: " + arg;
            System.out.println(msg);
            Console.printUsage();
            return;
        }
    }

    public String interpreter(String strEval) {
        try {
            DoubleEvaluator engine = new DoubleEvaluator();
            double d = engine.evaluate(strEval);
            return Double.toString(d);
        }
        catch (SyntaxError e) {
            System.err.println();
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public void printPrompt(PrintStream out, String prompt) {
        out.print(prompt);
        out.flush();
    }

    public String readString(PrintStream out) {
        StringBuffer input = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean done = false;
        try {
            while (!done) {
                String s = in.readLine();
                if (s == null) continue;
                if (s.length() > 0 && s.charAt(s.length() - 1) != '\\') {
                    input.append(s);
                    done = true;
                    continue;
                }
                if (s.length() > 1) {
                    input.append(s.substring(0, s.length() - 1));
                    continue;
                }
                input.append(" ");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return input.toString();
    }

    public String readString(PrintStream out, String prompt) {
        this.printPrompt(out, prompt);
        return this.readString(out);
    }

    public void setFile(File file) {
        this.fFile = file;
    }

    public File getFile() {
        return this.fFile;
    }
}

