/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.expr.operator;

import info.bliki.wiki.template.expr.ast.ASTNode;
import info.bliki.wiki.template.expr.ast.FloatNode;
import info.bliki.wiki.template.expr.ast.FractionNode;
import info.bliki.wiki.template.expr.ast.FunctionNode;
import info.bliki.wiki.template.expr.ast.IParserFactory;
import info.bliki.wiki.template.expr.ast.IntegerNode;
import info.bliki.wiki.template.expr.ast.StringNode;
import info.bliki.wiki.template.expr.ast.SymbolNode;
import info.bliki.wiki.template.expr.operator.DivideOperator;
import info.bliki.wiki.template.expr.operator.InfixOperator;
import info.bliki.wiki.template.expr.operator.Operator;
import info.bliki.wiki.template.expr.operator.PostfixOperator;
import info.bliki.wiki.template.expr.operator.PreMinusOperator;
import info.bliki.wiki.template.expr.operator.PrePlusOperator;
import info.bliki.wiki.template.expr.operator.PrefixOperator;
import info.bliki.wiki.template.expr.operator.SubtractOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNodeFactory
implements IParserFactory {
    public static final int PLUS_PRECEDENCE = 2900;
    public static final int TIMES_PRECEDENCE = 3800;
    public static final String[] HEADER_STRINGS = new String[]{"Mod", "Plus", "GreaterEqual", "Round", "Times", "Less", "Subtract", "Unequal", "Unequal", "Not", "Sin", "Cos", "Tan", "ASin", "ACos", "ATan", "Ln", "Exp", "Abs", "Ceil", "Floor", "Trunc", "LessEqual", "Or", "PrePlus", "Equal", "Divide", "Divide", "Greater", "PreMinus", "Pow", "And"};
    public static final String[] OPERATOR_STRINGS = new String[]{"mod", "+", ">=", "round", "*", "<", "-", "<>", "!=", "not", "sin", "cos", "tan", "asin", "acos", "atan", "ln", "exp", "abs", "ceil", "floor", "trunc", "<=", "or", "+", "=", "div", "/", ">", "-", "^", "and"};
    public static final Operator[] OPERATORS = new Operator[]{new InfixOperator("mod", "Mod", 3800, 0), new InfixOperator("+", "Plus", 2900, 0), new InfixOperator(">=", "GreaterEqual", 2600, 0), new InfixOperator("round", "Round", 2800, 0), new InfixOperator("*", "Times", 3800, 0), new InfixOperator("<", "Less", 2600, 0), new InfixOperator("-", "Subtract", 2900, 0), new InfixOperator("<>", "Unequal", 2600, 0), new InfixOperator("!=", "Unequal", 2600, 0), new PrefixOperator("not", "Not", 4600), new PrefixOperator("sin", "Sin", 4600), new PrefixOperator("cos", "Cos", 4600), new PrefixOperator("tan", "Tan", 4600), new PrefixOperator("asin", "ASin", 4600), new PrefixOperator("acos", "ACos", 4600), new PrefixOperator("atan", "ATan", 4600), new PrefixOperator("ln", "Ln", 4600), new PrefixOperator("exp", "Exp", 4600), new PrefixOperator("abs", "Abs", 4600), new PrefixOperator("ceil", "Ceil", 4600), new PrefixOperator("floor", "Floor", 4600), new PrefixOperator("trunc", "Trunc", 4600), new InfixOperator("<=", "LessEqual", 2600, 0), new InfixOperator("or", "Or", 1900, 0), new PrePlusOperator("+", "PrePlus", 4600), new InfixOperator("=", "Equal", 2600, 0), new InfixOperator("div", "Divide", 3800, 0), new InfixOperator("/", "Divide", 3800, 0), new InfixOperator(">", "Greater", 2600, 0), new PreMinusOperator("-", "PreMinus", 4600), new InfixOperator("^", "Pow", 3700, 0), new InfixOperator("and", "And", 2000, 0)};
    public static final ASTNodeFactory MMA_STYLE_FACTORY = new ASTNodeFactory();
    private static HashMap<String, Operator> fOperatorMap = new HashMap();
    private static HashMap<String, ArrayList<Operator>> fOperatorTokenStartSet = new HashMap();
    private static HashMap<String, String> fConstantSymbols = new HashMap();

    public static void addOperator(HashMap<String, Operator> operatorMap, HashMap<String, ArrayList<Operator>> operatorTokenStartSet, String operatorStr, String headStr, Operator oper) {
        operatorMap.put(headStr, oper);
        ArrayList<Operator> list = operatorTokenStartSet.get(operatorStr);
        if (list == null) {
            list = new ArrayList(2);
            list.add(oper);
            operatorTokenStartSet.put(operatorStr, list);
        } else {
            list.add(oper);
        }
    }

    @Override
    public String getOperatorCharacters() {
        return "-=<>*+/!^";
    }

    @Override
    public Map<String, Operator> getIdentifier2OperatorMap() {
        return fOperatorMap;
    }

    @Override
    public Operator get(String identifier) {
        return fOperatorMap.get(identifier);
    }

    @Override
    public Map<String, ArrayList<Operator>> getOperator2ListMap() {
        return fOperatorTokenStartSet;
    }

    @Override
    public List<Operator> getOperatorList(String key) {
        return fOperatorTokenStartSet.get(key);
    }

    @Override
    public String getConstantSymbol(String key) {
        return fConstantSymbols.get(key);
    }

    public static InfixOperator createInfixOperator(String operatorStr, String headStr, int precedence, int grouping) {
        InfixOperator oper = headStr.equals("Divide") ? new DivideOperator(operatorStr, headStr, precedence, grouping) : (headStr.equals("Subtract") ? new SubtractOperator(operatorStr, headStr, precedence, grouping) : new InfixOperator(operatorStr, headStr, precedence, grouping));
        return oper;
    }

    public static PrefixOperator createPrefixOperator(String operatorStr, String headStr, int precedence) {
        PrefixOperator oper = headStr.equals("PreMinus") ? new PreMinusOperator(operatorStr, headStr, precedence) : (headStr.equals("PrePlus") ? new PrePlusOperator(operatorStr, headStr, precedence) : new PrefixOperator(operatorStr, headStr, precedence));
        return oper;
    }

    public static PostfixOperator createPostfixOperator(String operatorStr, String headStr, int precedence) {
        return new PostfixOperator(operatorStr, headStr, precedence);
    }

    @Override
    public ASTNode createDouble(String doubleString) {
        return new FloatNode(doubleString);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head) {
        return new FunctionNode(head);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head, ASTNode arg0) {
        return new FunctionNode(head, arg0);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head, ASTNode arg0, ASTNode arg1) {
        return new FunctionNode(head, arg0, arg1);
    }

    @Override
    public FunctionNode createAST(ASTNode headExpr) {
        return new FunctionNode(headExpr);
    }

    @Override
    public IntegerNode createInteger(String integerString, int numberFormat) {
        return new IntegerNode(integerString, numberFormat);
    }

    @Override
    public IntegerNode createInteger(int intValue) {
        return new IntegerNode(intValue);
    }

    @Override
    public FractionNode createFraction(IntegerNode numerator, IntegerNode denominator) {
        return new FractionNode(numerator, denominator);
    }

    @Override
    public StringNode createString(StringBuffer buffer) {
        return new StringNode(buffer.toString());
    }

    @Override
    public SymbolNode createSymbol(String symbolName) {
        return new SymbolNode(symbolName);
    }

    static {
        fOperatorMap = new HashMap();
        fOperatorTokenStartSet = new HashMap();
        fConstantSymbols.put("e", "E");
        fConstantSymbols.put("pi", "Pi");
        for (int i = 0; i < HEADER_STRINGS.length; ++i) {
            ASTNodeFactory.addOperator(fOperatorMap, fOperatorTokenStartSet, OPERATOR_STRINGS[i], HEADER_STRINGS[i], OPERATORS[i]);
        }
    }
}

