/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.commons.validator.routines.EmailValidator;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.EndTagToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.IParser;
import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WPList;
import info.bliki.wiki.filter.WPTable;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.DefaultEventListener;
import info.bliki.wiki.model.IEventListener;
import info.bliki.wiki.model.ITableOfContent;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLBlockTag;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.HrTag;
import info.bliki.wiki.tags.PTag;
import info.bliki.wiki.tags.WPBoldItalicTag;
import info.bliki.wiki.tags.WPPreTag;
import info.bliki.wiki.tags.WPTag;
import info.bliki.wiki.tags.util.Attribute;
import info.bliki.wiki.tags.util.IBodyTag;
import info.bliki.wiki.tags.util.INoBodyParsingTag;
import info.bliki.wiki.tags.util.NodeAttribute;
import info.bliki.wiki.tags.util.TagStack;
import info.bliki.wiki.tags.util.WikiTagNode;
import java.util.List;

public class WikipediaParser
extends AbstractParser
implements IParser {
    private static final String[] TOC_IDENTIFIERS = new String[]{"TOC", "NOTOC", "FORCETOC"};
    static final String[] HEADER_STRINGS = new String[]{"=", "==", "===", "====", "=====", "======"};
    static final int TokenNotFound = -2;
    static final int TokenIgnore = -1;
    static final int TokenSTART = 0;
    static final int TokenEOF = 1;
    static final int TokenBOLD = 3;
    static final int TokenITALIC = 4;
    static final int TokenBOLDITALIC = 5;
    static final HTMLTag BOLD = new WPTag("b");
    static final HTMLTag ITALIC = new WPTag("i");
    static final HTMLTag BOLDITALIC = new WPBoldItalicTag();
    static final HTMLTag STRONG = new WPTag("strong");
    static final HTMLTag EM = new WPTag("em");
    private ITableOfContent fTableOfContentTag = null;
    private int fHeadCounter = 0;
    private boolean fHtmlCodes = true;
    private boolean fNoToC = false;
    private boolean fRenderTemplate = false;
    private boolean fForceToC = false;
    private IEventListener fEventListener = null;

    public WikipediaParser(String stringSource, boolean renderTemplate) {
        this(stringSource, renderTemplate, null);
    }

    public WikipediaParser(String stringSource, boolean renderTemplate, IEventListener wikiListener) {
        super(stringSource);
        this.fRenderTemplate = renderTemplate;
        this.fEventListener = wikiListener == null ? DefaultEventListener.CONST : wikiListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContentToken(int diff) {
        if (this.fWhiteStart) {
            try {
                int whiteEndPosition = this.fCurrentPosition - diff;
                int count = whiteEndPosition - this.fWhiteStartPosition;
                if (count > 0) {
                    this.fWikiModel.append(new ContentToken(this.fStringSource.substring(this.fWhiteStartPosition, this.fWhiteStartPosition + count)));
                }
            }
            finally {
                this.fWhiteStart = false;
            }
        }
    }

    protected final boolean getNextChar(char testedChar) {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (this.fCurrentCharacter != testedChar) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final int getNextChar(char testedChar1, char testedChar2) {
        int temp = this.fCurrentPosition;
        try {
            int result;
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (this.fCurrentCharacter == testedChar1) {
                result = 0;
            } else if (this.fCurrentCharacter == testedChar2) {
                result = 1;
            } else {
                this.fCurrentPosition = temp;
                return -1;
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return -1;
        }
    }

    protected final boolean getNextCharAsDigit() {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (!Character.isDigit(this.fCurrentCharacter)) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final boolean getNextCharAsDigit(int radix) {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (Character.digit(this.fCurrentCharacter, radix) == -1) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final int getNumberOfChar(char testedChar) {
        int number = 0;
        try {
            while ((this.fCurrentCharacter = this.fSource[this.fCurrentPosition++]) == testedChar) {
                ++number;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        --this.fCurrentPosition;
        return number;
    }

    protected boolean getNextCharAsWikiPluginIdentifierPart() {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (!Encoder.isWikiPluginIdentifierPart(this.fCurrentCharacter)) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected int getNextToken() {
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
        try {
            block23: while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                switch (this.fCurrentCharacter) {
                    case '\n': {
                        this.reduceTokenStackBoldItalic();
                        break;
                    }
                    case '{': {
                        if (this.parseTemplate() || !this.parseTable()) break;
                        continue block23;
                    }
                    case '_': {
                        if (!this.parseSpecialIdentifiers()) break;
                        continue block23;
                    }
                    case '=': {
                        if (!this.parseSectionHeaders()) break;
                        continue block23;
                    }
                    case '#': 
                    case '*': 
                    case ':': 
                    case ';': {
                        if (!this.parseLists()) break;
                        continue block23;
                    }
                    case '-': {
                        if (!this.parseHorizontalRuler()) break;
                        continue block23;
                    }
                    case '\t': 
                    case ' ': {
                        if (!this.parsePreformattedHorizontalRuler()) break;
                        if (!this.fWhiteStart) {
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = this.fCurrentPosition;
                            continue block23;
                        }
                        this.createContentToken(1);
                        continue block23;
                    }
                }
                if (this.isStartOfLine() && this.fWikiModel.getRecursionLevel() == 1) {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode() instanceof PTag && this.isEmptyLine(1)) {
                        this.createContentToken(2);
                        this.reduceTokenStack(Configuration.HTML_PARAGRAPH_OPEN);
                    } else if (!this.isEmptyLine(1)) {
                        if (this.fWikiModel.stackSize() == 0) {
                            this.addParagraph();
                        } else {
                            TagToken tag = this.fWikiModel.peekNode();
                            if (tag instanceof WPPreTag) {
                                this.addPreformattedText();
                            } else {
                                String allowedParents = Configuration.HTML_PARAGRAPH_OPEN.getParents();
                                if (allowedParents != null) {
                                    int index = -1;
                                    index = allowedParents.indexOf("|" + tag.getName() + "|");
                                    if (index >= 0) {
                                        this.addParagraph();
                                    }
                                }
                            }
                        }
                    }
                }
                switch (this.fCurrentCharacter) {
                    case '[': {
                        if (!this.parseWikiLink()) break;
                        continue block23;
                    }
                    case '\'': {
                        if (!this.getNextChar('\'')) break;
                        if (this.getNextChar('\'')) {
                            if (this.getNextChar('\'')) {
                                if (this.getNextChar('\'')) {
                                    this.createContentToken(5);
                                    return 5;
                                }
                                --this.fCurrentPosition;
                                this.fWhiteStart = true;
                                this.createContentToken(3);
                                return 3;
                            }
                            this.createContentToken(3);
                            return 3;
                        }
                        this.createContentToken(2);
                        return 4;
                    }
                    case '<': {
                        if (!this.fHtmlCodes) break;
                        int htmlStartPosition = this.fCurrentPosition;
                        try {
                            switch (this.fStringSource.charAt(this.fCurrentPosition)) {
                                case '!': {
                                    if (this.parseHTMLCommentTags()) {
                                        continue block23;
                                    }
                                    break;
                                }
                                default: {
                                    TagToken tag;
                                    WikiTagNode tagNode;
                                    if (this.fSource[this.fCurrentPosition] != '/') {
                                        tagNode = this.parseTag(this.fCurrentPosition);
                                        if (tagNode != null) {
                                            String tagName = tagNode.getTagName();
                                            tag = this.fWikiModel.getTokenMap().get(tagName);
                                            if (tag != null) {
                                                if ((tag = (TagToken)tag.clone()) instanceof TagNode) {
                                                    TagNode node = (TagNode)tag;
                                                    List<NodeAttribute> attributes = tagNode.getAttributesEx();
                                                    for (int i = 1; i < attributes.size(); ++i) {
                                                        Attribute attr = attributes.get(i);
                                                        node.addAttribute(attr.getName(), attr.getValue(), true);
                                                    }
                                                }
                                                if (tag instanceof HTMLTag) {
                                                    ((HTMLTag)tag).setTemplate(this.isTemplate());
                                                }
                                                this.createContentToken(1);
                                                this.fCurrentPosition = this.fScannerPosition;
                                                String allowedParents = tag.getParents();
                                                if (allowedParents != null) {
                                                    this.reduceTokenStack(tag);
                                                }
                                                this.createTag(tag, tagNode, tagNode.getEndPosition());
                                                return -1;
                                            }
                                        }
                                    } else if ((tagNode = this.parseTag(++this.fCurrentPosition)) != null) {
                                        String tagName = tagNode.getTagName();
                                        tag = this.fWikiModel.getTokenMap().get(tagName);
                                        if (tag != null) {
                                            this.createContentToken(2);
                                            this.fCurrentPosition = this.fScannerPosition;
                                            if (this.fWikiModel.stackSize() > 0) {
                                                TagToken topToken = this.fWikiModel.peekNode();
                                                if (topToken.getName().equals(tag.getName())) {
                                                    this.fWikiModel.popNode();
                                                    return -1;
                                                }
                                                if (tag.isReduceTokenStack()) {
                                                    this.reduceStackUntilToken(tag);
                                                }
                                            }
                                            return -1;
                                        }
                                    }
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        this.fCurrentPosition = htmlStartPosition;
                        break;
                    }
                    default: {
                        if (Character.isLetter(this.fCurrentCharacter) && ((this.fCurrentCharacter == 'i' || this.fCurrentCharacter == 'I') && this.parseISBNLinks() || this.parseURIScheme() || this.fWikiModel.isCamelCaseEnabled() && Character.isUpperCase(this.fCurrentCharacter) && this.fWikiModel.getRecursionLevel() <= 1 && this.parseCamelCaseLink())) continue block23;
                    }
                }
                if (this.fWhiteStart) continue;
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition - 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            try {
                this.createContentToken(1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return 1;
        }
    }

    private void addParagraph() {
        this.createContentToken(2);
        this.reduceTokenStack(Configuration.HTML_PARAGRAPH_OPEN);
        this.fWikiModel.pushNode(new PTag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPreformattedText() {
        if (this.fWhiteStart) {
            int whiteEndPosition;
            int currentPos = this.fCurrentPosition;
            for (whiteEndPosition = this.fCurrentPosition - 2; whiteEndPosition > this.fWhiteStartPosition; --whiteEndPosition) {
                if (Character.isWhitespace(this.fSource[whiteEndPosition])) continue;
                ++whiteEndPosition;
                break;
            }
            try {
                this.fCurrentPosition = whiteEndPosition;
                this.createContentToken(0);
            }
            finally {
                this.fCurrentPosition = currentPos;
            }
        }
        this.reduceTokenStack(Configuration.HTML_PARAGRAPH_OPEN);
        this.fWikiModel.pushNode(new PTag());
    }

    private boolean parseHTMLCommentTags() {
        int htmlStartPosition = this.fCurrentPosition;
        String htmlCommentString = this.fStringSource.substring(this.fCurrentPosition - 1, this.fCurrentPosition + 3);
        if (htmlCommentString.equals("<!--")) {
            String htmlCommentContent;
            this.fCurrentPosition += 3;
            if (this.readUntil("-->") && (htmlCommentContent = this.fStringSource.substring(htmlStartPosition + 3, this.fCurrentPosition - 3)) != null) {
                this.createContentToken(this.fCurrentPosition - htmlStartPosition + 1);
                return true;
            }
        }
        return false;
    }

    private boolean parseISBNLinks() {
        String urlString;
        boolean foundISBN;
        int urlStartPosition;
        block5: {
            urlStartPosition = this.fCurrentPosition;
            foundISBN = false;
            try {
                urlString = this.fStringSource.substring(this.fCurrentPosition - 1, this.fCurrentPosition + 4);
                if (urlString.equalsIgnoreCase("isbn ")) {
                    this.fCurrentPosition += 4;
                    this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                    this.createContentToken(6);
                    this.fWhiteStart = false;
                    foundISBN = true;
                    char ch = this.fSource[this.fCurrentPosition++];
                    while (ch >= '0' && ch <= '9' || ch == '-') {
                        ch = this.fSource[this.fCurrentPosition++];
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (foundISBN) break block5;
                this.fCurrentPosition = urlStartPosition;
            }
        }
        if (foundISBN) {
            urlString = this.fStringSource.substring(urlStartPosition - 1, this.fCurrentPosition - 1);
            --this.fCurrentPosition;
            this.fWikiModel.appendISBNLink(urlString);
            return true;
        }
        return false;
    }

    private boolean parseMailtoLinks() {
        String urlString;
        int urlStartPosition = this.fCurrentPosition;
        int tempPosition = this.fCurrentPosition;
        boolean foundUrl = false;
        try {
            urlString = this.fStringSource.substring(this.fCurrentPosition - 1, this.fCurrentPosition + 6);
            if (urlString.equalsIgnoreCase("mailto:")) {
                tempPosition += 6;
                this.fCurrentCharacter = this.fSource[tempPosition++];
                foundUrl = true;
                while (!Character.isWhitespace(this.fSource[tempPosition++])) {
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (foundUrl) {
            urlString = this.fStringSource.substring(urlStartPosition - 1, tempPosition - 1);
            String email = urlString.substring(7);
            if (EmailValidator.getInstance().isValid(email)) {
                this.createContentToken(1);
                this.fWhiteStart = false;
                this.fCurrentPosition = tempPosition;
                --this.fCurrentPosition;
                this.fWikiModel.appendMailtoLink(urlString, urlString, true);
                return true;
            }
        }
        this.fCurrentPosition = urlStartPosition;
        return false;
    }

    private boolean parseURIScheme() {
        if ((this.fCurrentCharacter == 'm' || this.fCurrentCharacter == 'M') && this.parseMailtoLinks()) {
            return true;
        }
        int urlStartPosition = this.fCurrentPosition;
        int tempPosition = this.fCurrentPosition;
        String uriSchemeName = "";
        int index = -1;
        boolean foundUrl = false;
        try {
            index = this.indexOfUntilNoLetter(':', this.fCurrentPosition);
            if (index > 0 && this.fWikiModel.isValidUriScheme(uriSchemeName = this.fStringSource.substring(this.fCurrentPosition - 1, index))) {
                tempPosition += uriSchemeName.length() + 1;
                this.fCurrentCharacter = this.fSource[tempPosition++];
                this.createContentToken(1);
                this.fWhiteStart = false;
                foundUrl = true;
                while (Encoder.isUrlIdentifierPart(this.fSource[tempPosition++])) {
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (foundUrl) {
            String restString = this.fStringSource.substring(urlStartPosition - 1, tempPosition - 1);
            String uriSchemeSpecificPart = this.fStringSource.substring(index + 1, tempPosition - 1);
            if (this.fWikiModel.isValidUriSchemeSpecificPart(uriSchemeName, uriSchemeSpecificPart)) {
                this.fWhiteStart = false;
                this.fCurrentPosition = tempPosition;
                --this.fCurrentPosition;
                this.fWikiModel.appendExternalLink(uriSchemeName, restString, restString, true);
                return true;
            }
        }
        this.fCurrentPosition = urlStartPosition;
        return false;
    }

    private boolean parseCamelCaseLink() {
        int startLinkPosition = this.fCurrentPosition - 1;
        int temp = this.fCurrentPosition;
        boolean isCamelCase = false;
        try {
            char ch = this.fSource[temp++];
            while (Character.isLetterOrDigit(ch)) {
                if (Character.isUpperCase(ch)) {
                    isCamelCase = true;
                }
                ch = this.fSource[temp++];
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            // empty catch block
        }
        if (isCamelCase) {
            this.createContentToken(1);
            this.fWhiteStart = false;
            this.fCurrentPosition = temp - 1;
            String name = this.fStringSource.substring(startLinkPosition, this.fCurrentPosition);
            this.fWikiModel.appendInternalLink(name, null, name, null, false);
            return true;
        }
        return false;
    }

    private boolean parseWikiLink() {
        int startLinkPosition = this.fCurrentPosition;
        if (this.getNextChar('[')) {
            return this.parseWikiTag();
        }
        this.createContentToken(1);
        this.fWhiteStart = false;
        if (this.readUntilCharOrStopAtEOL(']')) {
            String name = this.fStringSource.substring(startLinkPosition, this.fCurrentPosition - 1);
            if (this.fWikiModel.parseBBCodes() && name.length() > 0) {
                StringBuilder bbCode = new StringBuilder(name.length());
                char ch = name.charAt(0);
                if ('a' <= ch && ch <= 'z') {
                    bbCode.append(ch);
                    if (this.parsePHPBBCode(name, bbCode)) {
                        return true;
                    }
                }
            }
            if (this.handleHTTPLink(name)) {
                return true;
            }
        }
        this.fCurrentPosition = startLinkPosition;
        return false;
    }

    private boolean parseWikiTag() {
        int startLinkPosition = this.fCurrentPosition;
        this.createContentToken(2);
        int temp = this.fCurrentPosition;
        if (this.findWikiLinkEnd()) {
            int endLinkPosition = this.fCurrentPosition - 2;
            String name = this.fStringSource.substring(startLinkPosition, endLinkPosition);
            temp = this.fCurrentPosition;
            StringBuilder suffixBuffer = new StringBuilder();
            try {
                while (true) {
                    this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                    if (!Character.isLowerCase(this.fCurrentCharacter)) {
                        --this.fCurrentPosition;
                        break;
                    }
                    suffixBuffer.append(this.fCurrentCharacter);
                }
                String suffix = suffixBuffer.toString();
                this.fEventListener.onWikiLink(this.fSource, startLinkPosition, endLinkPosition, suffix);
                this.fWikiModel.appendRawWikipediaLink(name, suffix);
                return true;
            }
            catch (IndexOutOfBoundsException e) {
                this.fCurrentPosition = temp;
                this.fEventListener.onWikiLink(this.fSource, startLinkPosition, endLinkPosition, "");
                this.fWikiModel.appendRawWikipediaLink(name, "");
                return true;
            }
        }
        this.fWhiteStart = true;
        this.fWhiteStartPosition = startLinkPosition - 2;
        this.fCurrentPosition = temp + 1;
        return false;
    }

    private boolean parsePreformattedHorizontalRuler() {
        if (this.isStartOfLine() && !this.isEmptyLine(1)) {
            if (this.fWikiModel.stackSize() == 0 || !(this.fWikiModel.peekNode() instanceof HTMLBlockTag) || this.fWikiModel.peekNode() instanceof PTag) {
                this.createContentToken(2);
                this.reduceTokenStack(Configuration.HTML_PRE_OPEN);
                this.fWikiModel.pushNode(new WPPreTag());
            }
            return true;
        }
        return false;
    }

    private boolean parseHorizontalRuler() {
        if (this.isStartOfLine()) {
            int tempCurrPosition = this.fCurrentPosition;
            try {
                int pos;
                if (this.fSource[tempCurrPosition++] == '-' && this.fSource[tempCurrPosition++] == '-' && this.fSource[tempCurrPosition++] == '-' && (pos = this.isEndOfLine('-', tempCurrPosition)) > 0) {
                    HrTag hr = new HrTag();
                    this.createContentToken(2);
                    this.reduceTokenStack(hr);
                    this.fCurrentPosition = pos;
                    this.fWikiModel.append(hr);
                    this.fWhiteStart = false;
                    return true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            this.fCurrentPosition = tempCurrPosition;
        }
        return false;
    }

    private boolean parseLists() {
        if (this.isStartOfLine()) {
            this.setPosition(this.fCurrentPosition - 2);
            WPList list = this.wpList();
            if (list != null && !list.isEmpty()) {
                this.createContentToken(1);
                this.reduceTokenStack(list);
                this.fCurrentPosition = this.getPosition() - 1;
                this.fWikiModel.append(list);
                return true;
            }
        }
        return false;
    }

    private boolean parseSectionHeaders() {
        if (this.isStartOfLine()) {
            char ch;
            int headerStartPosition = this.fCurrentPosition - 1;
            int endIndex = this.fStringSource.indexOf("\n", this.fCurrentPosition);
            if (endIndex < 0) {
                endIndex = this.fStringSource.length();
            }
            int headerEndPosition = endIndex;
            while (headerEndPosition > 0 && Character.isWhitespace(ch = this.fSource[--headerEndPosition])) {
            }
            if (headerEndPosition < 0 || headerEndPosition <= headerStartPosition) {
                return false;
            }
            int level = 0;
            int startPosition = headerStartPosition;
            int endPosition = headerEndPosition + 1;
            while (headerStartPosition < headerEndPosition) {
                if (this.fSource[headerStartPosition] == '=' && this.fSource[headerEndPosition] == '=') {
                    ++level;
                    ++headerStartPosition;
                    --headerEndPosition;
                    continue;
                }
                ++headerEndPosition;
                break;
            }
            if (level == 0) {
                return false;
            }
            if (level > 6) {
                level = 6;
            }
            this.createContentToken(1);
            this.reduceTokenStack();
            String head = "";
            if (headerEndPosition >= headerStartPosition) {
                head = headerEndPosition > headerStartPosition ? this.fStringSource.substring(headerStartPosition, headerEndPosition) : String.valueOf(this.fStringSource.charAt(headerStartPosition));
            }
            this.fEventListener.onHeader(this.fSource, startPosition, endPosition, headerStartPosition, headerEndPosition, level);
            this.fCurrentPosition = endIndex;
            if (head != null) {
                this.fTableOfContentTag = this.fWikiModel.appendHead(head, level, this.fNoToC, ++this.fHeadCounter, startPosition, endPosition);
            }
            return true;
        }
        return false;
    }

    private boolean parseTable() {
        if (this.isStartOfLine()) {
            this.setPosition(this.fCurrentPosition - 1);
            WPTable table = this.wpTable(this.fTableOfContentTag);
            if (table != null) {
                this.createContentToken(1);
                this.reduceTokenStack(table);
                this.fCurrentPosition = this.getPosition();
                this.fWikiModel.append(table);
                return true;
            }
        }
        return false;
    }

    private boolean parseTemplate() {
        int templateEndPosition;
        int templateStartPosition;
        if (this.fSource[this.fCurrentPosition] == '{' && this.fSource[templateStartPosition = this.fCurrentPosition + 1] != '{' && (templateEndPosition = WikipediaParser.findNestedTemplateEnd(this.fSource, templateStartPosition)) > 0) {
            this.fEventListener.onTemplate(this.fSource, templateStartPosition, templateEndPosition - 2);
            return true;
        }
        return false;
    }

    private boolean parseSpecialIdentifiers() {
        if (this.fSource[this.fCurrentPosition] == '_') {
            char ch;
            ++this.fCurrentPosition;
            int tocEndPosition = this.fCurrentPosition;
            while ((ch = this.fSource[tocEndPosition++]) >= 'A' && ch <= 'Z') {
            }
            if (ch == '_' && this.fSource[tocEndPosition] == '_') {
                String tocIdent = this.fStringSource.substring(this.fCurrentPosition, tocEndPosition - 1);
                boolean tocRecognized = false;
                for (int i = 0; i < TOC_IDENTIFIERS.length; ++i) {
                    if (!TOC_IDENTIFIERS[i].equals(tocIdent)) continue;
                    this.createContentToken(2);
                    tocRecognized = true;
                    this.fCurrentPosition = tocEndPosition + 1;
                    switch (i) {
                        case 0: {
                            this.fTableOfContentTag = this.fWikiModel.createTableOfContent(true);
                            this.fForceToC = true;
                            break;
                        }
                        case 1: {
                            this.setNoToC(true);
                            break;
                        }
                        case 2: {
                            this.fForceToC = true;
                        }
                    }
                    break;
                }
                if (tocRecognized) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isStartOfLine() {
        return this.fCurrentPosition >= 2 ? this.fSource[this.fCurrentPosition - 2] == '\n' : this.fCurrentPosition == 1;
    }

    private int isEndOfLine(char testChar, int currentPosition) {
        int tempPosition = currentPosition;
        try {
            char ch;
            while ((ch = this.fSource[tempPosition]) == testChar) {
                ++tempPosition;
            }
            do {
                if ((ch = this.fSource[tempPosition++]) != '\n') continue;
                return tempPosition;
            } while (Character.isWhitespace(ch));
            return -1;
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    private void createTag(TagToken tag, WikiTagNode tagNode, int startMacroPosition) {
        String macroBodyString = "";
        String command = tagNode.getTagName();
        if (tag != null && tag instanceof IBodyTag && !tagNode.isEmptyXmlTag()) {
            String endTag = command + '>';
            int index0 = Util.indexOfIgnoreCase(this.fStringSource, "</", endTag, startMacroPosition);
            if (index0 >= 0) {
                macroBodyString = this.fStringSource.substring(startMacroPosition, index0);
                this.fCurrentPosition = index0 + endTag.length() + 2;
            } else {
                macroBodyString = this.fStringSource.substring(startMacroPosition, this.fSource.length);
                this.fCurrentPosition = this.fSource.length;
            }
        } else {
            macroBodyString = null;
            this.fCurrentPosition = startMacroPosition;
        }
        this.handleTag(tag, tagNode, macroBodyString);
    }

    private boolean handleHTTPLink(String name) {
        String uriSchemeName = "";
        if (name != null) {
            boolean isEmail = false;
            String urlString = name.trim();
            int index = -1;
            boolean foundUrl = false;
            try {
                index = urlString.indexOf(58, 1);
                if (index > 0) {
                    uriSchemeName = urlString.substring(0, index);
                    if (uriSchemeName.equalsIgnoreCase("mailto")) {
                        isEmail = true;
                        foundUrl = true;
                    } else if (this.fWikiModel.isValidUriScheme(uriSchemeName)) {
                        foundUrl = true;
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            if (foundUrl) {
                int pipeIndex = urlString.indexOf(32);
                String alias = "";
                if (pipeIndex != -1) {
                    alias = urlString.substring(pipeIndex + 1);
                    urlString = urlString.substring(0, pipeIndex);
                } else {
                    alias = urlString;
                }
                if (isEmail) {
                    String email = pipeIndex > 7 ? urlString.substring(7, pipeIndex) : urlString.substring(7);
                    if (EmailValidator.getInstance().isValid(email)) {
                        this.fWikiModel.appendMailtoLink(urlString, alias, false);
                        return true;
                    }
                } else {
                    this.parseURIScheme();
                    String uriSchemeSpecificPart = urlString.substring(index + 1);
                    if (this.fWikiModel.isValidUriSchemeSpecificPart(uriSchemeName, uriSchemeSpecificPart)) {
                        this.fWikiModel.appendExternalLink(uriSchemeName, urlString, alias, false);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void handleTag(TagToken tag, WikiTagNode tagNode, String bodyString) {
        String command = tagNode.getTagName();
        try {
            if (tag instanceof EndTagToken) {
                this.fWikiModel.append(tag);
            } else {
                this.fWikiModel.pushNode(tag);
                if (null != bodyString) {
                    if (tag instanceof INoBodyParsingTag) {
                        ((TagNode)tag).addChild(new ContentToken(bodyString));
                    } else {
                        WikipediaParser.parseRecursive(bodyString.trim(), this.fWikiModel, false, true);
                    }
                }
                if (tag instanceof IBodyTag) {
                    this.fWikiModel.popNode();
                }
            }
        }
        catch (IllegalArgumentException e) {
            TagNode divTagNode = new TagNode("div");
            divTagNode.addAttribute("class", "error", true);
            divTagNode.addChild(new ContentToken("IllegalArgumentException: " + command + " - " + e.getMessage()));
            this.fWikiModel.append(divTagNode);
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
            TagNode divTagNode = new TagNode("div");
            divTagNode.addAttribute("class", "error", true);
            divTagNode.addChild(new ContentToken(command + ": " + e.getMessage()));
            this.fWikiModel.append(divTagNode);
            e.printStackTrace();
        }
    }

    public void runParser() {
        int token = 0;
        while ((token = this.getNextToken()) != 1) {
            switch (token) {
                case 5: {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLDITALIC)) {
                        this.fWikiModel.popNode();
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 1 && this.fWikiModel.peekNode().equals(BOLD) && this.fWikiModel.getNode(this.fWikiModel.stackSize() - 2).equals(ITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.popNode();
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 1 && this.fWikiModel.peekNode().equals(ITALIC) && this.fWikiModel.getNode(this.fWikiModel.stackSize() - 2).equals(BOLD)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.popNode();
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLD)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("i"));
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(ITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("b"));
                        break;
                    }
                    this.fWikiModel.pushNode(new WPBoldItalicTag());
                    break;
                }
                case 3: {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLDITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("i"));
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLD)) {
                        this.fWikiModel.popNode();
                        break;
                    }
                    this.fWikiModel.pushNode(new WPTag("b"));
                    break;
                }
                case 4: {
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(BOLDITALIC)) {
                        this.fWikiModel.popNode();
                        this.fWikiModel.pushNode(new WPTag("b"));
                        break;
                    }
                    if (this.fWikiModel.stackSize() > 0 && this.fWikiModel.peekNode().equals(ITALIC)) {
                        this.fWikiModel.popNode();
                        break;
                    }
                    this.fWikiModel.pushNode(new WPTag("i"));
                }
            }
        }
        this.reduceTokenStack();
        if (!this.fNoToC && this.fTableOfContentTag != null && (this.fHeadCounter > 3 || this.fForceToC)) {
            this.fTableOfContentTag.setShowToC(true);
        }
    }

    private void reduceTokenStack() {
        while (this.fWikiModel.stackSize() > 0) {
            this.fWikiModel.popNode();
        }
    }

    private void reduceTokenStackBoldItalic() {
        boolean found = false;
        while (this.fWikiModel.stackSize() > 0) {
            TagToken token = this.fWikiModel.peekNode();
            if (token.equals(BOLD) || token.equals(ITALIC) || token.equals(BOLDITALIC)) {
                if (this.fWhiteStart) {
                    found = true;
                    this.createContentToken(1);
                }
                this.fWikiModel.popNode();
                continue;
            }
            return;
        }
        if (found) {
            this.fWhiteStart = true;
            this.fWhiteStartPosition = this.fCurrentPosition;
        }
    }

    private void reduceTokenStack(TagToken node) {
        String allowedParents = node.getParents();
        if (allowedParents != null) {
            int index = -1;
            while (this.fWikiModel.stackSize() > 0) {
                TagToken tag = this.fWikiModel.peekNode();
                index = allowedParents.indexOf("|" + tag.getName() + "|");
                if (index >= 0) break;
                this.fWikiModel.popNode();
                if (!tag.getName().equals(node.getName())) continue;
                break;
            }
        } else {
            while (this.fWikiModel.stackSize() > 0) {
                this.fWikiModel.popNode();
            }
        }
    }

    private void reduceStackUntilToken(TagToken node) {
        int index = -1;
        String allowedParents = node.getParents();
        while (this.fWikiModel.stackSize() > 0) {
            TagToken tag = this.fWikiModel.peekNode();
            if (node.getName().equals(tag.getName())) {
                this.fWikiModel.popNode();
                break;
            }
            if (allowedParents == null) {
                this.fWikiModel.popNode();
                continue;
            }
            index = allowedParents.indexOf("|" + tag.getName() + "|");
            if (index >= 0) break;
            this.fWikiModel.popNode();
        }
    }

    public boolean isNoToC() {
        return this.fNoToC;
    }

    public void setNoToC(boolean noToC) {
        this.fNoToC = noToC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(String rawWikiText, IWikiModel wikiModel, boolean parseTemplates, Appendable templateParserBuffer) {
        block8: {
            try {
                wikiModel.setUp();
                Appendable buf = templateParserBuffer != null ? templateParserBuffer : new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
                if (parseTemplates) {
                    String pass1Text = null;
                    try {
                        TemplateParser.parse(rawWikiText, wikiModel, buf, wikiModel.isTemplateTopic());
                        pass1Text = buf.toString();
                    }
                    catch (Exception ioe) {
                        ioe.printStackTrace();
                        pass1Text = "<span class=\"error\">TemplateParser exception: " + ioe.getClass().getSimpleName() + "</span>";
                    }
                    String redirectedLink = AbstractParser.parseRedirect(pass1Text, wikiModel);
                    if (redirectedLink == null) {
                        WikipediaParser.parseRecursive(pass1Text, wikiModel, false, false);
                    }
                    break block8;
                }
                if (AbstractParser.parseRedirect(rawWikiText, wikiModel) == null) {
                    WikipediaParser.parseRecursive(rawWikiText, wikiModel, false, false);
                }
            }
            finally {
                wikiModel.tearDown();
            }
        }
    }

    public static void parseRecursive(String rawWikitext, IWikiModel wikiModel) {
        WikipediaParser.parseRecursive(rawWikitext, wikiModel, false, true);
    }

    public static TagStack parseRecursive(String rawWikitext, IWikiModel wikiModel, boolean createOnlyLocalStack, boolean noTOC) {
        AbstractParser parser = wikiModel.createNewInstance(rawWikitext);
        return parser.parseRecursiveInternal(wikiModel, createOnlyLocalStack, noTOC);
    }

    public boolean isTemplate() {
        return this.fRenderTemplate;
    }
}

