/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.WPListElement;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.WPTag;
import info.bliki.wiki.tags.util.TagStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WPList
extends WPTag {
    public static final char DL_DD_CHAR = ':';
    public static final char DL_DT_CHAR = ';';
    public static final char OL_CHAR = '#';
    public static final char UL_CHAR = '*';
    private char[] fLastSequence = null;
    private InternalList fNestedElements = null;
    private ArrayList<InternalList> fInternalListStack = new ArrayList();

    public WPList() {
        super("*#:;");
    }

    public boolean isEmpty() {
        return this.fNestedElements == null;
    }

    public boolean add(WPListElement listElement) {
        int i;
        char[] sequence = listElement.getSequence();
        int s1Length = 0;
        int s2Length = sequence.length;
        if (this.fLastSequence != null) {
            s1Length = this.fLastSequence.length;
        } else {
            this.fNestedElements = new InternalList(sequence[0]);
            this.fInternalListStack.add(this.fNestedElements);
        }
        int min = 0;
        int level = 0;
        min = s1Length > s2Length ? s2Length : s1Length;
        level = min;
        for (i = 0; i < min; ++i) {
            if (sequence[i] == this.fLastSequence[i] || (sequence[i] == ';' || sequence[i] == ':') && (this.fLastSequence[i] == ';' || this.fLastSequence[i] == ':')) continue;
            level = i;
            break;
        }
        this.popListStack(level);
        if (level < s2Length) {
            for (i = level; i < s2Length; ++i) {
                InternalList list = new InternalList(sequence[i]);
                ((List)this.fInternalListStack.get(this.fInternalListStack.size() - 1)).add(list);
                this.fInternalListStack.add(list);
            }
        }
        ((List)this.fInternalListStack.get(this.fInternalListStack.size() - 1)).add(listElement);
        this.fLastSequence = sequence;
        return true;
    }

    private void popListStack(int level) {
        if (this.fInternalListStack.size() > level) {
            for (int i = this.fInternalListStack.size() - 1; i > level; --i) {
                this.fInternalListStack.remove(i);
            }
        }
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (!this.isEmpty()) {
            this.fInternalListStack = null;
            for (int i = 0; i < this.fNestedElements.size(); ++i) {
                Object element = this.fNestedElements.get(i);
                if (element instanceof InternalList) {
                    InternalList subList = (InternalList)element;
                    this.beginHTMLTag(buf, subList);
                    this.renderSubListHTML(subList, converter, buf, wikiModel);
                    if (subList.fChar == '*') {
                        buf.append("</ul>");
                        continue;
                    }
                    if (subList.fChar == '#') {
                        buf.append("</ol>");
                        continue;
                    }
                    buf.append("</dl>");
                    continue;
                }
                TagStack stack = ((WPListElement)element).getTagStack();
                if (stack == null) continue;
                converter.nodesToText(stack.getNodeList(), buf, wikiModel);
            }
        }
    }

    private void beginHTMLTag(Appendable buf, InternalList subList) throws IOException {
        buf.append('\n');
        if (subList.fChar == '*') {
            buf.append("<ul>");
        } else if (subList.fChar == '#') {
            buf.append("<ol>");
        } else {
            buf.append("<dl>");
        }
    }

    private void endHTMLTag(Appendable buf, InternalList subList) throws IOException {
        if (subList.fChar == '*') {
            buf.append("</ul>");
        } else if (subList.fChar == '#') {
            buf.append("</ol>");
        } else {
            buf.append("</dl>");
        }
    }

    private void renderSubListHTML(InternalList list, ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (list.size() == 0) {
            return;
        }
        char currentChar = list.fChar;
        int lastChar = 32;
        if (currentChar == ':') {
            buf.append("\n<dd>");
        } else if (currentChar == ';') {
            buf.append("\n<dt>");
        } else {
            buf.append("\n<li>");
        }
        block8: for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            if (element instanceof InternalList) {
                InternalList subList = (InternalList)element;
                this.beginHTMLTag(buf, subList);
                this.renderSubListHTML(subList, converter, buf, wikiModel);
                this.endHTMLTag(buf, subList);
            } else {
                TagStack stack = ((WPListElement)element).getTagStack();
                if (stack != null) {
                    converter.nodesToText(stack.getNodeList(), buf, wikiModel);
                }
            }
            if (i >= list.size() - 1 || !(list.get(i + 1) instanceof WPListElement)) continue;
            lastChar = currentChar;
            char[] temp = ((WPListElement)list.get(i + 1)).getSequence();
            currentChar = temp[temp.length - 1];
            switch (lastChar) {
                case 58: {
                    buf.append("</dd>");
                    break;
                }
                case 59: {
                    buf.append("</dt>");
                    break;
                }
                default: {
                    buf.append("</li>");
                }
            }
            buf.append('\n');
            switch (currentChar) {
                case ':': {
                    buf.append("<dd>");
                    continue block8;
                }
                case ';': {
                    buf.append("<dt>");
                    continue block8;
                }
                default: {
                    buf.append("<li>");
                }
            }
        }
        if (currentChar == ':') {
            buf.append("</dd>");
        } else if (currentChar == ';') {
            buf.append("</dt>");
        } else {
            buf.append("</li>");
        }
    }

    public Object clone() {
        WPList tt = (WPList)super.clone();
        tt.fNestedElements = this.fNestedElements == null ? null : (InternalList)this.fNestedElements.clone();
        tt.fInternalListStack = (ArrayList)this.fInternalListStack.clone();
        if (this.fLastSequence == null) {
            tt.fLastSequence = null;
        } else {
            tt.fLastSequence = new char[this.fLastSequence.length];
            System.arraycopy(this.fLastSequence, 0, tt.fLastSequence, 0, this.fLastSequence.length);
        }
        return tt;
    }

    public boolean isReduceTokenStack() {
        return true;
    }

    public String getParents() {
        return "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    }

    public InternalList getNestedElements() {
        return this.fNestedElements;
    }

    private void renderSubListPlainText(InternalList list, ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (list.size() > 0) {
            buf.append("\n");
        }
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            if (element instanceof InternalList) {
                InternalList subList = (InternalList)element;
                this.renderSubListPlainText(subList, converter, buf, wikiModel);
            } else {
                TagStack stack = ((WPListElement)element).getTagStack();
                if (stack != null) {
                    converter.nodesToText(stack.getNodeList(), buf, wikiModel);
                }
            }
            if (i >= list.size() - 1 || !(list.get(i + 1) instanceof WPListElement)) continue;
            buf.append("\n");
        }
    }

    public void renderPlainText(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (!this.isEmpty()) {
            this.fInternalListStack = null;
            for (int i = 0; i < this.fNestedElements.size(); ++i) {
                Object element = this.fNestedElements.get(i);
                if (element instanceof InternalList) {
                    InternalList subList = (InternalList)element;
                    this.renderSubListPlainText(subList, converter, buf, wikiModel);
                    continue;
                }
                TagStack stack = ((WPListElement)element).getTagStack();
                if (stack == null) continue;
                converter.nodesToText(stack.getNodeList(), buf, wikiModel);
            }
            buf.append("\n");
        }
    }

    private void toStringSubList(InternalList list, Appendable buf) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            if (element instanceof InternalList) {
                InternalList subList = (InternalList)element;
                buf.append(subList.fChar);
                buf.append("-");
                this.toStringSubList(subList, buf);
                continue;
            }
            buf.append(element.toString());
            buf.append("\n");
        }
    }

    public String toString() {
        if (!this.isEmpty()) {
            try {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.fNestedElements.size(); ++i) {
                    Object element = this.fNestedElements.get(i);
                    if (element instanceof InternalList) {
                        InternalList subList = (InternalList)element;
                        buf.append(subList.fChar);
                        buf.append("-");
                        this.toStringSubList(subList, buf);
                        continue;
                    }
                    buf.append(element.toString());
                    buf.append("\n");
                }
                return buf.toString();
            }
            catch (IOException e) {
                return "IOException";
            }
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InternalList
    extends ArrayList<Object> {
        private static final long serialVersionUID = -3760843632697162014L;
        char fChar;

        public char getChar() {
            return this.fChar;
        }

        public InternalList(char ch) {
            this.fChar = ch;
        }
    }
}

