/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.util.WikiTagNode;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateParser
extends AbstractParser {
    private static final Pattern HTML_COMMENT_PATTERN = Pattern.compile("<!--(.*?)-->");
    public final boolean fParseOnlySignature;
    private final boolean fRenderTemplate;
    private boolean fOnlyIncludeFlag;

    public TemplateParser(String stringSource) {
        this(stringSource, false, false);
    }

    public TemplateParser(String stringSource, boolean parseOnlySignature, boolean renderTemplate) {
        super(stringSource);
        this.fParseOnlySignature = parseOnlySignature;
        this.fRenderTemplate = renderTemplate;
        this.fOnlyIncludeFlag = false;
    }

    public static void parse(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean renderTemplate) throws IOException {
        TemplateParser.parse(rawWikitext, wikiModel, writer, false, renderTemplate);
    }

    public static void parse(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean parseOnlySignature, boolean renderTemplate) throws IOException {
        TemplateParser.parseRecursive(rawWikitext, wikiModel, writer, parseOnlySignature, renderTemplate);
    }

    protected static void parseRecursive(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean parseOnlySignature, boolean renderTemplate) throws IOException {
        TemplateParser.parseRecursive(rawWikitext, wikiModel, writer, parseOnlySignature, renderTemplate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseRecursive(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean parseOnlySignature, boolean renderTemplate, Map<String, String> templateParameterMap) throws IOException {
        try {
            String redirectedContent;
            String redirectedLink;
            int level = wikiModel.incrementRecursionLevel();
            if (level > 32) {
                writer.append("Error - recursion limit exceeded parsing templates.");
                return;
            }
            if (wikiModel.incrementTemplateRecursionCount() > 100000) {
                return;
            }
            TemplateParser parser = new TemplateParser(rawWikitext, parseOnlySignature, renderTemplate);
            parser.setModel(wikiModel);
            StringBuilder sb = new StringBuilder(rawWikitext.length());
            parser.runPreprocessParser(sb, false);
            if (parseOnlySignature) {
                writer.append(sb);
                return;
            }
            int len = sb.length();
            parser = new TemplateParser(sb.toString(), false, renderTemplate);
            parser.setModel(wikiModel);
            sb = new StringBuilder(len);
            parser.runPreprocessParser(sb, true);
            StringBuilder parameterBuffer = sb;
            StringBuilder plainBuffer = sb;
            if (templateParameterMap != null && !templateParameterMap.isEmpty()) {
                String preprocessedContent = parameterBuffer.toString();
                WikipediaScanner scanner = new WikipediaScanner(preprocessedContent);
                scanner.setModel(wikiModel);
                parameterBuffer = scanner.replaceTemplateParameters(preprocessedContent, templateParameterMap);
                if (parameterBuffer != null) {
                    plainBuffer = parameterBuffer;
                }
            }
            parser = new TemplateParser(plainBuffer.toString(), parseOnlySignature, renderTemplate);
            parser.setModel(wikiModel);
            sb = new StringBuilder(plainBuffer.length());
            parser.runParser(sb);
            if (!renderTemplate && (redirectedLink = AbstractParser.parseRedirect(sb.toString(), wikiModel)) != null && (redirectedContent = AbstractParser.getRedirectedTemplateContent(wikiModel, redirectedLink, null)) != null) {
                TemplateParser.parseRecursive(redirectedContent, wikiModel, writer, parseOnlySignature, renderTemplate);
                return;
            }
            writer.append(sb);
        }
        catch (Exception e) {
            e.printStackTrace();
            writer.append(e.getClass().getSimpleName());
        }
        catch (Error e) {
            e.printStackTrace();
            writer.append(e.getClass().getSimpleName());
        }
        finally {
            wikiModel.decrementRecursionLevel();
        }
    }

    protected void runPreprocessParser(StringBuilder writer, boolean ignoreTemplateTags) throws IOException {
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
        try {
            block10: while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                switch (this.fCurrentCharacter) {
                    case '<': {
                        int htmlStartPosition = this.fCurrentPosition;
                        if (!this.fParseOnlySignature && this.parseIncludeWikiTags(writer, ignoreTemplateTags)) continue block10;
                        this.fCurrentPosition = htmlStartPosition;
                        break;
                    }
                    case '~': {
                        int tildeCounter = 0;
                        if (this.fSource[this.fCurrentPosition] != '~' || this.fSource[this.fCurrentPosition + 1] != '~') break;
                        tildeCounter = 3;
                        try {
                            if (this.fSource[this.fCurrentPosition + 2] == '~') {
                                tildeCounter = 4;
                                if (this.fSource[this.fCurrentPosition + 3] == '~') {
                                    tildeCounter = 5;
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException e1) {
                            // empty catch block
                        }
                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
                        this.fWikiModel.appendSignature(writer, tildeCounter);
                        this.fCurrentPosition += tildeCounter - 1;
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                    }
                }
                if (this.fWhiteStart) continue;
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition - 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            try {
                if (!this.fOnlyIncludeFlag) {
                    this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return;
        }
    }

    protected void runParser(Appendable writer) throws IOException {
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
        try {
            block11: while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                switch (this.fCurrentCharacter) {
                    case '{': {
                        if (this.fParseOnlySignature || !this.parseTemplateOrTemplateParameter(writer)) break;
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                        continue block11;
                    }
                    case '<': {
                        int htmlStartPosition = this.fCurrentPosition;
                        if (!this.fParseOnlySignature && this.parseSpecialWikiTags(writer)) continue block11;
                        this.fCurrentPosition = htmlStartPosition;
                        break;
                    }
                    case '~': {
                        int tildeCounter = 0;
                        if (this.fSource[this.fCurrentPosition] != '~' || this.fSource[this.fCurrentPosition + 1] != '~') break;
                        tildeCounter = 3;
                        try {
                            if (this.fSource[this.fCurrentPosition + 2] == '~') {
                                tildeCounter = 4;
                                if (this.fSource[this.fCurrentPosition + 3] == '~') {
                                    tildeCounter = 5;
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException e1) {
                            // empty catch block
                        }
                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
                        this.fWikiModel.appendSignature(writer, tildeCounter);
                        this.fCurrentPosition += tildeCounter - 1;
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                    }
                }
                if (this.fWhiteStart) continue;
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition - 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            try {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseIncludeWikiTags(StringBuilder writer, boolean ignoreTemplateTags) throws IOException {
        try {
            switch (this.fSource[this.fCurrentPosition]) {
                case '!': {
                    if (!this.parseHTMLCommentTags(writer)) return false;
                    return true;
                }
                default: {
                    if (this.fSource[this.fCurrentPosition] == '/') return false;
                    int lessThanStart = this.fCurrentPosition - 1;
                    int startPosition = this.fCurrentPosition;
                    WikiTagNode tagNode = this.parseTag(this.fCurrentPosition);
                    if (tagNode == null || tagNode.isEmptyXmlTag()) return false;
                    int tagStart = this.fCurrentPosition = tagNode.getEndPosition();
                    String tagName = tagNode.getTagName();
                    if (tagName.equals("nowiki")) {
                        if (this.readUntilIgnoreCase("</", "nowiki>")) {
                            return true;
                        }
                    } else if (tagName.equals("source")) {
                        if (this.readUntilIgnoreCase("</", "source>")) {
                            this.appendContentWithComment(writer, startPosition);
                            return true;
                        }
                    } else if (tagName.equals("math") && this.readUntilIgnoreCase("</", "math>")) {
                        return true;
                    }
                    if (ignoreTemplateTags) {
                        return false;
                    }
                    if (!this.isTemplate()) {
                        if (tagName.equals("includeonly")) {
                            if (this.readUntilIgnoreCase("</", "includeonly>")) {
                                if (!this.fOnlyIncludeFlag) {
                                    this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                }
                                this.fWhiteStart = true;
                                this.fWhiteStartPosition = tagStart;
                                if (!this.fOnlyIncludeFlag) {
                                    this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 2 + "includeonly>".length(), true);
                                }
                                this.fWhiteStart = true;
                                this.fWhiteStartPosition = this.fCurrentPosition;
                                return true;
                            }
                            if (!this.fOnlyIncludeFlag) {
                                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                            }
                            this.fWhiteStart = false;
                            this.fCurrentPosition = this.fStringSource.length();
                            return true;
                        }
                        if (tagName.equals("noinclude")) {
                            if (this.readUntilIgnoreCase("</", "noinclude>")) {
                                if (!this.fOnlyIncludeFlag) {
                                    this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                }
                                this.fWhiteStart = true;
                                this.fWhiteStartPosition = this.fCurrentPosition;
                                return true;
                            }
                            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = tagStart;
                            return true;
                        }
                        if (tagName.equals("onlyinclude")) {
                            if (this.readUntilIgnoreCase("</", "onlyinclude>")) {
                                if (!this.fOnlyIncludeFlag) {
                                    writer.delete(0, writer.length());
                                    this.fOnlyIncludeFlag = true;
                                }
                                this.fWhiteStart = true;
                                this.fWhiteStartPosition = tagStart;
                                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 2 + "onlyinclude>".length(), true);
                                this.fWhiteStart = true;
                                this.fWhiteStartPosition = this.fCurrentPosition;
                                return true;
                            }
                            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = tagStart;
                            return true;
                        }
                    } else {
                        if (tagName.equals("noinclude")) {
                            if (this.readUntilIgnoreCase("</", "noinclude>")) {
                                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                this.fWhiteStart = true;
                                this.fWhiteStartPosition = tagStart;
                                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 2 + "noinclude>".length(), true);
                                this.fWhiteStart = true;
                                this.fWhiteStartPosition = this.fCurrentPosition;
                                return true;
                            }
                            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = tagStart;
                            return true;
                        }
                        if (tagName.equals("includeonly")) {
                            if (this.readUntilIgnoreCase("</", "includeonly>")) {
                                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                this.fWhiteStart = true;
                                this.fWhiteStartPosition = this.fCurrentPosition;
                                return true;
                            }
                            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                            this.fWhiteStart = false;
                            this.fCurrentPosition = this.fStringSource.length();
                            return true;
                        }
                        if (tagName.equals("onlyinclude")) {
                            if (this.readUntilIgnoreCase("</", "onlyinclude>")) {
                                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                this.fWhiteStart = true;
                                this.fWhiteStartPosition = this.fCurrentPosition;
                                return true;
                            }
                            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = tagStart;
                            return true;
                        }
                    }
                    this.fCurrentPosition = startPosition;
                    return false;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseSpecialWikiTags(Appendable writer) throws IOException {
        try {
            switch (this.fSource[this.fCurrentPosition]) {
                case '!': {
                    if (!this.parseHTMLCommentTags(writer)) return false;
                    return true;
                }
                default: {
                    if (this.fSource[this.fCurrentPosition] == '/') return false;
                    int startPosition = this.fCurrentPosition;
                    WikiTagNode tagNode = this.parseTag(this.fCurrentPosition);
                    if (tagNode != null && !tagNode.isEmptyXmlTag()) {
                        this.fCurrentPosition = tagNode.getEndPosition();
                        String tagName = tagNode.getTagName();
                        if (tagName.equals("nowiki")) {
                            if (this.readUntilIgnoreCase("</", "nowiki>")) {
                                return true;
                            }
                        } else if (tagName.equals("source")) {
                            if (this.readUntilIgnoreCase("</", "source>")) {
                                this.appendContentWithComment(writer, startPosition);
                                return true;
                            }
                        } else if (tagName.equals("math") && this.readUntilIgnoreCase("</", "math>")) {
                            return true;
                        }
                    }
                    this.fCurrentPosition = startPosition;
                    return false;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendContent(Appendable writer, boolean whiteStart, int whiteStartPosition, int diff, boolean stripHTMLComments) throws IOException {
        if (whiteStart) {
            try {
                int whiteEndPosition = this.fCurrentPosition - diff;
                int count = whiteEndPosition - whiteStartPosition;
                if (count > 0) {
                    if (stripHTMLComments) {
                        writer.append(HTML_COMMENT_PATTERN.matcher(this.fStringSource.substring(whiteStartPosition, whiteEndPosition)).replaceAll(""));
                    } else {
                        writer.append(this.fStringSource, whiteStartPosition, whiteEndPosition);
                    }
                }
            }
            finally {
                this.fWhiteStart = false;
            }
        }
    }

    private void appendContentWithComment(Appendable writer, int startPosition) throws IOException {
        if (this.fWhiteStartPosition < startPosition - 1) {
            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - startPosition + 1, true);
        }
        this.appendContent(writer, true, startPosition - 1, 0, false);
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseTemplateOrTemplateParameter(Appendable writer) throws IOException {
        if (this.fSource[this.fCurrentPosition] != '{') return false;
        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
        int startTemplatePosition = ++this.fCurrentPosition;
        if (this.fSource[this.fCurrentPosition] == '{' && this.fSource[this.fCurrentPosition + 1] != '{') {
            int[] templateEndPosition = TemplateParser.findNestedParamEnd(this.fSource, this.fCurrentPosition + 1);
            if (templateEndPosition[0] >= 0) return this.parseTemplateParameter(writer, startTemplatePosition, templateEndPosition[0]);
            if (templateEndPosition[1] < 0) {
                --this.fCurrentPosition;
                return false;
            }
            writer.append('{');
            ++this.fCurrentPosition;
            return this.parseTemplate(writer, startTemplatePosition + 1, templateEndPosition[1]);
        }
        int templateEndPosition = TemplateParser.findNestedTemplateEnd(this.fSource, this.fCurrentPosition);
        if (templateEndPosition >= 0) return this.parseTemplate(writer, startTemplatePosition, templateEndPosition);
        --this.fCurrentPosition;
        return false;
    }

    private boolean parseTemplate(Appendable writer, int startTemplatePosition, int templateEndPosition) throws IOException {
        String function;
        int endPosition = this.fCurrentPosition = templateEndPosition;
        String plainContent = null;
        int endOffset = this.fCurrentPosition - 2;
        Object[] objs = TemplateParser.createParameterMap(this.fSource, startTemplatePosition, this.fCurrentPosition - startTemplatePosition - 2);
        List parts = (List)objs[0];
        String templateName = ((String)objs[1]).trim();
        StringBuilder buf = new StringBuilder(templateName.length() + templateName.length() / 10);
        TemplateParser.parse(templateName, this.fWikiModel, buf, false);
        templateName = buf.toString();
        int currOffset = this.checkParserFunction(templateName);
        if (currOffset > 0 && (function = templateName.substring(0, currOffset - 1).trim()) != null) {
            ITemplateFunction templateFunction = this.fWikiModel.getTemplateFunction(function);
            if (templateFunction != null) {
                parts.set(0, templateName.substring(currOffset));
                plainContent = templateFunction.parseFunction(parts, this.fWikiModel, this.fSource, startTemplatePosition + currOffset, endOffset);
                this.fCurrentPosition = endPosition;
                if (plainContent != null) {
                    TemplateParser.parseRecursive(plainContent, this.fWikiModel, writer, false, false);
                    return true;
                }
                return true;
            }
            this.fCurrentPosition = endOffset + 2;
        }
        this.fCurrentPosition = endPosition;
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        ArrayList<String> unnamedParameters = new ArrayList<String>();
        for (int i = 1; i < parts.size(); ++i) {
            if (i == parts.size() - 1) {
                TemplateParser.createSingleParameter((String)parts.get(i), parameterMap, unnamedParameters, true);
                continue;
            }
            TemplateParser.createSingleParameter((String)parts.get(i), parameterMap, unnamedParameters, false);
        }
        this.mergeParameters(parameterMap, unnamedParameters);
        this.fWikiModel.substituteTemplateCall(templateName, parameterMap, writer);
        return true;
    }

    private void mergeParameters(LinkedHashMap<String, String> parameterMap, List<String> unnamedParameters) {
        int unnamedParameterIndex = 1;
        for (String param : unnamedParameters) {
            String key;
            if (parameterMap.containsKey(key = Integer.toString(unnamedParameterIndex++))) continue;
            parameterMap.put(key, param);
        }
    }

    private boolean parseTemplateParameter(Appendable writer, int startTemplatePosition, int templateEndPosition) throws IOException {
        String plainContent = this.fStringSource.substring(startTemplatePosition - 2, templateEndPosition);
        if (plainContent != null) {
            this.fCurrentPosition = templateEndPosition;
            WikipediaScanner scanner = new WikipediaScanner(plainContent);
            scanner.setModel(this.fWikiModel);
            StringBuilder plainBuffer = scanner.replaceTemplateParameters(plainContent, null);
            if (plainBuffer == null) {
                writer.append(plainContent);
                return true;
            }
            TemplateParser.parseRecursive(plainBuffer.toString().trim(), this.fWikiModel, writer, false, false);
            return true;
        }
        return false;
    }

    private static Object[] createParameterMap(char[] src, int startOffset, int len) {
        Object[] objs = new Object[2];
        int currOffset = startOffset;
        int endOffset = startOffset + len;
        List<String> resultList = new ArrayList<String>();
        objs[0] = resultList;
        objs[1] = (resultList = TemplateParser.splitByPipe(src, currOffset, endOffset, resultList)).size() <= 1 ? new String(src, startOffset, len) : resultList.get(0);
        return objs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSingleParameter(String srcString, Map<String, String> map, List<String> unnamedParams, boolean trimNewlineRight) {
        int currOffset = 0;
        char[] src = srcString.toCharArray();
        int endOffset = srcString.length();
        String parameter = null;
        boolean equalCharParsed = false;
        int lastOffset = currOffset;
        int[] temp = new int[]{-1, -1};
        try {
            while (currOffset < endOffset) {
                char ch;
                if ((ch = src[currOffset++]) == '[' && src[currOffset] == '[') {
                    temp[0] = TemplateParser.findNestedEnd(src, '[', ']', ++currOffset);
                    if (temp[0] < 0) continue;
                    currOffset = temp[0];
                    continue;
                }
                if (ch == '{' && src[currOffset] == '{') {
                    if (src[++currOffset] == '{' && src[currOffset + 1] != '{') {
                        if ((temp = TemplateParser.findNestedParamEnd(src, ++currOffset))[0] >= 0) {
                            currOffset = temp[0];
                            continue;
                        }
                        temp[0] = TemplateParser.findNestedTemplateEnd(src, --currOffset);
                        if (temp[0] < 0) continue;
                        currOffset = temp[0];
                        continue;
                    }
                    temp[0] = TemplateParser.findNestedTemplateEnd(src, currOffset);
                    if (temp[0] < 0) continue;
                    currOffset = temp[0];
                    continue;
                }
                if (ch != '=') continue;
                if (!equalCharParsed) {
                    parameter = srcString.substring(lastOffset, currOffset - 1).trim();
                    lastOffset = currOffset;
                }
                equalCharParsed = true;
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        finally {
            if (currOffset > lastOffset) {
                String value = trimNewlineRight ? Utils.trimNewlineRight(srcString.substring(lastOffset, currOffset)) : srcString.substring(lastOffset, currOffset).trim();
                if (parameter != null) {
                    map.put(parameter, value);
                } else {
                    unnamedParams.add(value);
                }
            }
        }
    }

    private int checkParserFunction(String plainContent) {
        int currOffset = 0;
        int len = plainContent.length();
        while (currOffset < len) {
            char ch;
            if (Character.isLetter(ch = plainContent.charAt(currOffset++)) || ch == '#' || ch == '$') {
                while (currOffset < len) {
                    if ((ch = plainContent.charAt(currOffset++)) == ':') {
                        return currOffset;
                    }
                    if (Character.isLetterOrDigit(ch) || ch == '$') continue;
                    return -1;
                }
                break;
            }
            if (Character.isWhitespace(ch)) continue;
            return -1;
        }
        return -1;
    }

    protected boolean parseHTMLCommentTags(Appendable writer) throws IOException {
        int temp = this.readWhitespaceUntilStartOfLine(2);
        String htmlCommentString = this.fStringSource.substring(this.fCurrentPosition - 1, this.fCurrentPosition + 3);
        if (htmlCommentString.equals("<!--")) {
            if (temp >= 0) {
                if (!this.fOnlyIncludeFlag) {
                    this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - temp - 1, true);
                }
            } else if (!this.fOnlyIncludeFlag) {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
            }
            this.fCurrentPosition += 3;
            if (this.readUntil("-->")) {
                if (temp >= 0 && (temp = this.readWhitespaceUntilEndOfLine(0)) >= 0) {
                    ++this.fCurrentPosition;
                }
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition;
                return true;
            }
        }
        return false;
    }

    @Override
    public void runParser() {
    }

    @Override
    public void setNoToC(boolean noToC) {
    }

    public boolean isTemplate() {
        return this.fRenderTemplate;
    }
}

