/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.DateUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.memtext.util.TimeUtils;
import de.memtext.util.TransletUtils;
import de.memtext.util.XMLUtils;
import de.superx.common.DBServletException;
import de.superx.common.SxUser;
import de.superx.common.TransletCache;
import de.superx.sec.HttpGetAccessGuard;
import de.superx.sec.HttpGetAccessListParser;
import de.superx.sec.InputCheckRegistry;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.LdapPasswordChecker;
import de.superx.servlet.MaskenContainer;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.servlet.UserInitializer;
import de.superx.servlet.XUpdaterServlet;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.xml.sax.SAXException;

public class SuperXManager
extends HttpServlet {
    private static Logger logger = Logger.getLogger(SuperXManager.class);
    public static final String QIS_CONTEXT = "QIS_CONTEXT";
    private static final long serialVersionUID = 2L;
    public static final long maxMillisWaitingTime = 900000L;
    public static String his1_refapp = "";
    private SuperXInitThread initThread;
    public static boolean isZukuenftigerStandErlaubt = true;
    public static int maxRows = 20000;
    public static String defaultMaskXsl = "maske_html.xsl";
    public static String defaultTableHtmlXsl = "tabelle_html.xsl";
    public static String defaultTableXlsXsl = "tabelle_xls.xsl";
    public static String defaultTablePdfXsl = "tabelle_fo_pdf.xsl";
    public static String csvEncoding = null;
    public static String sharedSecret = "";
    private static String xmenu;
    private static String xmask;
    private static String xtablehtml;
    private static String xtablexsl;
    private static String xtablepdf;
    public static boolean isSichtenCachingWanted;
    public static String sxversion;
    public static String builddatum;
    public static HttpGetAccessGuard httpGetAccessGuard;
    private static final String ADMIN_ONLY;
    private static String pageBeginning;
    public static String pageEnd;
    public static StringBuffer activityLog;
    private static String lastFMMaskenSql;
    private static String lastMaskenSql;
    private static String lastXml;
    private static String lastMaskenSqlMandantid;
    private static String lastXmlMandantid;
    public static boolean isDevelopmentMode;
    private static boolean isLastSqlExtraPageWanted;
    public static boolean isXMLReturnLinkWanted;
    static String refererstart;
    public static String field1Cache;
    private static CacheUpdater cashUpdater;
    public static boolean isHis1;
    private static String webinfPfad;
    private static String moduleDir;
    public static boolean isResponseCompressionWanted;
    public static String sendBackLocalizedHtml;
    private static String noSessionFieldDefaults;
    private static Date start;
    private static boolean isStandaloneLdapActive;

    public static String getMaxRowsHinweis() {
        return " Die Datenbank lieferte eine gro\u00dfe Menge an Datens\u00e4tzen. Es werden generell nur die ersten " + maxRows + " dargestellt, in Datenblatt-Abfragen ggf. sogar weniger. Schr\u00e4nken Sie Ihre Abfrage ggfs. weiter ein oder nutzen den Excelexport";
    }

    public static boolean isSessionFieldDefaultsWanted(String mandantenID) {
        if (noSessionFieldDefaults == null) {
            noSessionFieldDefaults = "";
        }
        return noSessionFieldDefaults.indexOf("," + mandantenID + ",") == -1;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.debug((Object)"SuperXManager start.");
        start = new Date();
        webinfPfad = this.getServletConfig().getServletContext().getRealPath("/WEB-INF");
        try {
            this.initLdapPasswordCheckingIfConfigured();
            this.initThread = new SuperXInitThread(config);
            this.initThread.start();
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    public static String getWEB_INFPfad() {
        return webinfPfad;
    }

    public static void setWEB_INFPfad(String p) {
        webinfPfad = p;
    }

    private void initXSLFilenames() {
        xmenu = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/menue_html.xsl");
        xmask = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/" + defaultMaskXsl);
        xtablehtml = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/" + defaultTableHtmlXsl);
        xtablexsl = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/" + defaultTableXlsXsl);
        xtablepdf = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/" + defaultTablePdfXsl);
    }

    public static void initStandardXsl() throws TransformerConfigurationException, DBServletException {
        TransletCache.getTransformer(null, xmenu);
        TransletCache.getTransformer(null, xmask);
        TransletCache.getTransformer(null, xtablehtml);
        TransletCache.getTransformer(null, xtablexsl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        super.destroy();
        try {
            if (this.initThread != null) {
                this.initThread.destroy();
            }
            SxPools.closeAll();
            cashUpdater.setActive(false);
            cashUpdater.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Enumeration<Driver> en = DriverManager.getDrivers();
            while (en.hasMoreElements()) {
                Driver d = en.nextElement();
                try {
                    DriverManager.deregisterDriver(d);
                    logger.info((Object)(new Date() + "{} deregister {}" + d));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AbstractSuperXServlet.setEncoding(request);
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        if (ServletHelper.getParameter(request, "kennung") != null && ServletHelper.getParameter(request, "passwort") != null) {
            UserInitializer ui = new UserInitializer(request, false);
            try {
                ui.perform();
            }
            catch (Exception e) {
                throw new ServletException("Authentifizierung f\u00fcr " + ServletHelper.getParameter(request, "kennung") + " fehlgeschlagen");
            }
        }
        if (request.getParameter("xupdater") != null) {
            XUpdaterServlet xu = new XUpdaterServlet();
            xu.doPost(request, response);
        } else {
            SxUser user = (SxUser)request.getSession().getAttribute("user");
            if (user == null || !user.isAdmin()) {
                PrintWriter output = response.getWriter();
                output.write(ADMIN_ONLY);
                output.flush();
            } else {
                SxManager m = new SxManager(request, response);
                m.run(false);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        SxUser user = (SxUser)request.getSession().getAttribute("user");
        if (user == null || !user.isAdmin()) {
            PrintWriter output = response.getWriter();
            output.write(ADMIN_ONLY);
            output.flush();
            output.close();
        } else if (request.getParameter("xupdater") != null) {
            XUpdaterServlet xu = new XUpdaterServlet();
            xu.doGet(request, response);
        } else {
            boolean isLastSqlXmlWantend;
            PrintWriter output = response.getWriter();
            String showLastSqlXml = ServletHelper.getParameter(request, "showlastsqlxml");
            boolean bl = isLastSqlXmlWantend = showLastSqlXml != null && showLastSqlXml.equals("true");
            if (isLastSqlXmlWantend) {
                output.write(pageBeginning + this.getLastSqlXml(request) + pageEnd);
            } else {
                output.write(this.getStandardPage(request, "") + pageEnd);
            }
            output.flush();
            output.close();
        }
    }

    private String getLastSqlXml(HttpServletRequest currentreq) {
        StringBuffer result = new StringBuffer("<br>");
        String m = ServletUtils.getMandantenID(currentreq);
        if (m.equalsIgnoreCase(lastMaskenSqlMandantid)) {
            result.append("<center><table><tr>");
            result.append("<td><p align=center><b>letzter Masken sql (vom XML-Frontend)<br>vor FreeMarker-Transformation</b></p><textarea name=\"sql\" rows=20 cols=50>" + lastFMMaskenSql + "</textarea></td>");
            result.append("<td><p align=center><b>letzter Masken sql (vom XML-Frontend)</b></p><textarea name=\"sql\" rows=20 cols=50>" + lastMaskenSql + "</textarea></td><td><p align=center><b>letztes XML</b></p><textarea name=\"xml\" rows=20 cols=50>" + lastXml + "</textarea></td></tr></table></center>");
        } else {
            result.append("Bitte wiederholen Sie den Aufruf mit dem jew. Mandant");
        }
        return result.toString();
    }

    public String getStandardPage(HttpServletRequest request, String comment) {
        String m = ServletUtils.getMandantenID(request);
        StringBuffer result = new StringBuffer(pageBeginning + (m.equals("default") ? "" : "<center>(Mandant: " + m + ")<br>\n") + "\n<br><center><form action=\"SuperXManager\" method=post>" + comment + "\n<br><br><input type=submit name=\"cache\" value=\"Server-Cache aktualisieren\">&nbsp;<input type=submit name=\"clearStylesheets\" value=\"nur Stylesheet-Cache leeren\"></font><br><font>Es werden Erl&auml;uterungen und &Uuml;bersetzungen (captions) gecacht.<br>F&uuml;rs XML-Frontend auch: User,Userrechte und Sichten,<br> und auch Abfragen wenn in der db.properties eingetragen</font> <br><br><font size=+1>Entwicklungsmodus ist " + (isDevelopmentMode ? "AN" : "AUS") + " <input type=radio name=\"Entwicklungsmodus\" value=\"an\"" + (isDevelopmentMode ? "checked" : "") + ">an\n<input type=radio name=\"Entwicklungsmodus\" value=\"aus\"" + (!isDevelopmentMode ? "checked" : "") + ">aus\n\n</font><input type=submit value=\"&Uuml;bernehmen\"><br>(Im Entwicklungsmodus werden alle SQL-Befehle von Abfragen einzeln an die Datenbank geschickt.<br>Das dauert l&auml;nger, erm&ouml;glicht aber bessere Fehlermeldungen.)<br><br>Achtung: bei Informix sollten Sie den Entwicklungsmodus nicht ausschalten, der JDBC-Treiber arbeitet dann instabil.<br><br>\n<br><br><input type=submit name=\"clearlogfiles\" value=\"Log-Dateien leeren\"><br>\n");
        result.append("</form>");
        if (isLastSqlExtraPageWanted) {
            result.append(this.getLastSqlXml(request));
        } else {
            result.append("<a href=\"SuperXManager?showlastsqlxml=true\" target=\"_blank\">letzter SQL / XML</a><br><br><hr>");
        }
        result.append("<center><h2>LOG  <a href=\"SuperXManager\">aktualisieren<a/></h2><br>" + activityLog + "<br><hr><a href=\"SuperXManager\">LOG aktualisieren<a/>");
        result.append("<br><br>" + SxPools.getPoolFinRechteInfos());
        result.append(pageEnd);
        return result.toString();
    }

    public static void setLastMaskenSql(String sql) {
        lastMaskenSql = sql;
    }

    public static String getLastMaskenSql() {
        return lastMaskenSql;
    }

    public static void setLastXml(String xml) {
        lastXml = xml;
    }

    public static String getLastXml() {
        return lastXml;
    }

    public static String getLastMaskenSqlMandantid() {
        return lastMaskenSqlMandantid;
    }

    public static void setLastMaskenSqlMandantid(String lastMaskenSqlMandantid) {
        SuperXManager.lastMaskenSqlMandantid = lastMaskenSqlMandantid;
    }

    public static String getLastXmlMandantid() {
        return lastXmlMandantid;
    }

    public static void setLastXmlMandantid(String lastXmlMandantid) {
        SuperXManager.lastXmlMandantid = lastXmlMandantid;
    }

    static synchronized void initAll() throws KeyParentEqualException, NichtAngemeldetException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException, DBServletException, TransformerException {
        SxPools.resetAllPools();
        logger.debug((Object)(" using encoding: " + SqlStringUtils.getEncoding()));
        SuperXManager.clearTransletStylesheets();
    }

    public static void initPool(HttpServletRequest request, String mandantenID) throws TransformerConfigurationException, SQLException, DBServletException, IOException {
        logger.debug((Object)(DateUtils.getNowString() + " Server Cache wird neu geladen f\u00fcr :" + mandantenID));
        MaskenContainer mc = MaskenContainer.getFromRequest(request);
        mc.clear();
        if (mandantenID.equals("default")) {
            SxPools.resetAllPools();
        } else {
            SxPools.get(mandantenID).init();
        }
        logger.debug((Object)(" using encoding: " + SqlStringUtils.getEncoding()));
        SuperXManager.clearTransletStylesheets();
        SuperXManager.initStandardXsl();
    }

    public static void clearTransletStylesheets() throws TransformerConfigurationException, DBServletException {
        logger.debug((Object)(DateUtils.getNowString() + " Stylesheet-Cache geleert"));
        TransletCache.clear();
    }

    public String getServletInfo() {
        return "SuperXManager";
    }

    public static void clearLog() {
        activityLog.setLength(0);
    }

    public static void logActivity(Level level, String log) {
        if (level == null) {
            level = Level.INFO;
        }
        activityLog.append(TimeUtils.getNowString() + " " + log + "<br>");
    }

    public static String getLastFMMaskenSql() {
        return lastFMMaskenSql;
    }

    public static void setLastFMMaskenSql(String lastFMMaskenSql) {
        SuperXManager.lastFMMaskenSql = lastFMMaskenSql;
    }

    public static void main(String[] args) {
        System.out.println("SuperX 5.2 (build:05.09.2025 10:03)");
        System.out.println(SqlStringUtils.getEncoding());
    }

    public static void initKettleEnv() {
        try {
            KettleEnvironment.init();
            KettleLogStore.init();
            logger.debug((Object)"Kettle environment sucessfully initialized.");
        }
        catch (KettleException e) {
            logger.error((Object)"Couldn't initialize KettleEnvironment!", (Throwable)e);
        }
    }

    public static String htmlPageHead(String title) {
        String ret = "<html><head><title>" + title + "</title><link rel=\"stylesheet\" type=\"text/css\" href=\"../style/superx.css\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"/superx/xml/his1/css/HISinOneErrorMessages.css\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"../style/bulma.css\" /><META HTTP-EQUIV=\"CACHE-CONTROL\" CONTENT=\"NO-CACHE\" /> <META HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\" /> <META HTTP-EQUIV=\"EXPIRES\" CONTENT=\"0\"/><link rel=\"stylesheet\" type=\"text/css\" href=\"../xml/superxml_html.css\" /></head>\n<body><div class=\"box\">\n";
        if (isHis1) {
            ret = ret + "<link rel='stylesheet' type='text/css' href='/superx/xml/his1/css/HISinOne.css'>\n<a href='/superx/servlet/SuperXmlAbmeldung' target='_parent' style='cursor:pointer; font-weight: bold;' class='ui-link'>Abmelden von Standardberichte</a>";
        }
        return ret;
    }

    public static void setModuleDir(String md) {
        moduleDir = md;
    }

    public static String getModuleDir() {
        return moduleDir;
    }

    private void initLdapPasswordCheckingIfConfigured() {
        File superxStandaloneLdapConfigFile = new File(webinfPfad + File.separator + "superx_standalone_ldap.properties");
        if (superxStandaloneLdapConfigFile.exists()) {
            System.out.println(" Passwortkontrolle via LDAP wird aktiviert");
            isStandaloneLdapActive = true;
            try {
                LdapPasswordChecker.setup(superxStandaloneLdapConfigFile);
            }
            catch (Exception e) {
                System.out.println(" Konfiguration Passwordkontrolle via LDAP fehlgeschlagen " + e);
                e.printStackTrace();
            }
        }
    }

    public static boolean isStandaloneLdapActive() {
        return isStandaloneLdapActive;
    }

    private void initHttpGetAccessGuard() {
        httpGetAccessGuard = new HttpGetAccessGuard();
        String blacklist_filename = SuperXManager.getWEB_INFPfad() + File.separator + "http_get_masken_blacklist.txt";
        String blacklist_custom_filename = SuperXManager.getWEB_INFPfad() + File.separator + "http_get_masken_blacklist_custom.txt";
        String whitelist_filename = SuperXManager.getWEB_INFPfad() + File.separator + "http_get_masken_whitelist.txt";
        httpGetAccessGuard.setBlacklist(this.parseWhiteBlacklistFile(blacklist_filename));
        httpGetAccessGuard.setBlacklist_custom(this.parseWhiteBlacklistFile(blacklist_custom_filename));
        httpGetAccessGuard.setWhitelist(this.parseWhiteBlacklistFile(whitelist_filename));
    }

    private Set<Integer> parseWhiteBlacklistFile(String list_filename) {
        File list_file = new File(list_filename);
        if (list_file.exists()) {
            try {
                String content = StringUtils.readFile(list_file);
                return HttpGetAccessListParser.parseList(content);
            }
            catch (IOException e) {
                logger.error((Object)("could not read file '" + list_file.getAbsolutePath()));
            }
            catch (NumberFormatException e) {
                logger.error((Object)("could not parse file '" + list_file.getAbsolutePath()), (Throwable)e);
            }
        }
        return null;
    }

    static {
        isSichtenCachingWanted = true;
        sxversion = "5.2";
        builddatum = "05.09.2025 10:03";
        ADMIN_ONLY = SuperXManager.htmlPageHead("Admin-Bereich") + "<center><h3>Hier ist ein Login nur f\u00fcr Administratoren m&ouml;glich.</h3>(Cookies m&uuml;ssen aktiviert sein)<FORM ACTION=\"SuperXManager\" METHOD=\"post\"><p><p>Kennung: <br /><INPUT TYPE=\"Text\" NAME=\"kennung\" VALUE=\"superx\"></p><p><p>Passwort: <br /><INPUT TYPE=\"Password\" NAME=\"passwort\" value=\"\"></p><p>MandantenID<br><input type=\"text\" name=\"MandantenID\" value=\"default\"></p><br><INPUT TYPE=\"Submit\" NAME=\"Abschicken\" VALUE=\"Anmelden\"></FORM></center></body></html>";
        pageBeginning = SuperXManager.htmlPageHead("Webanwendung Manager") + "<h1 align=center>SuperX Manager</h1><center>SuperX 5.2 (build:05.09.2025 10:03)</center>";
        pageEnd = "</div></body></html>";
        activityLog = new StringBuffer();
        lastMaskenSql = "--";
        lastXml = "--";
        lastMaskenSqlMandantid = "";
        lastXmlMandantid = "--";
        isDevelopmentMode = true;
        isLastSqlExtraPageWanted = true;
        isXMLReturnLinkWanted = true;
        refererstart = null;
        cashUpdater = new CacheUpdater();
        isHis1 = false;
        webinfPfad = ".";
        moduleDir = "";
        isResponseCompressionWanted = true;
        sendBackLocalizedHtml = "";
        start = null;
        isStandaloneLdapActive = false;
    }

    private static final class CacheUpdater
    extends Thread {
        private Date lastUpdate;
        private boolean isActive = true;

        private CacheUpdater() {
        }

        @Override
        public void run() {
            while (this.isActive) {
                Date now = new Date();
                try {
                    Thread.sleep(1800000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (now.getHours() != 7 || this.lastUpdate != null && this.lastUpdate.getDay() == now.getDay()) continue;
                try {
                    logger.info((Object)(DateUtils.getTodayString() + " " + DateUtils.getNowString() + " Server-Cache-Aktualisierung"));
                    SuperXManager.initAll();
                    this.lastUpdate = now;
                }
                catch (Exception e) {
                    logger.error((Object)"Server-Cache-Aktualisierung fehlgeschlagen:", (Throwable)e);
                }
            }
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }

    class SuperXInitThread
    extends Thread {
        private ServletConfig config;
        private boolean isDestroyWanted = false;

        public SuperXInitThread(ServletConfig config) throws SecurityException, IOException {
            this.config = config;
        }

        public void destroy() {
            this.isDestroyWanted = true;
        }

        @Override
        public void run() {
            logger.debug((Object)"SuperXInit thread start.");
            while (!(this.isDestroyWanted || System.getProperty("SuperX-DB-PROPERTIES-SET") != null && System.getProperty("SuperX-DB-PROPERTIES-SET").equalsIgnoreCase("true"))) {
                long totalTimeWaiting = System.currentTimeMillis() - start.getTime();
                try {
                    Thread.sleep(4000L);
                    logger.info((Object)("SuperXInit waiting. Total: " + Long.valueOf(totalTimeWaiting) + "millis"));
                    if (totalTimeWaiting <= 900000L) continue;
                    throw new InterruptedException("*** SuperXManager timeout!\nJava System-Property SuperX-DB-PROPERTIES-SET not set!\nHISinOne Business Intelligence may not be usable!\nPlease check if Module EDUSTORE in modules.xml is active\nand EdustoreManager has run correctly on HISinOne startup! ***");
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"SuperXinit interrupted!", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            isHis1 = true;
            logger.debug((Object)"Webanwendung Manager startet - SuperX-DB-PROPERTIES-SET=true gefunden");
            try {
                this.doInit();
            }
            catch (ServletException e) {
                e.printStackTrace();
                throw new IllegalStateException("SuperX Init fehlgeschlagen " + e.getMessage());
            }
        }

        private void doInit() throws ServletException {
            String sichtcache;
            String lh;
            String rc;
            String f1;
            String mxr;
            String xsl_parser;
            String last_sql_extra_page;
            String xmlReturnLink;
            String zukuenftigerStandErlaubt;
            SuperXManager.this.initHttpGetAccessGuard();
            InputCheckRegistry.registerDefaultChecks();
            his1_refapp = System.getProperty(SuperXManager.QIS_CONTEXT);
            if (his1_refapp == null) {
                his1_refapp = "";
            } else {
                logger.debug((Object)("SuperX found HisInOne webapp: " + his1_refapp));
            }
            XMLUtils.getExceptionHandler().setWithGui(false);
            XMLUtils.getExceptionHandler().setExitWanted(false);
            ServletUtils.setPath(SuperXManager.this.getServletConfig().getServletContext().getRealPath("xml"));
            SuperXManager.this.initXSLFilenames();
            refererstart = this.config.getInitParameter("referer_start");
            if (refererstart != null && !refererstart.trim().equals("")) {
                logger.debug((Object)("Referer wird kontrolliert auf " + refererstart));
            }
            if ((zukuenftigerStandErlaubt = this.config.getInitParameter("zuk\u00fcnftigerStandErlaubt")) != null && zukuenftigerStandErlaubt.equals("false")) {
                isZukuenftigerStandErlaubt = false;
            }
            if ((xmlReturnLink = this.config.getInitParameter("xml_return_link")) != null && xmlReturnLink.equals("false")) {
                isXMLReturnLinkWanted = false;
            }
            if ((last_sql_extra_page = this.config.getInitParameter("last_sql_extra_page")) != null && last_sql_extra_page.equals("false")) {
                isLastSqlExtraPageWanted = false;
            }
            if ((xsl_parser = this.config.getInitParameter("xsl_processor")) != null) {
                TransletUtils.initFactory(xsl_parser, "org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
            } else {
                TransletUtils.initFactory("net.sf.saxon.TransformerFactoryImpl", null);
            }
            logger.debug((Object)("Using xsl processor: " + TransletUtils.getUsedProcessor()));
            sharedSecret = this.config.getInitParameter("sharedSecret");
            if (sharedSecret == null) {
                sharedSecret = "";
            }
            if ((mxr = this.config.getInitParameter("maxRows")) != null && !mxr.equals("")) {
                maxRows = Integer.parseInt(mxr);
            }
            logger.warn((Object)("SuperXManager: maxRows: " + Integer.valueOf(maxRows) + " (wenn mehr geliefert wird, werden die zusaetzlichen Datenzeilen ignoriert)"));
            String moduleDir = "";
            String defaultXsl = this.config.getInitParameter("defaultMaskXsl");
            if (defaultXsl != null && !defaultXsl.trim().equals("")) {
                defaultMaskXsl = defaultXsl;
                logger.debug((Object)("SuperXManager: defaultMaskXsl: " + defaultMaskXsl));
                if (defaultXsl.equals("maske_html_his1.xsl")) {
                    isHis1 = true;
                    moduleDir = SuperXManager.getWEB_INFPfad() + File.separator + "conf" + File.separator + "edustore" + File.separator + "db" + File.separator + "module";
                } else {
                    isHis1 = false;
                    moduleDir = System.getProperty("MODULE_PFAD") != null && !System.getProperty("MODULE_PFAD").toString().equals("") ? System.getProperty("MODULE_PFAD").toString() : SuperXManager.getWEB_INFPfad() + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + "db" + File.separator + "module";
                }
                logger.debug((Object)("SuperXManager: MODULE_PFAD: " + moduleDir));
                SuperXManager.setModuleDir(moduleDir);
            }
            if ((defaultXsl = this.config.getInitParameter("defaultTableHtmlXsl")) != null && !defaultXsl.trim().equals("")) {
                defaultTableHtmlXsl = defaultXsl;
                logger.debug((Object)("SuperXManager: defaultTableHtmlXsl: " + defaultTableHtmlXsl));
            }
            if ((defaultXsl = this.config.getInitParameter("defaultTableXlsXsl")) != null && !defaultXsl.trim().equals("")) {
                defaultTableXlsXsl = defaultXsl;
                logger.debug((Object)("SuperXManager: defaultTableXlsXsl: " + defaultTableXlsXsl));
            }
            if ((defaultXsl = this.config.getInitParameter("defaultTablePdfXsl")) != null && !defaultXsl.trim().equals("")) {
                defaultTablePdfXsl = defaultXsl;
                logger.debug((Object)("SuperXManager: defaultTablePdfXsl: " + defaultTablePdfXsl));
            }
            if ((f1 = this.config.getInitParameter("field1Cache")) != null && !f1.equals("")) {
                field1Cache = f1;
            }
            if ((rc = this.config.getInitParameter("isResponseCompressionWanted")) != null && rc.equalsIgnoreCase("false")) {
                isResponseCompressionWanted = false;
            }
            if ((lh = this.config.getInitParameter("sendBackLocalizedHtml")) != null && !lh.equalsIgnoreCase("")) {
                sendBackLocalizedHtml = lh;
            }
            if ((sichtcache = this.config.getInitParameter("sichtenCaching")) != null && sichtcache.equalsIgnoreCase("false")) {
                isSichtenCachingWanted = false;
            }
            noSessionFieldDefaults = "," + this.config.getInitParameter("noSessionFieldDefaults") + ",";
            if (noSessionFieldDefaults == null) {
                noSessionFieldDefaults = "";
            }
            csvEncoding = (csvEncoding = this.config.getInitParameter("CSV-Encoding")) == null || csvEncoding.equalsIgnoreCase("") ? SqlStringUtils.getEncoding() : csvEncoding.trim();
            try {
                SuperXManager.initKettleEnv();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Kettle konnte nicht initialisiert werden.DETAILS:" + e.getMessage());
            }
            try {
                SxPools.init();
                SuperXManager.initAll();
                SuperXManager.initStandardXsl();
                cashUpdater.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServletException("SuperX konnte nicht initialisiert werden.DETAILS:" + e.getMessage());
            }
            logger.debug((Object)("SuperXInit finished after " + (new Date().getTime() - start.getTime()) + " millis"));
        }
    }

    private class SxManager
    extends SuperXServletHelper {
        public SxManager(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
        }

        @Override
        protected void perform() throws IOException, IllegalArgumentException, SecurityException, KeyParentEqualException, NichtAngemeldetException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException, DBServletException, TransformerException {
            String comment = "";
            if (this.request.getParameterMap().containsKey("cache")) {
                SuperXManager.initPool(this.request, this.getMandantenID());
                SuperXManager.initStandardXsl();
                comment = "Resources neu geladen: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            }
            if (this.request.getParameterMap().containsKey("clearStylesheets")) {
                SuperXManager.clearTransletStylesheets();
                comment = "Stylesheet-Cache geleert: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            }
            if (this.request.getParameterMap().containsKey("clearlogfiles")) {
                SxPools.clearLogFiles();
                comment = "LogDateien geleert";
            }
            if (ServletHelper.getParameter(this.request, "Entwicklungsmodus") != null) {
                isDevelopmentMode = ServletHelper.getParameter(this.request, "Entwicklungsmodus").equals("an");
            }
            PrintWriter output = this.response.getWriter();
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            output.write(SuperXManager.this.getStandardPage(this.request, comment));
            output.write(pageEnd);
            output.flush();
        }
    }
}

