/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl;

import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.servlet.SuperXManager;
import de.superx.util.PathAndFileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EtlUtils {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String PATHSEP = File.separator;
    public static String WEBINFDIR = SuperXManager.getWEB_INFPfad();
    public static String SUPERX_DIR = System.getProperties().containsKey("SUPERX_DIR") ? System.getProperty("SUPERX_DIR") : "";
    public static String MODUL_ROOT_PFAD = System.getProperties().containsKey("MODULE_PFAD") ? System.getProperty("MODULE_PFAD") : SUPERX_DIR + PATHSEP + "db" + PATHSEP + "module";
    public static String MODUL_ROHDATEN_SUBPFAD = PATHSEP + "rohdaten" + PATHSEP;

    public static void main(String[] args) {
        String webinfdir = PathAndFileUtils.getWebinfDirectory();
        System.out.println("WEB-INF:" + webinfdir);
    }

    public static Properties convertStringToProperty(String inp) throws IOException {
        Properties myProps = new Properties();
        myProps.load(new StringReader(inp));
        return myProps;
    }

    public static Properties mergeParamProperties(Properties params, Properties runTimeParams) {
        if (params == null) {
            params = runTimeParams;
        } else {
            Enumeration<?> runTimeParamNames = runTimeParams.propertyNames();
            while (runTimeParamNames.hasMoreElements()) {
                String runTimeParamName = (String)runTimeParamNames.nextElement();
                String runTimeParamValue = runTimeParams.getProperty(runTimeParamName);
                Enumeration<?> paramNames = params.propertyNames();
                while (paramNames.hasMoreElements()) {
                    String paramName = (String)paramNames.nextElement();
                    String paramValue = params.getProperty(paramName);
                    if (paramName.equals(runTimeParamName)) {
                        paramValue = runTimeParamValue;
                        params.setProperty(paramName, paramValue);
                    }
                    if (paramValue.indexOf("$" + runTimeParamName) <= -1) continue;
                    paramValue = StringUtils.replace(paramValue, "$" + runTimeParamName, runTimeParamValue);
                    params.setProperty(paramName, paramValue);
                }
            }
        }
        return params;
    }

    public static String parseStringAgainstParams(String targetString, Properties params) {
        Enumeration<?> paramNames = params.propertyNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = params.getProperty(paramName);
            if (targetString.indexOf("$" + paramName) <= -1) continue;
            targetString = StringUtils.replace(targetString, "$" + paramName, paramValue);
        }
        return targetString;
    }

    public static void initJobEnvironment() {
        String initVar = "";
        if (System.getProperty("WEBINFDIR") == null) {
            try {
                initVar = SuperXManager.getWEB_INFPfad();
                if (initVar == null || initVar.equals(".")) {
                    initVar = PathAndFileUtils.getWebinfDirectory();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            WEBINFDIR = initVar;
        }
        if (System.getProperty("SUPERX_DIR") == null) {
            SUPERX_DIR = WEBINFDIR + PATHSEP + "conf" + PATHSEP + "edustore";
        }
    }

    private static String getJarName() {
        return new File(EtlUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
    }

    private static boolean runningFromJar() {
        String jarName = EtlUtils.getJarName();
        return jarName.contains(".jar");
    }

    public static String getFileContentsWithEncoding(String filePath, String encoding) {
        File f = new File(filePath);
        if (!f.exists()) {
            System.out.println("Fehler: Datei " + filePath + " existiert nicht.");
            return null;
        }
        String fileContents = "";
        if (encoding == null || encoding.trim().equals("")) {
            encoding = System.getProperty("file.encoding");
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
            StringWriter out = new StringWriter();
            String text = in.readLine();
            while (text != null) {
                out.write(text);
                out.write(System.getProperty("line.separator"));
                text = in.readLine();
            }
            if (out != null) {
                fileContents = out.toString();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileContents;
    }

    public static void saveFileContentsWithEncoding(String filename, String contents, String encoding) throws FileNotFoundException, IOException {
        File f = new File(filename);
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding));
        out.write(contents);
        out.close();
    }

    public static Document buildDocumentFromXmlFile(String srcFile) throws ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        FileInputStream in = new FileInputStream(srcFile);
        InputSource is = new InputSource(in);
        Document mydomres = builder.newDocument();
        mydomres = builder.parse(is);
        return mydomres;
    }

    public static Document parseXml(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory myFactory = DocumentBuilderFactory.newInstance();
        myFactory.setNamespaceAware(true);
        DocumentBuilder myBuilder = myFactory.newDocumentBuilder();
        Document myDocument = myBuilder.parse(new InputSource(new StringReader(xmlString)));
        return myDocument;
    }

    public static boolean isNodeValueInXml(String src, String searchPath, String expectedValue) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        String foundValue;
        boolean b = false;
        Document mydomres = EtlUtils.parseXml(src);
        XPathFactoryImpl factory = new XPathFactoryImpl();
        XPath xPath = factory.newXPath();
        Node myNode = (Node)xPath.compile(searchPath).evaluate(mydomres, XPathConstants.NODE);
        if (myNode != null && (foundValue = XMLUtils.getTheValue(myNode)) != null && foundValue.trim().equals(expectedValue)) {
            b = true;
        }
        return b;
    }

    public static String translateReturnCode(int returnCode) {
        String returnString = "Fehlerhaft";
        if (returnCode == 0) {
            returnString = "Erfolg";
        }
        return returnString;
    }
}

