/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.db.ConnectionCreator;
import de.memtext.util.DateUtils;
import de.memtext.util.StringUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class MaskenSqlUpdater {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("usage: MaskenSqlUpdater DB_PROPERTIES maskennummer sourcefile");
            System.exit(1);
        }
        Connection con = null;
        int tid = Integer.parseInt(args[1]);
        try {
            con = ConnectionCreator.getConnectionCryptPassword(args[0], "driverName", "connectionURL", "connectionName", "connectionPassword");
        }
        catch (Exception e) {
            System.out.println("ERROR: Verbindung konnte nicht aufgebaut werden.\n" + e);
            System.exit(1);
        }
        try {
            String sql = StringUtils.readFile(new File(args[2]));
            Statement stm = con.createStatement();
            PreparedStatement pst = con.prepareStatement("update maskeninfo set select_stmt=? where tid=?");
            pst.setString(1, sql);
            pst.setInt(2, tid);
            int rows = pst.executeUpdate();
            if (rows == 0) {
                throw new IllegalArgumentException("Wahrscheinlich gibt es keine Maske mit der tid " + tid);
            }
            System.out.println("update erfolgreich auf " + con.getMetaData().getURL() + " um " + DateUtils.getNowString());
            stm.close();
            con.close();
        }
        catch (Exception e) {
            System.out.println("ERROR:" + e);
        }
    }
}

